/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.lti.ws4j.util;

import edu.cmu.lti.jawjaw.pobj.POS;
import edu.cmu.lti.lexical_db.data.Concept;
import edu.cmu.lti.ws4j.RelatednessCalculator;
import edu.cmu.lti.ws4j.util.PathFinder;
import edu.cmu.lti.ws4j.util.WS4JConfiguration;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class ICFinder {
    private static final ICFinder instance = new ICFinder();
    private ConcurrentMap<Integer, Integer> freqV;
    private ConcurrentMap<Integer, Integer> freqN;
    private static final int rootFreqN = 128767;
    private static final int rootFreqV = 95935;

    private ICFinder() {
        try {
            this.loadIC();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ICFinder getInstance() {
        return instance;
    }

    private synchronized void loadIC() throws IOException {
        String icFilename = WS4JConfiguration.getInstance().getInfoContent();
        this.freqV = new ConcurrentHashMap<Integer, Integer>();
        this.freqN = new ConcurrentHashMap<Integer, Integer>();
        InputStream stream = ICFinder.class.getResourceAsStream("/" + icFilename);
        InputStreamReader isr = new InputStreamReader(stream);
        BufferedReader br = new BufferedReader(isr);
        String line = null;
        while ((line = br.readLine()) != null) {
            String[] elements = line.split(" ");
            if (elements.length < 2) continue;
            String e = elements[0];
            POS pos = POS.valueOf((String)e.substring(e.length() - 1));
            int id = Integer.parseInt(e.substring(0, e.length() - 1));
            int freq = Integer.parseInt(elements[1]);
            if (pos.equals((Object)POS.n)) {
                this.freqN.put(id, freq);
                continue;
            }
            if (!pos.equals((Object)POS.v)) continue;
            this.freqV.put(id, freq);
        }
        br.close();
        isr.close();
    }

    public List<PathFinder.Subsumer> getLCSbyIC(PathFinder pathFinder, Concept synset1, Concept synset2, StringBuilder tracer) {
        List<PathFinder.Subsumer> paths = pathFinder.getAllPaths(synset1, synset2, tracer);
        if (paths == null || paths.size() == 0) {
            return null;
        }
        for (PathFinder.Subsumer path : paths) {
            path.ic = this.ic(pathFinder, path.subsumer);
        }
        Collections.sort(paths, new Comparator<PathFinder.Subsumer>(){

            @Override
            public int compare(PathFinder.Subsumer s1, PathFinder.Subsumer s2) {
                if (s1.ic < s2.ic) {
                    return 1;
                }
                if (s1.ic > s2.ic) {
                    return -1;
                }
                return 0;
            }
        });
        ArrayList<PathFinder.Subsumer> results = new ArrayList<PathFinder.Subsumer>(paths.size());
        for (PathFinder.Subsumer path : paths) {
            if (path.ic != paths.get((int)0).ic) continue;
            results.add(path);
        }
        return results;
    }

    public double ic(PathFinder pathFinder, Concept synset) {
        POS pos = synset.getPos();
        if (pos.equals((Object)POS.n) || pos.equals((Object)POS.v)) {
            double prob = this.probability(pathFinder, synset);
            return prob > 0.0 ? -Math.log(prob) : 0.0;
        }
        return 0.0;
    }

    private static int synsetToId(String synset) {
        return Integer.parseInt(synset.replaceFirst("^[0]+", "").replaceFirst("-[nvar]", ""));
    }

    private double probability(PathFinder pathFinder, Concept synset) {
        Concept rootSynset = pathFinder.getRoot(synset.getSynset());
        int rootFreq = 0;
        if (RelatednessCalculator.useRootNode) {
            if (synset.getPos().equals((Object)POS.n)) {
                rootFreq = 128767;
            } else if (synset.getPos().equals((Object)POS.v)) {
                rootFreq = 95935;
            }
        } else {
            rootFreq = this.getFrequency(rootSynset);
        }
        int offFreq = this.getFrequency(synset);
        if (offFreq <= rootFreq) {
            return (double)offFreq / (double)rootFreq;
        }
        return 0.0;
    }

    public int getFrequency(Concept synset) {
        if (synset.getSynset().equals("0")) {
            if (synset.getPos().equals((Object)POS.n)) {
                return 128767;
            }
            if (synset.getPos().equals((Object)POS.v)) {
                return 95935;
            }
        }
        int synsetId = ICFinder.synsetToId(synset.getSynset());
        int freq = 0;
        if (synset.getPos().equals((Object)POS.n)) {
            Integer freqObj = (Integer)this.freqN.get(synsetId);
            freq = freqObj != null ? freqObj : 0;
        } else if (synset.getPos().equals((Object)POS.v)) {
            Integer freqObj = (Integer)this.freqV.get(synsetId);
            freq = freqObj != null ? freqObj : 0;
        }
        return freq;
    }
}

