/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.lti.ws4j.util;

import edu.cmu.lti.jawjaw.JAWJAW;
import edu.cmu.lti.jawjaw.pobj.POS;
import edu.cmu.lti.ws4j.RelatednessCalculator;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;

public class MatrixCalculator {
    public static double[][] getSimilarityMatrix(String[] words1, String[] words2, RelatednessCalculator rc) {
        double[][] result = new double[words1.length][words2.length];
        for (int i = 0; i < words1.length; ++i) {
            for (int j = 0; j < words2.length; ++j) {
                double score;
                result[i][j] = score = rc.calcRelatednessOfWords(words1[i], words2[j]);
            }
        }
        return result;
    }

    public static double[][] getNormalizedSimilarityMatrix(String[] words1, String[] words2, RelatednessCalculator rc) {
        int j;
        int i;
        double[][] scores = MatrixCalculator.getSimilarityMatrix(words1, words2, rc);
        double bestScore = 1.0;
        for (i = 0; i < scores.length; ++i) {
            for (j = 0; j < scores[i].length; ++j) {
                if (!(scores[i][j] > bestScore) || scores[i][j] == Double.MAX_VALUE) continue;
                bestScore = scores[i][j];
            }
        }
        for (i = 0; i < scores.length; ++i) {
            for (j = 0; j < scores[i].length; ++j) {
                if (scores[i][j] == Double.MAX_VALUE) {
                    scores[i][j] = 1.0;
                    continue;
                }
                double[] dArray = scores[i];
                int n = j;
                dArray[n] = dArray[n] / bestScore;
            }
        }
        return scores;
    }

    public static double[][] getSynonymyMatrix(String[] words1, String[] words2) {
        LinkedHashSet synonyms;
        ArrayList synonyms1 = new ArrayList(words1.length);
        ArrayList synonyms2 = new ArrayList(words2.length);
        for (int i = 0; i < words1.length; ++i) {
            synonyms = new LinkedHashSet();
            for (POS pos : POS.values()) {
                synonyms.addAll(JAWJAW.findSynonyms((String)words1[i], (POS)pos));
            }
            synonyms1.add(synonyms);
        }
        for (int j = 0; j < words2.length; ++j) {
            synonyms = new LinkedHashSet();
            for (POS pos : POS.values()) {
                synonyms.addAll(JAWJAW.findSynonyms((String)words2[j], (POS)pos));
            }
            synonyms2.add(synonyms);
        }
        double[][] result = new double[words1.length][words2.length];
        for (int i = 0; i < words1.length; ++i) {
            for (int j = 0; j < words2.length; ++j) {
                String w1 = words1[i];
                String w2 = words2[j];
                if (w1.equals(w2)) {
                    result[i][j] = 1.0;
                    continue;
                }
                Set s1 = (Set)synonyms1.get(i);
                Set s2 = (Set)synonyms2.get(j);
                result[i][j] = s1.contains(w2) || s2.contains(w1) ? 1.0 : 0.0;
            }
        }
        return result;
    }
}

