/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.lti.ws4j.util;

import edu.cmu.lti.ws4j.util.CollectionUtil;
import edu.cmu.lti.ws4j.util.StopWordRemover;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class OverlapFinder {
    private static final String MARKER = "###";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Overlaps getOverlaps(String gloss1, String gloss2) {
        int length;
        String string0 = gloss1;
        String string1 = gloss2;
        Overlaps overlaps = new Overlaps();
        String[] words0 = string0.split("\\s+");
        String[] words1 = string1.split("\\s+");
        words0 = StopWordRemover.getInstance().removeStopWords(words0);
        words1 = StopWordRemover.getInstance().removeStopWords(words1);
        gloss1 = CollectionUtil.join(" ", words0);
        gloss2 = CollectionUtil.join(" ", words1);
        overlaps.length1 = words0.length;
        overlaps.length2 = words1.length;
        HashMap<Integer, Integer> overlapsLengths = new HashMap<Integer, Integer>();
        int matchStartIndex = 0;
        int currIndex = -1;
        while (currIndex < words0.length - 1) {
            if (OverlapFinder.contains(words1, words0, matchStartIndex, ++currIndex)) continue;
            overlapsLengths.put(matchStartIndex, currIndex - matchStartIndex);
            if (overlapsLengths.get(matchStartIndex) != null && (Integer)overlapsLengths.get(matchStartIndex) > 0) {
                --currIndex;
            }
            ++matchStartIndex;
        }
        for (int i = matchStartIndex; i <= currIndex; ++i) {
            overlapsLengths.put(i, currIndex - i + 1);
        }
        int longestOverlap = -1;
        Iterator iterator = overlapsLengths.values().iterator();
        while (iterator.hasNext()) {
            length = (Integer)iterator.next();
            if (longestOverlap >= length) continue;
            longestOverlap = length;
        }
        overlaps.overlapsHash = new ConcurrentHashMap<String, Integer>(overlapsLengths.size());
        while (longestOverlap > 0) {
            for (int i = 0; i <= overlapsLengths.size() - 1; ++i) {
                int stringEndNew;
                int k;
                if ((Integer)overlapsLengths.get(i) < longestOverlap) continue;
                int stringEnd = i + longestOverlap - 1;
                if (OverlapFinder.containsReplace(words1, words0, i, stringEnd)) {
                    int j;
                    ArrayList<String> words0Sub = new ArrayList<String>(stringEnd - i + 1);
                    for (int j2 = i; j2 <= stringEnd; ++j2) {
                        words0Sub.add(words0[j2]);
                    }
                    String temp = CollectionUtil.join(" ", words0Sub);
                    ConcurrentMap<String, Integer> concurrentMap = overlaps.overlapsHash;
                    synchronized (concurrentMap) {
                        int v = overlaps.overlapsHash.get(temp) != null ? (Integer)overlaps.overlapsHash.get(temp) : 0;
                        overlaps.overlapsHash.put(temp, v + 1);
                    }
                    for (j = i; j < i + longestOverlap; ++j) {
                        overlapsLengths.put(j, 0);
                    }
                    for (j = i - 1; j >= 0 && (Integer)overlapsLengths.get(j) > i - j; --j) {
                        overlapsLengths.put(j, i - j);
                    }
                    continue;
                }
                for (k = longestOverlap - 1; k > 0 && !OverlapFinder.contains(words1, words0, i, stringEndNew = i + k - 1); --k) {
                }
                overlapsLengths.put(i, k);
            }
            longestOverlap = -1;
            iterator = overlapsLengths.values().iterator();
            while (iterator.hasNext()) {
                length = (Integer)iterator.next();
                if (longestOverlap >= length) continue;
                longestOverlap = length;
            }
        }
        return overlaps;
    }

    private static boolean contains(String[] words1, String[] words2, int begin, int end) {
        return OverlapFinder.contains(words1, words2, begin, end, false);
    }

    private static boolean containsReplace(String[] words1, String[] words2, int begin, int end) {
        return OverlapFinder.contains(words1, words2, begin, end, true);
    }

    private static boolean contains(String[] words1, String[] words2, int begin, int end, boolean doReplace) {
        String[] words2Sub = new String[end - begin + 1];
        for (int i = 0; i < end - begin + 1; ++i) {
            words2Sub[i] = words2[begin + i];
        }
        words2 = words2Sub;
        if (words1.length < words2.length) {
            return false;
        }
        for (int j = 0; j <= words1.length - words2.length; ++j) {
            if (words1[j].equals(MARKER) || !words2[0].equals(words1[j])) continue;
            boolean match = true;
            for (int i = 1; i < words2.length; ++i) {
                if (!words1[j + i].equals(MARKER) && words2[i].equals(words1[j + i])) continue;
                match = false;
                break;
            }
            if (!match) continue;
            if (doReplace) {
                for (int k = j; k < j + words2.length; ++k) {
                    words1[k] = MARKER;
                }
            }
            return true;
        }
        return false;
    }

    public static class Overlaps {
        public ConcurrentMap<String, Integer> overlapsHash;
        public int length1;
        public int length2;
    }
}

