/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.lti.ws4j.util;

import edu.cmu.lti.lexical_db.ILexicalDatabase;
import edu.cmu.lti.lexical_db.data.Concept;
import edu.cmu.lti.ws4j.util.CollectionUtil;
import edu.cmu.lti.ws4j.util.WS4JConfiguration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class PathFinder {
    private ILexicalDatabase db;
    private static ConcurrentMap<String, List<List<String>>> cache;

    public PathFinder(ILexicalDatabase db) {
        this.db = db;
    }

    public List<Subsumer> getAllPaths(Concept synset1, Concept synset2, StringBuilder tracer) {
        ArrayList<Subsumer> paths = new ArrayList<Subsumer>();
        HashSet<String> history = new HashSet<String>();
        List<List<String>> lTrees = this.getHypernymTrees(synset1.getSynset(), history);
        history = new HashSet();
        List<List<String>> rTrees = this.getHypernymTrees(synset2.getSynset(), history);
        if (lTrees == null || rTrees == null) {
            return null;
        }
        for (List<String> lTree : lTrees) {
            for (List<String> rTree : rTrees) {
                String subsumer = PathFinder.getSubsumerFromTrees(lTree, rTree);
                if (subsumer == null) continue;
                int lCount = 0;
                ArrayList<String> lpath = new ArrayList<String>(lTree.size());
                List<String> reversedLTree = CollectionUtil.reverse(lTree);
                for (String synset : reversedLTree) {
                    ++lCount;
                    if (synset.equals(subsumer)) break;
                    lpath.add(synset);
                }
                int rCount = 0;
                ArrayList<String> rpath = new ArrayList<String>(rTree.size());
                List<String> reversedRTree = CollectionUtil.reverse(rTree);
                for (String synset : reversedRTree) {
                    ++rCount;
                    if (synset.equals(subsumer)) break;
                    rpath.add(synset);
                }
                Subsumer sub = new Subsumer();
                sub.subsumer = new Concept(subsumer, synset1.getPos(), null, null);
                sub.length = rCount + lCount - 1;
                sub.lpath = lpath;
                sub.rpath = rpath;
                paths.add(sub);
                if (tracer == null) continue;
                tracer.append("HyperTree1:");
                for (String synset : lTree) {
                    tracer.append(" " + this.db.conceptToString(synset));
                }
                tracer.append("\n");
                tracer.append("HyperTree2:");
                for (String synset : rTree) {
                    tracer.append(" " + this.db.conceptToString(synset));
                }
                tracer.append("\n");
            }
        }
        Collections.sort(paths, new Comparator<Subsumer>(){

            @Override
            public int compare(Subsumer s1, Subsumer s2) {
                if (s1.length > s2.length) {
                    return 1;
                }
                if (s1.length < s2.length) {
                    return -1;
                }
                return 0;
            }
        });
        return paths;
    }

    public List<Subsumer> getShortestPaths(Concept synset1, Concept synset2, StringBuilder tracer) {
        ArrayList<Subsumer> returnList = new ArrayList<Subsumer>();
        List<Subsumer> paths = this.getAllPaths(synset1, synset2, tracer);
        if (paths == null || paths.size() == 0) {
            return returnList;
        }
        int bestLength = paths.get((int)0).length;
        returnList.add(paths.get(0));
        for (int i = 1; i < paths.size() && paths.get((int)i).length <= bestLength; ++i) {
            returnList.add(paths.get(i));
        }
        return returnList;
    }

    private static String getSubsumerFromTrees(List<String> list1, List<String> list2) {
        List<String> tree1 = CollectionUtil.reverse(list1);
        List<String> tree2 = CollectionUtil.reverse(list2);
        String tree1Joined = " " + CollectionUtil.join(" ", tree1) + " ";
        for (String synset2 : tree2) {
            if (tree1Joined.indexOf(synset2) == -1) continue;
            return synset2;
        }
        return null;
    }

    public List<List<String>> getHypernymTrees(String synset, Set<String> history) {
        List cachedObj;
        WS4JConfiguration.getInstance().setCache(false);
        String key = synset;
        if (WS4JConfiguration.getInstance().useCache() && (cachedObj = (List)cache.get(key)) != null) {
            return PathFinder.clone(cachedObj);
        }
        if (synset.equals("0")) {
            ArrayList<String> tree = new ArrayList<String>();
            tree.add("0");
            ArrayList<List<String>> trees = new ArrayList<List<String>>();
            trees.add(tree);
            if (WS4JConfiguration.getInstance().useCache()) {
                if (cache.size() >= WS4JConfiguration.getInstance().getMaxCacheSize()) {
                    cache.remove(cache.keySet().iterator().next());
                }
                if (trees != null) {
                    cache.put(key, PathFinder.clone(trees));
                }
            }
            return trees;
        }
        List synlinks = (List)this.db.getHypernyms(synset);
        ArrayList<List<String>> returnList = new ArrayList<List<String>>();
        if (synlinks.size() == 0) {
            ArrayList<String> tree = new ArrayList<String>();
            tree.add(synset);
            tree.add(0, "0");
            returnList.add(tree);
        } else {
            for (String hypernym : synlinks) {
                if (history.contains(hypernym)) continue;
                history.add(hypernym);
                List<List<String>> hypernymTrees = this.getHypernymTrees(hypernym, history);
                if (hypernymTrees != null) {
                    for (List<String> hypernymTree : hypernymTrees) {
                        hypernymTree.add(synset);
                        returnList.add(hypernymTree);
                    }
                }
                if (returnList.size() != 0) continue;
                ArrayList<String> newList = new ArrayList<String>();
                newList.add(synset);
                newList.add(0, "0");
                returnList.add(newList);
            }
        }
        if (WS4JConfiguration.getInstance().useCache()) {
            if (cache.size() >= WS4JConfiguration.getInstance().getMaxCacheSize()) {
                cache.remove(cache.keySet().iterator().next());
            }
            if (returnList != null) {
                cache.put(key, PathFinder.clone(returnList));
            }
        }
        return returnList;
    }

    public Concept getRoot(String synset) {
        HashSet<String> history = new HashSet<String>();
        List<List<String>> paths = this.getHypernymTrees(synset, history);
        if (paths != null && paths.size() > 0 && paths.get(0).size() > 1) {
            return new Concept(paths.get(0).get(1));
        }
        if (paths != null && paths.size() > 0) {
            return new Concept(paths.get(0).get(0));
        }
        return null;
    }

    public List<Subsumer> getLCSByPath(Concept synset1, Concept synset2, StringBuilder tracer) {
        List<Subsumer> paths = this.getAllPaths(synset1, synset2, tracer);
        ArrayList<Subsumer> returnList = new ArrayList<Subsumer>(paths.size());
        if (paths == null) {
            return returnList;
        }
        for (Subsumer path : paths) {
            if (path.length > paths.get((int)0).length) continue;
            returnList.add(path);
        }
        return returnList;
    }

    private static List<List<String>> clone(List<List<String>> original) {
        ArrayList<List<String>> clone = new ArrayList<List<String>>(original.size());
        for (List<String> oStrings : original) {
            ArrayList<String> cStrings = new ArrayList<String>(oStrings.size());
            for (String oString : oStrings) {
                cStrings.add(oString);
            }
            clone.add(cStrings);
        }
        return clone;
    }

    static {
        if (WS4JConfiguration.getInstance().useCache()) {
            cache = new ConcurrentHashMap<String, List<List<String>>>(WS4JConfiguration.getInstance().getMaxCacheSize());
        }
    }

    public static class Subsumer {
        public Concept subsumer;
        public int length;
        public double ic;
        public List<String> lpath;
        public List<String> rpath;

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{ ");
            sb.append("\"subsumer\" : \"" + this.subsumer + "\", ");
            sb.append("\"length\" : \"" + this.length + "\", ");
            sb.append("\"ic\" : \"" + this.ic + "\", ");
            sb.append("\"lpath\" : \"" + this.lpath + "\", ");
            sb.append("\"rpath\" : \"" + this.rpath + "\"");
            sb.append(" }");
            return sb.toString();
        }
    }
}

