/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.lti.ws4j.util;

import edu.cmu.lti.ws4j.util.CollectionUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PorterStemmer {
    private static final String c = "(?:[^aiueoy]|(?:(?<=[aiueo])y)|\by)";
    private static final String v = "(?:[aiueo]|(?:(?<![aiueo])y))";
    private static final Pattern pV = Pattern.compile("(?:[aiueo]|(?:(?<![aiueo])y))");
    int extra = 0;
    private static final Pattern m_gt_0 = Pattern.compile("^(?:(?:[^aiueoy]|(?:(?<=[aiueo])y)|\by)+)?(?:(?:[aiueo]|(?:(?<![aiueo])y))+(?:[^aiueoy]|(?:(?<=[aiueo])y)|\by)+){1,}(?:(?:[aiueo]|(?:(?<![aiueo])y))+)?$");
    private static final Pattern m_gt_1 = Pattern.compile("^(?:(?:[^aiueoy]|(?:(?<=[aiueo])y)|\by)+)?(?:(?:[aiueo]|(?:(?<![aiueo])y))+(?:[^aiueoy]|(?:(?<=[aiueo])y)|\by)+){2,}(?:(?:[aiueo]|(?:(?<![aiueo])y))+)?$");
    private static final Pattern m_eq_1 = Pattern.compile("^(?:(?:[^aiueoy]|(?:(?<=[aiueo])y)|\by)+)?(?:(?:[aiueo]|(?:(?<![aiueo])y))+(?:[^aiueoy]|(?:(?<=[aiueo])y)|\by)+){1}(?:(?:[aiueo]|(?:(?<![aiueo])y))+)?$");
    private static final Pattern pO = Pattern.compile("(?:[^aiueoy]|(?:(?<=[aiueo])y)|\by)(?:[aiueo]|(?:(?<![aiueo])y))(?:[^aiueowxy])$");
    private static final Pattern pD = Pattern.compile("((?:[^aiueoy]|(?:(?<=[aiueo])y)|\by))\\1$");
    private static final Pattern p_sses = Pattern.compile("(.+)sses$");
    private static final Pattern p_ies = Pattern.compile("(.+)ies$");
    private static final Pattern p_s = Pattern.compile("(.+[^s])s$");
    private static final Pattern p_eed = Pattern.compile("(.+)eed$");
    private static final Pattern p_ed = Pattern.compile("(.+)ed$");
    private static final Pattern p_ing = Pattern.compile("(.+)ing$");
    private static final Pattern p_at = Pattern.compile("(.+)at$");
    private static final Pattern p_bl = Pattern.compile("(.+)bl$");
    private static final Pattern p_iz = Pattern.compile("(.+)iz$");
    private static final Pattern p_pD = pD;
    private static final Pattern p_lsz = Pattern.compile("[lsz]$");
    private static final Pattern p1b_9 = m_eq_1;
    private static final Pattern p1b_10 = pO;
    private static final Pattern p_y = Pattern.compile("(.+)y$");
    private static final Pattern p_ational = Pattern.compile("(.+)ational$");
    private static final Pattern p_tional = Pattern.compile("(.+)tional$");
    private static final Pattern p_enci = Pattern.compile("(.+)enci$");
    private static final Pattern p_anci = Pattern.compile("(.+)anci$");
    private static final Pattern p_izer = Pattern.compile("(.+)izer$");
    private static final Pattern p_logi = Pattern.compile("(.+)logi$");
    private static final Pattern p_bli = Pattern.compile("(.+)bli$");
    private static final Pattern p_alli = Pattern.compile("(.+)alli$");
    private static final Pattern p_entli = Pattern.compile("(.+)entli$");
    private static final Pattern p_eli = Pattern.compile("(.+)eli$");
    private static final Pattern p_ousli = Pattern.compile("(.+)ousli$");
    private static final Pattern p_ization = Pattern.compile("(.+)ization$");
    private static final Pattern p_ation = Pattern.compile("(.+)ation$");
    private static final Pattern p_ator = Pattern.compile("(.+)ator$");
    private static final Pattern p_alism = Pattern.compile("(.+)alism$");
    private static final Pattern p_iveness = Pattern.compile("(.+)iveness$");
    private static final Pattern p_fulness = Pattern.compile("(.+)fulness$");
    private static final Pattern p_ousness = Pattern.compile("(.+)ousness$");
    private static final Pattern p_aliti = Pattern.compile("(.+)aliti$");
    private static final Pattern p_iviti = Pattern.compile("(.+)iviti$");
    private static final Pattern p_biliti = Pattern.compile("(.+)biliti$");
    private static final Pattern p_icate = Pattern.compile("(.+)icate$");
    private static final Pattern p_ative = Pattern.compile("(.+)ative$");
    private static final Pattern p_alize = Pattern.compile("(.+)alize$");
    private static final Pattern p_iciti = Pattern.compile("(.+)iciti$");
    private static final Pattern p_ical = Pattern.compile("(.+)ical$");
    private static final Pattern p_ful = Pattern.compile("(.+)ful$");
    private static final Pattern p_ness = Pattern.compile("(.+)ness$");
    private static final Pattern p_al = Pattern.compile("(.+)al$");
    private static final Pattern p_ance = Pattern.compile("(.+)ance$");
    private static final Pattern p_ence = Pattern.compile("(.+)ence$");
    private static final Pattern p_er = Pattern.compile("(.+)er$");
    private static final Pattern p_ic = Pattern.compile("(.+)ic$");
    private static final Pattern p_able = Pattern.compile("(.+)able$");
    private static final Pattern p_ible = Pattern.compile("(.+)ible$");
    private static final Pattern p_ant = Pattern.compile("(.+)ant$");
    private static final Pattern p_ement = Pattern.compile("(.+)ement$");
    private static final Pattern p_ment = Pattern.compile("(.+)ment$");
    private static final Pattern p_ent = Pattern.compile("(.+)ent$");
    private static final Pattern p_ion = Pattern.compile("(.+)ion$");
    private static final Pattern p_st = Pattern.compile("[st]$");
    private static final Pattern p_ou = Pattern.compile("(.+)ou$");
    private static final Pattern p_ism = Pattern.compile("(.+)ism$");
    private static final Pattern p_ate = Pattern.compile("(.+)ate$");
    private static final Pattern p_iti = Pattern.compile("(.+)iti$");
    private static final Pattern p_ous = Pattern.compile("(.+)ous$");
    private static final Pattern p_ive = Pattern.compile("(.+)ive$");
    private static final Pattern p_ize = Pattern.compile("(.+)ize$");
    private static final Pattern p5_1 = Pattern.compile("(.+)e$");
    private static final Pattern p5_2 = Pattern.compile("ll$");

    public String stemWord(String word) {
        StringWrapper w = new StringWrapper(word);
        if (w.word.length() > 2) {
            w = this.step1(w);
            w = this.step2(w);
            w = this.step3(w);
            w = this.step4(w);
            w = this.step5(w);
        }
        return w.word;
    }

    private StringWrapper step1(StringWrapper w) {
        Matcher m1a_1 = p_sses.matcher(w.word);
        Matcher m1a_2 = p_ies.matcher(w.word);
        Matcher m1a_3 = p_s.matcher(w.word);
        if (m1a_1.find()) {
            w.word = m1a_1.group(1) + "ss";
        } else if (m1a_2.find()) {
            w.word = m1a_2.group(1) + "i";
        } else if (m1a_3.find()) {
            w.word = m1a_3.group(1);
        }
        Matcher m_eed = p_eed.matcher(w.word);
        Matcher m_ed = p_ed.matcher(w.word);
        Matcher m_ing = p_ing.matcher(w.word);
        if (m_eed.find()) {
            if (m_gt_0.matcher(m_eed.group(1)).find()) {
                w.word = m_eed.group(1) + "ee";
            }
        } else if (m_ed.find()) {
            if (pV.matcher(m_ed.group(1)).find()) {
                w.word = m_ed.group(1);
                this.extra = 1;
            }
        } else if (m_ing.find() && pV.matcher(m_ing.group(1)).find()) {
            w.word = m_ing.group(1);
            this.extra = 1;
        }
        Matcher m_ate = p_at.matcher(w.word);
        Matcher m_bl = p_bl.matcher(w.word);
        Matcher m_iz = p_iz.matcher(w.word);
        Matcher m_pD = p_pD.matcher(w.word);
        Matcher m_lsz = p_lsz.matcher(w.word);
        Matcher m1b_9 = p1b_9.matcher(w.word);
        Matcher m1b_10 = p1b_10.matcher(w.word);
        if (this.extra > 0) {
            if (m_ate.find()) {
                w.word = m_ate.group(1) + "ate";
            } else if (m_bl.find()) {
                w.word = m_bl.group(1) + "ble";
            } else if (m_iz.find()) {
                w.word = m_iz.group(1) + "ize";
            } else if (m_pD.find() && !m_lsz.find()) {
                w.word = w.word.substring(0, w.word.length() - 1);
            } else if (m1b_9.find() && m1b_10.find()) {
                w.word = w.word + "e";
            }
        }
        this.sub(w, p_y, pV, "i");
        return w;
    }

    private StringWrapper step2(StringWrapper w) {
        String letter = w.word.substring(w.word.length() - 2, w.word.length() - 1);
        if (letter.equals("a")) {
            if (!this.sub(w, p_ational, m_gt_0, "ate") && this.sub(w, p_tional, m_gt_0, "tion")) {
                // empty if block
            }
        } else if (letter.equals("c")) {
            if (!this.sub(w, p_enci, m_gt_0, "ence") && this.sub(w, p_anci, m_gt_0, "ance")) {
                // empty if block
            }
        } else if (letter.equals("e")) {
            this.sub(w, p_izer, m_gt_0, "ize");
        } else if (letter.equals("g")) {
            this.sub(w, p_logi, m_gt_0, "log");
        } else if (letter.equals("l") ? !this.sub(w, p_bli, m_gt_0, "ble") && !this.sub(w, p_alli, m_gt_0, "al") && !this.sub(w, p_entli, m_gt_0, "ent") && !this.sub(w, p_eli, m_gt_0, "e") && this.sub(w, p_ousli, m_gt_0, "ous") : (letter.equals("o") ? !this.sub(w, p_ization, m_gt_0, "ize") && !this.sub(w, p_ation, m_gt_0, "ate") && this.sub(w, p_ator, m_gt_0, "ate") : (letter.equals("s") ? !this.sub(w, p_alism, m_gt_0, "al") && !this.sub(w, p_iveness, m_gt_0, "ive") && !this.sub(w, p_fulness, m_gt_0, "ful") && this.sub(w, p_ousness, m_gt_0, "ous") : !letter.equals("t") || this.sub(w, p_aliti, m_gt_0, "al") || this.sub(w, p_iviti, m_gt_0, "ive") || this.sub(w, p_biliti, m_gt_0, "ble")))) {
            // empty if block
        }
        return w;
    }

    private StringWrapper step3(StringWrapper w) {
        String letter = w.word.substring(w.word.length() - 1);
        if (letter.equals("e")) {
            if (!this.sub(w, p_icate, m_gt_0, "ic") && !this.sub(w, p_ative, m_gt_0, "") && this.sub(w, p_alize, m_gt_0, "al")) {
                // empty if block
            }
        } else if (letter.equals("i")) {
            this.sub(w, p_iciti, m_gt_0, "ic");
        } else if (letter.equals("l")) {
            if (!this.sub(w, p_ical, m_gt_0, "ic") && this.sub(w, p_ful, m_gt_0, "")) {
                // empty if block
            }
        } else if (letter.equals("s")) {
            this.sub(w, p_ness, m_gt_0, "");
        }
        return w;
    }

    /*
     * Enabled aggressive block sorting
     */
    private StringWrapper step4(StringWrapper w) {
        String letter = w.word.substring(w.word.length() - 2, w.word.length() - 1);
        if (letter.equals("a")) {
            this.sub(w, p_al, m_gt_1, "");
            return w;
        }
        if (letter.equals("c")) {
            if (this.sub(w, p_ance, m_gt_1, "")) {
                return w;
            }
            if (!this.sub(w, p_ence, m_gt_1, "")) return w;
            return w;
        }
        if (letter.equals("e")) {
            this.sub(w, p_er, m_gt_1, "");
            return w;
        }
        if (letter.equals("i")) {
            this.sub(w, p_ic, m_gt_1, "");
            return w;
        }
        if (letter.equals("l")) {
            if (this.sub(w, p_able, m_gt_1, "")) {
                return w;
            }
            if (!this.sub(w, p_ible, m_gt_1, "")) return w;
            return w;
        }
        if (letter.equals("n")) {
            if (this.sub(w, p_ant, m_gt_1, "")) {
                return w;
            }
            if (this.sub(w, p_ement, m_gt_1, "")) {
                return w;
            }
            if (this.sub(w, p_ment, m_gt_1, "")) {
                return w;
            }
            if (!this.sub(w, p_ent, m_gt_1, "")) return w;
            return w;
        }
        if (letter.equals("o")) {
            Matcher m_ion = p_ion.matcher(w.word);
            if (m_ion.find()) {
                if (!p_st.matcher(m_ion.group(1)).find()) return w;
                if (!m_gt_1.matcher(m_ion.group(1)).find()) return w;
                w.word = m_ion.group(1);
                return w;
            }
            if (!this.sub(w, p_ou, m_gt_1, "")) return w;
            return w;
        } else {
            if (letter.equals("s")) {
                this.sub(w, p_ism, m_gt_1, "");
                return w;
            }
            if (letter.equals("t")) {
                if (this.sub(w, p_ate, m_gt_1, "")) {
                    return w;
                }
                if (!this.sub(w, p_iti, m_gt_1, "")) return w;
                return w;
            }
            if (letter.equals("u")) {
                this.sub(w, p_ous, m_gt_1, "");
                return w;
            }
            if (letter.equals("v")) {
                this.sub(w, p_ive, m_gt_1, "");
                return w;
            }
            if (!letter.equals("z")) return w;
            this.sub(w, p_ize, m_gt_1, "");
        }
        return w;
    }

    private StringWrapper step5(StringWrapper w) {
        Matcher m5_2;
        Matcher m5_1 = p5_1.matcher(w.word);
        if (m5_1.find() && (m_gt_1.matcher(m5_1.group(1)).find() || m_eq_1.matcher(m5_1.group(1)).find() && pO.matcher(m5_1.group(1)).find())) {
            w.word = m5_1.group(1);
        }
        if ((m5_2 = p5_2.matcher(w.word)).find() && m_gt_1.matcher(w.word).find()) {
            w.word = w.word.substring(0, w.word.length() - 1);
        }
        return w;
    }

    private boolean sub(StringWrapper w, Pattern p1, Pattern p2, String postfix) {
        Matcher m = p1.matcher(w.word);
        boolean matched = m.find();
        if (matched && p2.matcher(m.group(1)).find()) {
            w.word = m.group(1) + postfix;
        }
        return matched;
    }

    public String[] stemWords(String[] words) {
        String[] stemmedWords = new String[words.length];
        for (int i = 0; i < words.length; ++i) {
            stemmedWords[i] = this.stemWord(words[i]);
        }
        return stemmedWords;
    }

    public String stemSentence(String sentence) {
        String[] words = this.stemWords(sentence.split("\\s+"));
        return CollectionUtil.join(" ", words);
    }

    static class StringWrapper {
        public String word;

        public StringWrapper(String word) {
            this.word = word;
        }
    }
}

