/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.lti.ws4j.util;

import edu.cmu.lti.ws4j.util.WS4JConfiguration;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;

public final class StopWordRemover {
    private static final StopWordRemover instance = new StopWordRemover();
    private Set<String> stoplist;

    private StopWordRemover() {
        try {
            this.loadStopList();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static StopWordRemover getInstance() {
        return instance;
    }

    private synchronized void loadStopList() throws IOException {
        String stoplistFilename = WS4JConfiguration.getInstance().getStopList();
        this.stoplist = new LinkedHashSet<String>(256);
        InputStream stream = StopWordRemover.class.getResourceAsStream("/" + stoplistFilename);
        InputStreamReader isr = new InputStreamReader(stream);
        BufferedReader br = new BufferedReader(isr);
        String line = null;
        while ((line = br.readLine()) != null) {
            String stopword = line.trim();
            if (stopword.length() <= 0) continue;
            this.stoplist.add(stopword);
        }
        br.close();
        isr.close();
    }

    public String[] removeStopWords(String[] words) {
        ArrayList<String> contents = new ArrayList<String>(words.length);
        for (String word : words) {
            if (this.stoplist.contains(word)) continue;
            contents.add(word);
        }
        String[] result = contents.toArray(new String[contents.size()]);
        return result;
    }
}

