/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.lti.ws4j.util;

import edu.cmu.lti.jawjaw.db.SynlinkDAO;
import edu.cmu.lti.jawjaw.pobj.Link;
import edu.cmu.lti.jawjaw.pobj.Synlink;
import edu.cmu.lti.jawjaw.pobj.Word;
import edu.cmu.lti.jawjaw.util.WordNetUtil;
import edu.cmu.lti.lexical_db.data.Concept;
import edu.cmu.lti.ws4j.util.WS4JConfiguration;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class Traverser {
    private static ConcurrentMap<String, Set<String>> horizonCache;
    private static ConcurrentMap<String, Set<String>> upwardCache;
    private static ConcurrentMap<String, Set<String>> downwardCache;
    public static int capacity;

    public static boolean contained(Concept synset1, Concept synset2) {
        if (synset1 == null || synset2 == null) {
            return false;
        }
        List wordsH = WordNetUtil.synsetToWords((String)synset1.getSynset());
        List wordsN = WordNetUtil.synsetToWords((String)synset2.getSynset());
        for (Word wordH : wordsH) {
            for (Word wordN : wordsN) {
                if (wordH.getLemma().indexOf(wordN.getLemma()) == -1 && wordN.getLemma().indexOf(wordH.getLemma()) == -1) continue;
                return true;
            }
        }
        return false;
    }

    public static Set<String> getHorizontalSynsets(String synset) {
        Set cachedObj;
        String key = synset;
        if (WS4JConfiguration.getInstance().useCache() && (cachedObj = (Set)horizonCache.get(key)) != null) {
            return cachedObj;
        }
        ArrayList<Link> links = new ArrayList<Link>();
        links.add(Link.ants);
        links.add(Link.attr);
        links.add(Link.sim);
        Set<String> result = Traverser.getGroupedSynsets(synset, links);
        if (WS4JConfiguration.getInstance().useCache()) {
            if (horizonCache.size() >= WS4JConfiguration.getInstance().getMaxCacheSize()) {
                horizonCache.remove(horizonCache.keySet().iterator().next());
            }
            if (result != null) {
                horizonCache.put(key, result);
            }
        }
        return result;
    }

    public static Set<String> getUpwardSynsets(String synset) {
        Set cachedObj;
        String key = synset;
        if (WS4JConfiguration.getInstance().useCache() && (cachedObj = (Set)upwardCache.get(key)) != null) {
            return cachedObj;
        }
        ArrayList<Link> links = new ArrayList<Link>();
        links.add(Link.hype);
        links.add(Link.mero);
        links.add(Link.mmem);
        links.add(Link.mprt);
        links.add(Link.msub);
        Set<String> result = Traverser.getGroupedSynsets(synset, links);
        if (WS4JConfiguration.getInstance().useCache()) {
            if (upwardCache.size() >= WS4JConfiguration.getInstance().getMaxCacheSize()) {
                upwardCache.remove(upwardCache.keySet().iterator().next());
            }
            if (result != null) {
                upwardCache.put(key, result);
            }
        }
        return result;
    }

    public static Set<String> getDownwardSynsets(String synset) {
        Set cachedObj;
        String key = synset;
        if (WS4JConfiguration.getInstance().useCache() && (cachedObj = (Set)downwardCache.get(key)) != null) {
            return cachedObj;
        }
        ArrayList<Link> links = new ArrayList<Link>();
        links.add(Link.caus);
        links.add(Link.enta);
        links.add(Link.holo);
        links.add(Link.hmem);
        links.add(Link.hsub);
        links.add(Link.hprt);
        links.add(Link.hypo);
        Set<String> result = Traverser.getGroupedSynsets(synset, links);
        if (WS4JConfiguration.getInstance().useCache()) {
            if (downwardCache.size() >= WS4JConfiguration.getInstance().getMaxCacheSize()) {
                downwardCache.remove(downwardCache.keySet().iterator().next());
            }
            if (result != null) {
                downwardCache.put(key, result);
            }
        }
        return result;
    }

    private static Set<String> getGroupedSynsets(String synset, List<Link> links) {
        ArrayList synlinks = new ArrayList();
        for (Link link : links) {
            synlinks.addAll(SynlinkDAO.findSynlinksBySynsetAndLink((String)synset, (Link)link));
        }
        LinkedHashSet<String> synsets = new LinkedHashSet<String>(synlinks.size());
        for (Synlink synlink : synlinks) {
            synsets.add(synlink.getSynset2());
        }
        return synsets;
    }

    static {
        if (WS4JConfiguration.getInstance().useCache()) {
            capacity = WS4JConfiguration.getInstance().getMaxCacheSize();
            horizonCache = new ConcurrentHashMap<String, Set<String>>(capacity);
            upwardCache = new ConcurrentHashMap<String, Set<String>>(capacity);
            downwardCache = new ConcurrentHashMap<String, Set<String>>(capacity);
        }
    }
}

