/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.lti.ws4j.util;

import java.io.InputStream;
import java.util.Properties;

public final class WS4JConfiguration {
    private static final String CONF = "/similarity.conf";
    private static final WS4JConfiguration instance = new WS4JConfiguration();
    private Properties p;
    private boolean trace;
    private boolean cache;
    private int maxCacheSize;
    private String infoContent;
    private boolean stem;
    private String stopList;
    private boolean leskNormalize;
    private boolean mfs;

    private WS4JConfiguration() {
        InputStream stream = null;
        try {
            stream = WS4JConfiguration.class.getResourceAsStream(CONF);
            this.p = new Properties();
            this.p.load(stream);
            this.cache = this.readInt("cache", 1) == 1;
            this.trace = this.readInt("trace", 0) == 1;
            this.maxCacheSize = this.readInt("maxCacheSize", 1000);
            this.infoContent = this.readString("infocontent", "ic-semcor.dat");
            this.stem = this.readInt("stem", 0) == 1;
            this.stopList = this.readString("stoplist", "stoplist.txt");
            this.leskNormalize = this.readInt("lesk-normalize", 0) == 1;
            this.mfs = this.readInt("mfs", 0) == 1;
            stream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int readInt(String key, int defaultValue) {
        try {
            return Integer.parseInt(this.readString(key, defaultValue + ""));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private String readString(String key, String defaultValue) {
        String value = this.p.getProperty(key);
        if (value == null) {
            System.err.println("Configuration \"" + key + "\" not found in " + CONF);
            return defaultValue;
        }
        value = value.replaceAll("#.+", "");
        value = value.trim();
        return value;
    }

    public static WS4JConfiguration getInstance() {
        return instance;
    }

    public boolean useCache() {
        return this.cache;
    }

    public void setCache(boolean cache) {
        this.cache = cache;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public boolean useTrace() {
        return this.trace;
    }

    public String getInfoContent() {
        return this.infoContent;
    }

    public boolean useStem() {
        return this.stem;
    }

    public String getStopList() {
        return this.stopList;
    }

    public void setStopList(String stopList) {
        this.stopList = stopList;
    }

    public boolean useLeskNomalizer() {
        return this.leskNormalize;
    }

    public void setLeskNormalize(boolean leskNormalize) {
        this.leskNormalize = leskNormalize;
    }

    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public boolean useMFS() {
        return this.mfs;
    }

    public void setMFS(boolean mfs) {
        this.mfs = mfs;
    }

    public void setStem(boolean stem) {
        this.stem = stem;
    }
}

