/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.lti.ws4j.util;

import edu.cmu.lti.jawjaw.pobj.POS;
import edu.cmu.lti.lexical_db.data.Concept;
import edu.cmu.lti.ws4j.Relatedness;
import edu.cmu.lti.ws4j.RelatednessCalculator;
import edu.cmu.lti.ws4j.util.WS4JConfiguration;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class WordSimilarityCalculator {
    private static WS4JConfiguration c;
    public static boolean enableTrace;
    private static int MAX_CACHE_SIZE;
    protected static double min;
    protected static double max;
    private ConcurrentMap<String, Double> cache;

    public WordSimilarityCalculator() {
        if (WS4JConfiguration.getInstance().useCache()) {
            this.cache = new ConcurrentHashMap<String, Double>(MAX_CACHE_SIZE);
        }
    }

    public double calcRelatednessOfWords(String word1, String word2, RelatednessCalculator rc) {
        Double cachedObj;
        String key = word1 + " & " + word2;
        if (word1 != null && word2 != null && word1.equals(word2)) {
            return max;
        }
        if (word1 == null || word2 == null || word1.length() == 0 || word2.length() == 0) {
            return min;
        }
        POS pos1 = null;
        int offset1 = word1.indexOf("#");
        if (offset1 != -1) {
            try {
                pos1 = POS.valueOf((String)word1.substring(offset1 + 1));
            }
            catch (IllegalArgumentException e) {
                return min;
            }
            word1 = word1.substring(0, offset1);
        }
        POS pos2 = null;
        int offset2 = word2.indexOf("#");
        if (offset2 != -1) {
            try {
                pos2 = POS.valueOf((String)word2.substring(offset2 + 1));
            }
            catch (IllegalArgumentException e) {
                return min;
            }
            word2 = word2.substring(0, offset2);
        }
        if (WS4JConfiguration.getInstance().useCache() && (cachedObj = (Double)this.cache.get(key)) != null) {
            return cachedObj;
        }
        double maxScore = -1.0;
        List<POS[]> posPairs = rc.getPOSPairs();
        block4: for (POS[] posPair : posPairs) {
            if (pos1 != null && pos1 != posPair[0] || pos2 != null && pos2 != posPair[1]) continue;
            List synsets1 = (List)rc.getDB().getAllConcepts(word1, posPair[0].toString());
            List synsets2 = (List)rc.getDB().getAllConcepts(word2, posPair[1].toString());
            for (Concept synset1 : synsets1) {
                for (Concept synset2 : synsets2) {
                    Relatedness relatedness = rc.calcRelatednessOfSynset(synset1, synset2);
                    double score = relatedness.getScore();
                    if (score > maxScore) {
                        maxScore = score;
                    }
                    if (!WS4JConfiguration.getInstance().useMFS()) continue;
                    continue block4;
                }
            }
        }
        if (maxScore == -1.0) {
            maxScore = 0.0;
        }
        if (WS4JConfiguration.getInstance().useCache()) {
            if (this.cache.size() >= WS4JConfiguration.getInstance().getMaxCacheSize()) {
                this.cache.remove(this.cache.keySet().iterator().next());
            }
            this.cache.put(key, maxScore);
        }
        return maxScore;
    }

    static {
        min = 0.0;
        max = Double.MAX_VALUE;
        c = WS4JConfiguration.getInstance();
        enableTrace = c.useTrace();
        MAX_CACHE_SIZE = c.getMaxCacheSize();
    }
}

