/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import de.scravy.bedrock.Pair;
import de.scravy.bedrock.Seq;
import de.scravy.bedrock.SeqBuilder;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;

public final class Arithmetic {
    public static double minimum(double ... xs) {
        if (xs.length == 0) {
            throw new IllegalArgumentException();
        }
        double r = xs[0];
        for (int i = 1; i < xs.length; ++i) {
            if (!(xs[i] < r)) continue;
            r = xs[i];
        }
        return r;
    }

    public static int minimum(int ... xs) {
        if (xs.length == 0) {
            throw new IllegalArgumentException();
        }
        int r = xs[0];
        for (int i = 1; i < xs.length; ++i) {
            if (xs[i] >= r) continue;
            r = xs[i];
        }
        return r;
    }

    public static long minimum(long ... xs) {
        if (xs.length == 0) {
            throw new IllegalArgumentException();
        }
        long r = xs[0];
        for (int i = 1; i < xs.length; ++i) {
            if (xs[i] >= r) continue;
            r = xs[i];
        }
        return r;
    }

    public static double maximum(double ... xs) {
        if (xs.length == 0) {
            throw new IllegalArgumentException();
        }
        double r = xs[0];
        for (int i = 1; i < xs.length; ++i) {
            if (!(xs[i] > r)) continue;
            r = xs[i];
        }
        return r;
    }

    public static int maximum(int ... xs) {
        if (xs.length == 0) {
            throw new IllegalArgumentException();
        }
        int r = xs[0];
        for (int i = 1; i < xs.length; ++i) {
            if (xs[i] <= r) continue;
            r = xs[i];
        }
        return r;
    }

    public static long maximum(long ... xs) {
        if (xs.length == 0) {
            throw new IllegalArgumentException();
        }
        long r = xs[0];
        for (int i = 1; i < xs.length; ++i) {
            if (xs[i] <= r) continue;
            r = xs[i];
        }
        return r;
    }

    @Generated
    private Arithmetic() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static abstract class DelegatingTokenizer
    implements Tokenizer {
        private final Tokenizer tokenizer;

        @Override
        public Object identify(String lexeme) {
            return this.tokenizer.identify(lexeme);
        }

        @Override
        public boolean isOpeningParenthesis(String lexeme) {
            return this.tokenizer.isOpeningParenthesis(lexeme);
        }

        @Override
        public boolean isClosingParenthesis(String lexeme) {
            return this.tokenizer.isClosingParenthesis(lexeme);
        }

        @Override
        public boolean isValue(String lexeme) {
            return this.tokenizer.isValue(lexeme);
        }

        @Override
        public boolean isOperator(String lexeme) {
            return this.tokenizer.isOperator(lexeme);
        }

        @Override
        public boolean isLeftAssociative(String lexeme) {
            return this.tokenizer.isLeftAssociative(lexeme);
        }

        @Override
        public Tokenizer.Ordering comparePrecedence(String leftOperator, String rightOperator) {
            return this.tokenizer.comparePrecedence(leftOperator, rightOperator);
        }

        @Generated
        public DelegatingTokenizer(Tokenizer tokenizer) {
            this.tokenizer = tokenizer;
        }
    }

    static class StandardLexer
    implements Lexer {
        StandardLexer() {
        }

        private static boolean isOperatorChar(char c) {
            return "~!@#$%^&*-+=:/|\\?<>/".indexOf(c) >= 0;
        }

        private static boolean isVarNameStartChar(char c) {
            return Character.isLetter(c);
        }

        private static boolean isVarNameChar(char c) {
            return StandardLexer.isVarNameStartChar(c) || StandardLexer.isNumberStartChar(c) || c == '_';
        }

        private static boolean isNumberStartChar(char c) {
            return "0123456789".indexOf(c) >= 0;
        }

        private static boolean isNumberChar(char c) {
            return StandardLexer.isNumberStartChar(c) || ".".indexOf(c) >= 0;
        }

        private static boolean isSpace(char c) {
            return " \t\n\r".indexOf(c) >= 0;
        }

        private static boolean isStartOfSomething(char c) {
            return StandardLexer.isVarNameStartChar(c) || StandardLexer.isNumberStartChar(c) || StandardLexer.isOperatorChar(c);
        }

        @Override
        public boolean lex(String string, Consumer<Lexer.Lexeme> tokenHandler) {
            State state = State.SPACE;
            StringBuilder sb = new StringBuilder();
            block10: for (int i = 0; i <= string.length(); ++i) {
                char lookingAt = i < string.length() ? (char)string.charAt(i) : (char)' ';
                block11: while (true) {
                    switch (state) {
                        case SPACE: {
                            switch (lookingAt) {
                                case '(': {
                                    tokenHandler.accept(Lexer.Lexeme.of("("));
                                    continue block10;
                                }
                                case ')': {
                                    tokenHandler.accept(Lexer.Lexeme.of(")"));
                                    continue block10;
                                }
                            }
                            if (StandardLexer.isStartOfSomething(lookingAt)) {
                                sb.setLength(0);
                                sb.append(lookingAt);
                                if (StandardLexer.isOperatorChar(lookingAt)) {
                                    state = State.OPERATOR;
                                    continue block10;
                                }
                                if (StandardLexer.isNumberStartChar(lookingAt)) {
                                    state = State.NUMBER;
                                    continue block10;
                                }
                                state = State.VARIABLE;
                                continue block10;
                            }
                            if (StandardLexer.isSpace(lookingAt)) continue block10;
                            return false;
                        }
                        case VARIABLE: {
                            if (StandardLexer.isVarNameChar(lookingAt)) {
                                sb.append(lookingAt);
                                continue block10;
                            }
                            state = State.SPACE;
                            tokenHandler.accept(Lexer.Lexeme.of(sb.toString()));
                            continue block11;
                        }
                        case NUMBER: {
                            if (StandardLexer.isNumberChar(lookingAt)) {
                                sb.append(lookingAt);
                                continue block10;
                            }
                            state = State.SPACE;
                            tokenHandler.accept(Lexer.Lexeme.of(sb.toString()));
                            continue block11;
                        }
                        case OPERATOR: {
                            if (StandardLexer.isOperatorChar(lookingAt)) {
                                sb.append(lookingAt);
                                continue block10;
                            }
                            state = State.SPACE;
                            tokenHandler.accept(Lexer.Lexeme.of(sb.toString()));
                            continue block11;
                        }
                        default: {
                            continue block11;
                        }
                    }
                    break;
                }
            }
            return true;
        }

        private static enum State {
            SPACE,
            VARIABLE,
            NUMBER,
            OPERATOR;

        }
    }

    static interface Lexer {
        public static Lexer standard() {
            return new StandardLexer();
        }

        default public Seq<Lexeme> lex(String string) {
            SeqBuilder sequenceBuilder = Seq.builder();
            if (!this.lex(string, sequenceBuilder::add)) {
                throw new IllegalArgumentException("Invalid character in expression.");
            }
            return sequenceBuilder.result();
        }

        public boolean lex(String var1, Consumer<Lexeme> var2);

        public static final class Lexeme {
            private final String value;

            @Generated
            private Lexeme(String value) {
                this.value = value;
            }

            @Generated
            public static Lexeme of(String value) {
                return new Lexeme(value);
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Lexeme)) {
                    return false;
                }
                Lexeme other = (Lexeme)o;
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Arithmetic.Lexer.Lexeme(value=" + this.getValue() + ")";
            }
        }
    }

    public static interface OptimizedExpression {
        public BigDecimal eval(Function<String, BigDecimal> var1);

        public static OptimizedExpression compile(String expression) {
            return Expression.compile(expression).optimize();
        }

        public static final class VariableReference
        implements OptimizedExpression {
            private final String name;

            @Override
            public BigDecimal eval(Function<String, BigDecimal> variableBindings) {
                return variableBindings.apply(this.name);
            }

            public String toString() {
                return this.name;
            }

            @Generated
            private VariableReference(String name) {
                this.name = name;
            }

            @Generated
            public static VariableReference of(String name) {
                return new VariableReference(name);
            }

            @Generated
            public String getName() {
                return this.name;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof VariableReference)) {
                    return false;
                }
                VariableReference other = (VariableReference)o;
                String this$name = this.getName();
                String other$name = other.getName();
                return !(this$name == null ? other$name != null : !this$name.equals(other$name));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $name = this.getName();
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                return result;
            }
        }

        public static final class LiteralValue
        implements OptimizedExpression {
            private final BigDecimal value;

            @Override
            public BigDecimal eval(Function<String, BigDecimal> variableBindings) {
                return this.value;
            }

            public String toString() {
                return this.value.toString();
            }

            @Generated
            private LiteralValue(BigDecimal value) {
                this.value = value;
            }

            @Generated
            public static LiteralValue of(BigDecimal value) {
                return new LiteralValue(value);
            }

            @Generated
            public BigDecimal getValue() {
                return this.value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof LiteralValue)) {
                    return false;
                }
                LiteralValue other = (LiteralValue)o;
                BigDecimal this$value = this.getValue();
                BigDecimal other$value = other.getValue();
                return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                BigDecimal $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
                return result;
            }
        }

        public static final class BinaryOperation
        implements OptimizedExpression {
            private final BinaryOperator<BigDecimal> operator;
            private final OptimizedExpression left;
            private final OptimizedExpression right;

            @Override
            public BigDecimal eval(Function<String, BigDecimal> variableBindings) {
                return (BigDecimal)this.operator.apply(this.left.eval(variableBindings), this.right.eval(variableBindings));
            }

            public String toString() {
                return this.left.toString() + ' ' + this.operator.toString() + ' ' + this.right.toString();
            }

            @Generated
            private BinaryOperation(BinaryOperator<BigDecimal> operator, OptimizedExpression left, OptimizedExpression right) {
                this.operator = operator;
                this.left = left;
                this.right = right;
            }

            @Generated
            public static BinaryOperation of(BinaryOperator<BigDecimal> operator, OptimizedExpression left, OptimizedExpression right) {
                return new BinaryOperation(operator, left, right);
            }

            @Generated
            public BinaryOperator<BigDecimal> getOperator() {
                return this.operator;
            }

            @Generated
            public OptimizedExpression getLeft() {
                return this.left;
            }

            @Generated
            public OptimizedExpression getRight() {
                return this.right;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof BinaryOperation)) {
                    return false;
                }
                BinaryOperation other = (BinaryOperation)o;
                BinaryOperator<BigDecimal> this$operator = this.getOperator();
                BinaryOperator<BigDecimal> other$operator = other.getOperator();
                if (this$operator == null ? other$operator != null : !this$operator.equals(other$operator)) {
                    return false;
                }
                OptimizedExpression this$left = this.getLeft();
                OptimizedExpression other$left = other.getLeft();
                if (this$left == null ? other$left != null : !this$left.equals(other$left)) {
                    return false;
                }
                OptimizedExpression this$right = this.getRight();
                OptimizedExpression other$right = other.getRight();
                return !(this$right == null ? other$right != null : !this$right.equals(other$right));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                BinaryOperator<BigDecimal> $operator = this.getOperator();
                result = result * 59 + ($operator == null ? 43 : $operator.hashCode());
                OptimizedExpression $left = this.getLeft();
                result = result * 59 + ($left == null ? 43 : $left.hashCode());
                OptimizedExpression $right = this.getRight();
                result = result * 59 + ($right == null ? 43 : $right.hashCode());
                return result;
            }
        }
    }

    public static interface Expression {
        public BigDecimal eval(Function<String, BigDecimal> var1);

        public OptimizedExpression optimize(Map<String, BigDecimal> var1);

        default public OptimizedExpression optimize() {
            return this.optimize(Collections.emptyMap());
        }

        public static Expression compile(String expression) {
            Parser parser = Parser.arithmetic().withTokenizer(new DelegatingTokenizer(Tokenizer.arithmetic()){

                @Override
                public Object identify(String lexeme) {
                    if (this.isOperator(lexeme)) {
                        final class Operator {
                            private final String operation;
                            private final BinaryOperator<BigDecimal> operator;

                            @Generated
                            public Operator(String operation, BinaryOperator<BigDecimal> operator) {
                                this.operation = operation;
                                this.operator = operator;
                            }

                            @Generated
                            public String getOperation() {
                                return this.operation;
                            }

                            @Generated
                            public BinaryOperator<BigDecimal> getOperator() {
                                return this.operator;
                            }

                            @Generated
                            public boolean equals(Object o) {
                                if (o == this) {
                                    return true;
                                }
                                if (!(o instanceof Operator)) {
                                    return false;
                                }
                                Operator other = (Operator)o;
                                String this$operation = this.getOperation();
                                String other$operation = other.getOperation();
                                if (this$operation == null ? other$operation != null : !this$operation.equals(other$operation)) {
                                    return false;
                                }
                                BinaryOperator<BigDecimal> this$operator = this.getOperator();
                                BinaryOperator<BigDecimal> other$operator = other.getOperator();
                                return !(this$operator == null ? other$operator != null : !this$operator.equals(other$operator));
                            }

                            @Generated
                            public int hashCode() {
                                int PRIME = 59;
                                int result = 1;
                                String $operation = this.getOperation();
                                result = result * 59 + ($operation == null ? 43 : $operation.hashCode());
                                BinaryOperator<BigDecimal> $operator = this.getOperator();
                                result = result * 59 + ($operator == null ? 43 : $operator.hashCode());
                                return result;
                            }

                            @Generated
                            public String toString() {
                                return "Operator(operation=" + this.getOperation() + ", operator=" + this.getOperator() + ")";
                            }
                        }
                        return new Operator(lexeme, (BinaryOperator)super.identify(lexeme));
                    }
                    return super.identify(lexeme);
                }
            });
            ArrayDeque stack = new ArrayDeque();
            parser.parse(expression, token -> {
                Object value = token.getValue();
                if (value instanceof BigDecimal) {
                    stack.push(LiteralValue.of((BigDecimal)value));
                } else if (value instanceof String) {
                    stack.push(VariableReference.of((String)value));
                } else {
                    Expression snd = (Expression)stack.pop();
                    Expression fst = (Expression)stack.pop();
                    Operator op = (Operator)value;
                    stack.push(BinaryOperation.of(op.getOperation(), op.getOperator(), fst, snd));
                }
            });
            if (stack.size() != 1) {
                throw new IllegalArgumentException("could not compile expression");
            }
            return (Expression)stack.pop();
        }

        public static final class LiteralValue
        implements Expression {
            private final BigDecimal value;

            @Override
            public BigDecimal eval(Function<String, BigDecimal> variableBindings) {
                return this.value;
            }

            @Override
            public OptimizedExpression optimize(Map<String, BigDecimal> constants) {
                return OptimizedExpression.LiteralValue.of(this.value);
            }

            @Generated
            private LiteralValue(BigDecimal value) {
                this.value = value;
            }

            @Generated
            public static LiteralValue of(BigDecimal value) {
                return new LiteralValue(value);
            }

            @Generated
            public BigDecimal getValue() {
                return this.value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof LiteralValue)) {
                    return false;
                }
                LiteralValue other = (LiteralValue)o;
                BigDecimal this$value = this.getValue();
                BigDecimal other$value = other.getValue();
                return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                BigDecimal $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Arithmetic.Expression.LiteralValue(value=" + this.getValue() + ")";
            }
        }

        public static final class VariableReference
        implements Expression {
            private final String name;

            @Override
            public BigDecimal eval(Function<String, BigDecimal> variableBindings) {
                return variableBindings.apply(this.name);
            }

            @Override
            public OptimizedExpression optimize(Map<String, BigDecimal> constants) {
                if (constants.containsKey(this.name)) {
                    return OptimizedExpression.LiteralValue.of(constants.get(this.name));
                }
                return OptimizedExpression.VariableReference.of(this.name);
            }

            @Generated
            private VariableReference(String name) {
                this.name = name;
            }

            @Generated
            public static VariableReference of(String name) {
                return new VariableReference(name);
            }

            @Generated
            public String getName() {
                return this.name;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof VariableReference)) {
                    return false;
                }
                VariableReference other = (VariableReference)o;
                String this$name = this.getName();
                String other$name = other.getName();
                return !(this$name == null ? other$name != null : !this$name.equals(other$name));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $name = this.getName();
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Arithmetic.Expression.VariableReference(name=" + this.getName() + ")";
            }
        }

        public static final class BinaryOperation
        implements Expression {
            private final String operation;
            private final BinaryOperator<BigDecimal> operator;
            private final Expression left;
            private final Expression right;

            @Override
            public BigDecimal eval(Function<String, BigDecimal> variableBindings) {
                return (BigDecimal)this.operator.apply(this.left.eval(variableBindings), this.right.eval(variableBindings));
            }

            @Override
            public OptimizedExpression optimize(Map<String, BigDecimal> constants) {
                OptimizedExpression oleft = this.left.optimize(constants);
                OptimizedExpression oright = this.right.optimize(constants);
                if (oleft instanceof OptimizedExpression.LiteralValue && oright instanceof OptimizedExpression.LiteralValue) {
                    BigDecimal result = (BigDecimal)this.operator.apply(((OptimizedExpression.LiteralValue)oleft).getValue(), ((OptimizedExpression.LiteralValue)oright).getValue());
                    return OptimizedExpression.LiteralValue.of(result);
                }
                switch (this.operation) {
                    case "+": {
                        if (oleft instanceof OptimizedExpression.LiteralValue && ((OptimizedExpression.LiteralValue)oleft).getValue().equals(BigDecimal.ZERO)) {
                            return oright;
                        }
                        if (!(oright instanceof OptimizedExpression.LiteralValue) || !((OptimizedExpression.LiteralValue)oright).getValue().equals(BigDecimal.ZERO)) break;
                        return oleft;
                    }
                    case "*": {
                        if (oleft instanceof OptimizedExpression.LiteralValue && ((OptimizedExpression.LiteralValue)oleft).getValue().equals(BigDecimal.ONE)) {
                            return oright;
                        }
                        if (oright instanceof OptimizedExpression.LiteralValue && ((OptimizedExpression.LiteralValue)oright).getValue().equals(BigDecimal.ONE)) {
                            return oleft;
                        }
                        if (oleft instanceof OptimizedExpression.LiteralValue && ((OptimizedExpression.LiteralValue)oleft).getValue().equals(BigDecimal.ZERO)) {
                            return OptimizedExpression.LiteralValue.of(BigDecimal.ZERO);
                        }
                        if (!(oright instanceof OptimizedExpression.LiteralValue) || !((OptimizedExpression.LiteralValue)oright).getValue().equals(BigDecimal.ZERO)) break;
                        return OptimizedExpression.LiteralValue.of(BigDecimal.ZERO);
                    }
                    case "^": {
                        if (oright instanceof OptimizedExpression.LiteralValue && ((OptimizedExpression.LiteralValue)oright).getValue().equals(BigDecimal.ZERO)) {
                            return OptimizedExpression.LiteralValue.of(BigDecimal.ONE);
                        }
                        if (!(oright instanceof OptimizedExpression.LiteralValue) || !((OptimizedExpression.LiteralValue)oright).getValue().equals(BigDecimal.ONE)) break;
                        return oleft;
                    }
                }
                return OptimizedExpression.BinaryOperation.of(this.operator, oleft, oright);
            }

            @Generated
            private BinaryOperation(String operation, BinaryOperator<BigDecimal> operator, Expression left, Expression right) {
                this.operation = operation;
                this.operator = operator;
                this.left = left;
                this.right = right;
            }

            @Generated
            public static BinaryOperation of(String operation, BinaryOperator<BigDecimal> operator, Expression left, Expression right) {
                return new BinaryOperation(operation, operator, left, right);
            }

            @Generated
            public String getOperation() {
                return this.operation;
            }

            @Generated
            public BinaryOperator<BigDecimal> getOperator() {
                return this.operator;
            }

            @Generated
            public Expression getLeft() {
                return this.left;
            }

            @Generated
            public Expression getRight() {
                return this.right;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof BinaryOperation)) {
                    return false;
                }
                BinaryOperation other = (BinaryOperation)o;
                String this$operation = this.getOperation();
                String other$operation = other.getOperation();
                if (this$operation == null ? other$operation != null : !this$operation.equals(other$operation)) {
                    return false;
                }
                BinaryOperator<BigDecimal> this$operator = this.getOperator();
                BinaryOperator<BigDecimal> other$operator = other.getOperator();
                if (this$operator == null ? other$operator != null : !this$operator.equals(other$operator)) {
                    return false;
                }
                Expression this$left = this.getLeft();
                Expression other$left = other.getLeft();
                if (this$left == null ? other$left != null : !this$left.equals(other$left)) {
                    return false;
                }
                Expression this$right = this.getRight();
                Expression other$right = other.getRight();
                return !(this$right == null ? other$right != null : !this$right.equals(other$right));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $operation = this.getOperation();
                result = result * 59 + ($operation == null ? 43 : $operation.hashCode());
                BinaryOperator<BigDecimal> $operator = this.getOperator();
                result = result * 59 + ($operator == null ? 43 : $operator.hashCode());
                Expression $left = this.getLeft();
                result = result * 59 + ($left == null ? 43 : $left.hashCode());
                Expression $right = this.getRight();
                result = result * 59 + ($right == null ? 43 : $right.hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Arithmetic.Expression.BinaryOperation(operation=" + this.getOperation() + ", operator=" + this.getOperator() + ", left=" + this.getLeft() + ", right=" + this.getRight() + ")";
            }
        }
    }

    static class Parser {
        private final Lexer lexer;
        private final Tokenizer tokenizer;

        public static Parser arithmetic() {
            return Parser.builder().lexer(Lexer.standard()).tokenizer(Tokenizer.arithmetic()).build();
        }

        private boolean shouldShunt(String lookingAt, String peek) {
            if (this.tokenizer.isOpeningParenthesis(peek)) {
                return false;
            }
            Tokenizer.Ordering precedence = this.tokenizer.comparePrecedence(peek, lookingAt);
            return precedence == Tokenizer.Ordering.GT || precedence == Tokenizer.Ordering.EQ && this.tokenizer.isLeftAssociative(lookingAt);
        }

        public Seq<Token> parse(String string) {
            SeqBuilder sequenceBuilder = Seq.builder();
            if (!this.parse(string, sequenceBuilder::add)) {
                throw new IllegalArgumentException("unclosed parenthesis in expression");
            }
            return sequenceBuilder.result();
        }

        public boolean parse(String string, Consumer<Token> tokenHandler) {
            Seq<Lexer.Lexeme> lexemes = this.lexer.lex(string);
            ArrayDeque<Lexer.Lexeme> operators = new ArrayDeque<Lexer.Lexeme>();
            for (Lexer.Lexeme lexeme : lexemes) {
                Lexer.Lexeme l;
                String value = lexeme.getValue();
                if (this.tokenizer.isValue(value)) {
                    tokenHandler.accept(Token.of(lexeme, this.tokenizer.identify(lexeme.getValue())));
                    continue;
                }
                if (this.tokenizer.isOperator(value)) {
                    while (!operators.isEmpty() && this.shouldShunt(value, ((Lexer.Lexeme)operators.peek()).getValue())) {
                        l = (Lexer.Lexeme)operators.pop();
                        tokenHandler.accept(Token.of(l, this.tokenizer.identify(l.getValue())));
                    }
                    operators.push(lexeme);
                    continue;
                }
                if (this.tokenizer.isOpeningParenthesis(value)) {
                    operators.push(lexeme);
                    continue;
                }
                if (!this.tokenizer.isClosingParenthesis(value)) continue;
                while (!operators.isEmpty() && !this.tokenizer.isOpeningParenthesis(((Lexer.Lexeme)operators.peek()).getValue())) {
                    l = (Lexer.Lexeme)operators.pop();
                    tokenHandler.accept(Token.of(l, this.tokenizer.identify(l.getValue())));
                }
                if (operators.isEmpty()) {
                    return false;
                }
                operators.pop();
            }
            while (!operators.isEmpty()) {
                Lexer.Lexeme l = (Lexer.Lexeme)operators.pop();
                tokenHandler.accept(Token.of(l, this.tokenizer.identify(l.getValue())));
            }
            return true;
        }

        @Generated
        public static ParserBuilder builder() {
            return new ParserBuilder();
        }

        @Generated
        public Parser(Lexer lexer, Tokenizer tokenizer) {
            this.lexer = lexer;
            this.tokenizer = tokenizer;
        }

        @Generated
        public Parser withLexer(Lexer lexer) {
            return this.lexer == lexer ? this : new Parser(lexer, this.tokenizer);
        }

        @Generated
        public Parser withTokenizer(Tokenizer tokenizer) {
            return this.tokenizer == tokenizer ? this : new Parser(this.lexer, tokenizer);
        }

        @Generated
        public static class ParserBuilder {
            @Generated
            private Lexer lexer;
            @Generated
            private Tokenizer tokenizer;

            @Generated
            ParserBuilder() {
            }

            @Generated
            public ParserBuilder lexer(Lexer lexer) {
                this.lexer = lexer;
                return this;
            }

            @Generated
            public ParserBuilder tokenizer(Tokenizer tokenizer) {
                this.tokenizer = tokenizer;
                return this;
            }

            @Generated
            public Parser build() {
                return new Parser(this.lexer, this.tokenizer);
            }

            @Generated
            public String toString() {
                return "Arithmetic.Parser.ParserBuilder(lexer=" + this.lexer + ", tokenizer=" + this.tokenizer + ")";
            }
        }

        public static final class Token {
            private final Lexer.Lexeme lexeme;
            private final Object value;

            @Generated
            private Token(Lexer.Lexeme lexeme, Object value) {
                this.lexeme = lexeme;
                this.value = value;
            }

            @Generated
            public static Token of(Lexer.Lexeme lexeme, Object value) {
                return new Token(lexeme, value);
            }

            @Generated
            public Lexer.Lexeme getLexeme() {
                return this.lexeme;
            }

            @Generated
            public Object getValue() {
                return this.value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Token)) {
                    return false;
                }
                Token other = (Token)o;
                Lexer.Lexeme this$lexeme = this.getLexeme();
                Lexer.Lexeme other$lexeme = other.getLexeme();
                if (this$lexeme == null ? other$lexeme != null : !((Object)this$lexeme).equals(other$lexeme)) {
                    return false;
                }
                Object this$value = this.getValue();
                Object other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Lexer.Lexeme $lexeme = this.getLexeme();
                result = result * 59 + ($lexeme == null ? 43 : ((Object)$lexeme).hashCode());
                Object $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Arithmetic.Parser.Token(lexeme=" + this.getLexeme() + ", value=" + this.getValue() + ")";
            }
        }
    }

    static interface Tokenizer {
        public Object identify(String var1);

        public boolean isOpeningParenthesis(String var1);

        public boolean isClosingParenthesis(String var1);

        public boolean isValue(String var1);

        public boolean isOperator(String var1);

        public boolean isLeftAssociative(String var1);

        public Ordering comparePrecedence(String var1, String var2);

        public static Tokenizer arithmetic() {
            return new Tokenizer(){
                private final Map<String, Pair<Integer, BinaryOperator<BigDecimal>>> operators = new HashMap<String, Pair<Integer, BinaryOperator<BigDecimal>>>();
                {
                    this.operators.put("+", Pair.of(1, new BinaryOperator<BigDecimal>(){

                        @Override
                        public BigDecimal apply(BigDecimal left, BigDecimal right) {
                            return left.add(right);
                        }

                        public String toString() {
                            return "+";
                        }
                    }));
                    this.operators.put("-", Pair.of(1, new BinaryOperator<BigDecimal>(){

                        @Override
                        public BigDecimal apply(BigDecimal left, BigDecimal right) {
                            return left.subtract(right);
                        }

                        public String toString() {
                            return "-";
                        }
                    }));
                    this.operators.put("*", Pair.of(2, new BinaryOperator<BigDecimal>(){

                        @Override
                        public BigDecimal apply(BigDecimal left, BigDecimal right) {
                            return left.multiply(right);
                        }

                        public String toString() {
                            return "*";
                        }
                    }));
                    this.operators.put("/", Pair.of(2, new BinaryOperator<BigDecimal>(){

                        @Override
                        public BigDecimal apply(BigDecimal a, BigDecimal b) {
                            try {
                                return a.divide(b);
                            }
                            catch (ArithmeticException exc) {
                                return a.divide(b, 12, RoundingMode.HALF_UP);
                            }
                        }

                        public String toString() {
                            return "/";
                        }
                    }));
                    this.operators.put("^", Pair.of(3, new BinaryOperator<BigDecimal>(){

                        @Override
                        public BigDecimal apply(BigDecimal a, BigDecimal b) {
                            return a.pow(b.intValue());
                        }

                        public String toString() {
                            return "^";
                        }
                    }));
                }

                @Override
                public Object identify(String lexeme) {
                    if (this.operators.containsKey(lexeme)) {
                        return this.operators.get(lexeme).snd();
                    }
                    try {
                        return new BigDecimal(lexeme);
                    }
                    catch (Exception exc) {
                        return lexeme;
                    }
                }

                @Override
                public boolean isOpeningParenthesis(String lexeme) {
                    return lexeme.equals("(");
                }

                @Override
                public boolean isClosingParenthesis(String lexeme) {
                    return lexeme.equals(")");
                }

                @Override
                public boolean isValue(String lexeme) {
                    return !this.isOperator(lexeme) && !this.isOpeningParenthesis(lexeme) && !this.isClosingParenthesis(lexeme);
                }

                @Override
                public boolean isOperator(String lexeme) {
                    return this.operators.containsKey(lexeme);
                }

                @Override
                public boolean isLeftAssociative(String lexeme) {
                    return !lexeme.equals("^");
                }

                @Override
                public Ordering comparePrecedence(String leftOperator, String rightOperator) {
                    return Ordering.from(Integer.compare(Optional.ofNullable(this.operators.get(leftOperator)).map(Pair::fst).orElse(0), Optional.ofNullable(this.operators.get(rightOperator)).map(Pair::fst).orElse(0)));
                }
            };
        }

        public static enum Ordering {
            LT,
            EQ,
            GT;


            public static Ordering from(int comparisonResult) {
                if (comparisonResult < 0) {
                    return LT;
                }
                if (comparisonResult > 0) {
                    return GT;
                }
                return EQ;
            }
        }
    }
}

