/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import de.scravy.bedrock.ArrayMapBuilder;
import de.scravy.bedrock.Mapping;
import de.scravy.bedrock.Pair;
import de.scravy.bedrock.Seq;
import de.scravy.bedrock.SeqSimple;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import lombok.Generated;

@Immutable
public final class ArrayMap<K extends Comparable<? super K>, V>
implements Mapping<K, V> {
    private static final ArrayMap EMPTY;
    private Function<K, V> defaultReturnValue = key -> {
        throw new NoSuchElementException(Objects.toString(key));
    };
    private final Object[] keys;
    private final Object[] values;

    public ArrayMap<K, V> setDefaultReturnValue(@Nullable V value) {
        this.defaultReturnValue = ignore -> value;
        return this;
    }

    @Override
    @Nonnull
    public Optional<V> get(@Nonnull K key) {
        int ix = Arrays.binarySearch(this.keys, key);
        if (ix >= 0) {
            return Optional.ofNullable(this.values[ix]);
        }
        return Optional.empty();
    }

    @Override
    public V apply(K key) {
        Optional<V> result = this.get(key);
        if (result.isPresent()) {
            return result.get();
        }
        return this.defaultReturnValue.apply(key);
    }

    @Nonnull
    public <W> ArrayMap<K, W> mapValues(@Nonnull Function<V, W> f) {
        Object[] vs = new Object[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            vs[i] = f.apply(this.values[i]);
        }
        return new ArrayMap<K, V>(this.keys, vs);
    }

    @Nonnull
    public <W> ArrayMap<K, W> mapValuesWithKey(@Nonnull BiFunction<K, V, W> f) {
        Object[] vs = new Object[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            vs[i] = f.apply((Comparable)this.keys[i], this.values[i]);
        }
        return new ArrayMap<K, V>(this.keys, vs);
    }

    @Nonnull
    public ArrayMap<K, V> filter(Predicate<K> predicate) {
        Objects.requireNonNull(predicate, "'predicate' must not be null");
        return this.stream().filter((? super T entry) -> predicate.test((Comparable)entry.getKey())).collect(ArrayMap.collector());
    }

    @Nonnull
    public ArrayMap<K, V> filterWithValue(BiPredicate<K, V> predicate) {
        Objects.requireNonNull(predicate, "'predicate' must not be null");
        return this.stream().filter((? super T entry) -> predicate.test((Comparable)entry.getKey(), entry.getValue())).collect(ArrayMap.collector());
    }

    @Override
    @Nonnull
    public Iterator<Pair<K, V>> iterator() {
        return new Iterator<Pair<K, V>>(){
            private int i = 0;

            @Override
            @Nonnull
            public Pair<K, V> next() {
                return Pair.of((Comparable)ArrayMap.this.keys[this.i], ArrayMap.this.values[this.i++]);
            }

            @Override
            public boolean hasNext() {
                return this.i < ArrayMap.this.keys.length;
            }
        };
    }

    @Override
    @Nonnull
    public Seq<K> keys() {
        return new SeqSimple(this.keys);
    }

    @Override
    @Nonnull
    public Seq<V> values() {
        return new SeqSimple(this.values);
    }

    @Nonnull
    public ArrayMap<K, V> union(@Nonnull ArrayMap<K, V> arrayMap) {
        Comparable i;
        int targetSize = this.size() + arrayMap.size();
        Object[] keys = new Object[targetSize];
        Object[] values = new Object[targetSize];
        Seq<K> is = this.keys();
        Seq<K> js = arrayMap.keys();
        int ix = 0;
        int jx = 0;
        int kx = 0;
        while (ix < is.size() && jx < js.size()) {
            Comparable j;
            i = (Comparable)is.apply(ix);
            int c = i.compareTo(j = (Comparable)js.apply(jx));
            if (c < 0) {
                keys[kx] = i;
                values[kx] = this.apply((K)i);
                ++ix;
            } else if (c == 0) {
                keys[kx] = i;
                values[kx] = this.apply((K)i);
                ++ix;
                ++jx;
            } else {
                keys[kx] = j;
                values[kx] = arrayMap.apply(j);
                ++jx;
            }
            ++kx;
        }
        while (ix < is.size()) {
            i = (Comparable)is.get(ix);
            keys[kx] = i;
            values[kx] = this.apply((K)i);
            ++ix;
            ++kx;
        }
        while (jx < js.size()) {
            Comparable j = (Comparable)js.get(jx);
            keys[kx] = j;
            values[kx] = arrayMap.apply(j);
            ++jx;
            ++kx;
        }
        Object[] finalKeys = new Object[kx];
        Object[] finalValues = new Object[kx];
        System.arraycopy(keys, 0, finalKeys, 0, kx);
        System.arraycopy(values, 0, finalValues, 0, kx);
        return new ArrayMap<K, V>(finalKeys, finalValues);
    }

    @Nonnull
    public ArrayMap<K, V> intersect(@Nonnull ArrayMap<K, V> arrayMap) {
        int targetSize = Math.max(this.size(), arrayMap.size());
        Object[] keys = new Object[targetSize];
        Object[] values = new Object[targetSize];
        Seq<K> is = this.keys();
        Seq<K> js = arrayMap.keys();
        int ix = 0;
        int jx = 0;
        int kx = 0;
        while (ix < is.size() && jx < js.size()) {
            Comparable j;
            Comparable i = (Comparable)is.apply(ix);
            int c = i.compareTo(j = (Comparable)js.apply(jx));
            if (c < 0) {
                ++ix;
                continue;
            }
            if (c == 0) {
                keys[kx] = i;
                values[kx] = this.apply((K)i);
                ++ix;
                ++jx;
                ++kx;
                continue;
            }
            ++jx;
        }
        Object[] finalKeys = new Object[kx];
        Object[] finalValues = new Object[kx];
        System.arraycopy(keys, 0, finalKeys, 0, kx);
        System.arraycopy(values, 0, finalValues, 0, kx);
        return new ArrayMap<K, V>(finalKeys, finalValues);
    }

    public String toString() {
        return this.stream().map(entry -> String.format("%s = %s", entry.fst(), entry.snd())).collect(Collectors.joining(", ", "{ ", " }"));
    }

    @Nonnull
    @SafeVarargs
    public static <K extends Comparable<K>, V> ArrayMap<K, V> of(Pair<K, V> ... pairs) {
        Object[] keys = new Object[pairs.length];
        Object[] values = new Object[pairs.length];
        Pair[] sorted = (Pair[])pairs.clone();
        Arrays.sort(sorted, Comparator.comparing(Pair::fst));
        for (int i = 0; i < sorted.length; ++i) {
            keys[i] = sorted[i].fst();
            values[i] = sorted[i].snd();
        }
        return new ArrayMap<K, V>(keys, values);
    }

    @Nonnull
    public static <K extends Comparable<K>, V> ArrayMap<K, V> ofSeq(@Nonnull Seq<Pair<K, V>> pairs) {
        Object[] keys = new Object[pairs.length()];
        Object[] values = new Object[pairs.length()];
        Seq<Pair> sorted = pairs.sortedBy(Comparator.comparing(Pair::fst));
        for (int i = 0; i < sorted.length(); ++i) {
            keys[i] = sorted.get(i).getFirst();
            values[i] = sorted.get(i).getSecond();
        }
        return new ArrayMap<K, V>(keys, values);
    }

    @Nonnull
    public static <K extends Comparable<? super K>, V> ArrayMap<K, V> ofMap(@Nonnull Map<K, V> pairs) {
        if (pairs instanceof TreeMap) {
            return ArrayMap.ofTreeMap((TreeMap)pairs);
        }
        Object[] keys = Seq.ofCollectionInternal(pairs.keySet()).sortedInternal().backingArray;
        Object[] values = new Object[pairs.size()];
        for (int i = 0; i < keys.length; ++i) {
            values[i] = pairs.get(keys[i]);
        }
        return new ArrayMap<K, V>(keys, values);
    }

    @Nonnull
    public static <K extends Comparable<? super K>, V> ArrayMap<K, V> ofTreeMap(@Nonnull TreeMap<K, V> pairs) {
        Object[] keys = Seq.ofCollectionInternal(pairs.keySet()).backingArray;
        Object[] values = new Object[pairs.size()];
        for (int i = 0; i < keys.length; ++i) {
            values[i] = pairs.get(keys[i]);
        }
        return new ArrayMap<K, V>(keys, values);
    }

    @Nonnull
    public static <K extends Comparable<? super K>, V> ArrayMap<K, V> empty() {
        return EMPTY;
    }

    @Nonnull
    public static <K extends Comparable<? super K>, V> Collector<Pair<K, V>, TreeMap<K, V>, ArrayMap<K, V>> collector() {
        return new Collector<Pair<K, V>, TreeMap<K, V>, ArrayMap<K, V>>(){

            @Override
            public Supplier<TreeMap<K, V>> supplier() {
                return TreeMap::new;
            }

            @Override
            public BiConsumer<TreeMap<K, V>, Pair<K, V>> accumulator() {
                return (treeMap, entry) -> treeMap.put((Comparable)entry.getKey(), entry.getValue());
            }

            @Override
            public BinaryOperator<TreeMap<K, V>> combiner() {
                return (map1, map2) -> {
                    map1.putAll(map2);
                    return map1;
                };
            }

            @Override
            public Function<TreeMap<K, V>, ArrayMap<K, V>> finisher() {
                return ArrayMap::ofMap;
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return Collections.emptySet();
            }
        };
    }

    @Nonnull
    public static <K extends Comparable<? super K>, V> ArrayMapBuilder<K, V> builder() {
        return new ArrayMapBuilder();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ArrayMap) {
            ArrayMap arrayMap = (ArrayMap)other;
            return Arrays.equals(this.keys, arrayMap.keys) && Arrays.equals(this.values, arrayMap.values);
        }
        if (!(other instanceof Mapping)) {
            return false;
        }
        Mapping otherMapping = (Mapping)other;
        if (this.isEmpty() && otherMapping.isEmpty()) {
            return true;
        }
        if (this.size() != ((Mapping)other).size()) {
            return false;
        }
        for (Comparable key : this.keys()) {
            Optional otherValue = otherMapping.get(key);
            if (Objects.equals(this.get((K)key), otherValue)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.isEmpty()) {
            return Mapping.empty().hashCode();
        }
        return 31 * Arrays.hashCode(this.keys) + Arrays.hashCode(this.values);
    }

    @Generated
    ArrayMap(Object[] keys, Object[] values) {
        this.keys = keys;
        this.values = values;
    }

    static {
        Object[] empty = new Object[]{};
        EMPTY = new ArrayMap(empty, empty);
    }
}

