/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import de.scravy.bedrock.Try;
import java.util.Collections;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import javax.annotation.Nonnull;

public interface Builder<Element, TargetCollection>
extends Iterable<Element>,
Collector<Element, Builder<Element, TargetCollection>, TargetCollection> {
    @Nonnull
    public TargetCollection result();

    @Nonnull
    default public TargetCollection build() {
        return this.result();
    }

    public Builder<Element, TargetCollection> add(Element var1);

    @Override
    default public Supplier<Builder<Element, TargetCollection>> supplier() {
        return () -> Try.execute(() -> (Builder)this.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).orElseThrowRuntime();
    }

    @Override
    default public BiConsumer<Builder<Element, TargetCollection>, Element> accumulator() {
        return Builder::add;
    }

    @Override
    default public BinaryOperator<Builder<Element, TargetCollection>> combiner() {
        return (b1, b2) -> {
            for (Object element : b2) {
                b1.add(element);
            }
            return b1;
        };
    }

    @Override
    default public Function<Builder<Element, TargetCollection>, TargetCollection> finisher() {
        return Builder::build;
    }

    @Override
    default public Set<Collector.Characteristics> characteristics() {
        return Collections.emptySet();
    }
}

