/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import de.scravy.bedrock.Control;
import de.scravy.bedrock.ThrowingFunction;
import de.scravy.bedrock.Try;
import java.util.Objects;
import javax.annotation.Nonnull;

@FunctionalInterface
public interface Callback<R> {
    public void call(Object var1, R var2) throws Exception;

    default public void call(Try<R> tryResult) {
        tryResult.consume(this::fail, this::success);
    }

    default public void success(R result) {
        try {
            this.call(null, result);
        }
        catch (Exception exc) {
            Control.report(exc);
        }
    }

    default public void fail(Object error) {
        try {
            this.call(error, null);
        }
        catch (Exception exc) {
            Control.report(exc);
        }
    }

    default public <T> Callback<T> after(@Nonnull ThrowingFunction<T, R> function) {
        Objects.requireNonNull(function, "'function' must not be null.");
        return (err, res) -> {
            if (err != null) {
                this.call(err, null);
            } else {
                Try<Object> tryResult = Try.execute(() -> function.execute(res));
                if (tryResult.isFailure()) {
                    this.call(tryResult.getException(), null);
                } else {
                    this.call(null, tryResult.get());
                }
            }
        };
    }
}

