/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import de.scravy.bedrock.Control;
import de.scravy.bedrock.Either;
import de.scravy.bedrock.Function0;
import de.scravy.bedrock.HasLength;
import de.scravy.bedrock.Pair;
import de.scravy.bedrock.Quadruple;
import de.scravy.bedrock.Seq;
import de.scravy.bedrock.SeqBuilder;
import de.scravy.bedrock.Triple;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import lombok.Generated;

@FunctionalInterface
public interface CharParser<T> {
    public Result<T> parse(Seq<Character> var1);

    default public Result<T> parse(@Nonnull String string) {
        Objects.requireNonNull(string, "'string' must not be null");
        return this.parse(Seq.wrap(string));
    }

    default public <U> CharParser<U> map(@Nonnull Function<T, U> function) {
        Objects.requireNonNull(function, "'function' must not be null");
        return seq -> this.parse(seq).map(function);
    }

    @Nonnull
    public static <T, U> CharParser<T> left(@Nonnull CharParser<T> leftParser, @Nonnull CharParser<U> rightParser) {
        Objects.requireNonNull(leftParser, "'leftParser' must not be null.");
        Objects.requireNonNull(rightParser, "'rightParser' must not be null.");
        return seq -> {
            Result r1 = leftParser.parse(seq);
            if (r1.isSuccess()) {
                Result r2 = rightParser.parse(r1.getRemaining());
                if (r2.isSuccess()) {
                    return new Result.Success(r1.getValue(), r2.getRemaining());
                }
                return r2.withRemaining(seq).as();
            }
            return r1.withRemaining(seq);
        };
    }

    @Nonnull
    public static <T, U> CharParser<U> right(@Nonnull CharParser<T> leftParser, @Nonnull CharParser<U> rightParser) {
        Objects.requireNonNull(leftParser, "'leftParser' must not be null.");
        Objects.requireNonNull(rightParser, "'rightParser' must not be null.");
        return seq -> {
            Result r1 = leftParser.parse(seq);
            if (r1.isSuccess()) {
                Result r2 = rightParser.parse(r1.getRemaining());
                if (r2.isSuccess()) {
                    return r2;
                }
                return r2.withRemaining(seq);
            }
            return r1.withRemaining(seq).as();
        };
    }

    @Nonnull
    public static <S, T extends S, U extends S> CharParser<S> choice(@Nonnull CharParser<T> leftParser, @Nonnull CharParser<U> rightParser) {
        Objects.requireNonNull(leftParser, "'leftParser' must not be null.");
        Objects.requireNonNull(rightParser, "'rightParser' must not be null.");
        return seq -> {
            Result r1 = leftParser.parse(seq);
            if (r1.isSuccess()) {
                return r1.as();
            }
            return rightParser.parse(seq).as();
        };
    }

    @Nonnull
    public static <T, U> CharParser<Either<T, U>> either(@Nonnull CharParser<T> leftParser, @Nonnull CharParser<U> rightParser) {
        Objects.requireNonNull(leftParser, "'leftParser' must not be null.");
        Objects.requireNonNull(rightParser, "'rightParser' must not be null.");
        return seq -> {
            Result<Either> r1 = leftParser.parse(seq).map(Either::left);
            if (r1.isSuccess()) {
                return r1;
            }
            return rightParser.parse(seq).map(Either::right);
        };
    }

    @Nonnull
    @SafeVarargs
    public static <T> CharParser<T> oneOf(CharParser<? extends T> ... parsers) {
        Objects.requireNonNull(parsers, "'parsers' must not be null.");
        if (parsers.length == 1) {
            CharParser<? extends T> parser = parsers[0];
            return parser;
        }
        return seq -> {
            for (CharParser p : parsers) {
                Result result = p.parse(seq);
                if (!result.isSuccess()) continue;
                return result.as();
            }
            return new Result.NoParse(seq);
        };
    }

    @Nonnull
    public static CharParser<Character> anyOf(@Nonnull String string) {
        Objects.requireNonNull(string, "'string' must not be null.");
        if (string.isEmpty()) {
            return Result.NoParse::new;
        }
        if (string.length() == 1) {
            return CharParser.character(string.charAt(0));
        }
        char[] chars = string.toCharArray();
        Arrays.sort(chars);
        char c = chars[0];
        int i = 1;
        while (i < chars.length && c + '\u0001' == chars[i]) {
            c = chars[i++];
        }
        if (i == chars.length) {
            return CharParser.range(chars[0], chars[chars.length - 1]);
        }
        return seq -> {
            char chr;
            if (seq.nonEmpty() && Arrays.binarySearch(chars, chr = ((Character)seq.head()).charValue()) >= 0) {
                return new Result.Success<Character>(Character.valueOf(chr), (Seq)seq.tailView());
            }
            return new Result.NoParse(seq);
        };
    }

    @Nonnull
    public static CharParser<Character> noneOf(@Nonnull String string) {
        Objects.requireNonNull(string, "'string' must not be null.");
        return seq -> {
            char c;
            if (seq.nonEmpty() && string.indexOf(c = ((Character)seq.head()).charValue()) < 0) {
                return new Result.Success<Character>(Character.valueOf(c), (Seq)seq.tailView());
            }
            return new Result.NoParse(seq);
        };
    }

    @Nonnull
    public static CharParser<Character> character(char character) {
        return seq -> {
            Character c;
            if (seq.nonEmpty() && (c = (Character)seq.head()).charValue() == character) {
                return new Result.Success<Character>(c, (Seq)seq.tailView());
            }
            return new Result.NoParse(seq);
        };
    }

    @Nonnull
    public static CharParser<Character> range(char lower, char upper) {
        return seq -> {
            Character c;
            if (seq.nonEmpty() && (c = (Character)seq.head()).charValue() >= lower && c.charValue() <= upper) {
                return new Result.Success<Character>(c, (Seq)seq.tailView());
            }
            return new Result.NoParse(seq);
        };
    }

    @Nonnull
    public static CharParser<String> string(@Nonnull String string) {
        Objects.requireNonNull(string, "'string' must not be null.");
        return seq -> {
            if (seq.length() < string.length()) {
                return new Result.NoParse(seq);
            }
            for (int i = 0; i < string.length(); ++i) {
                if (((Character)seq.get(i)).charValue() == string.charAt(i)) continue;
                return new Result.NoParse(seq);
            }
            return new Result.Success<String>(string, (Seq)seq.dropView(string.length()));
        };
    }

    @Nonnull
    public static CharParser<Character> satisfies(@Nonnull Predicate<Character> predicate) {
        Objects.requireNonNull(predicate, "'predicate' must not be null.");
        return seq -> {
            Character c;
            if (seq.nonEmpty() && predicate.test(c = (Character)seq.head())) {
                return new Result.Success<Character>(c, (Seq)seq.tailView());
            }
            return new Result.NoParse(seq);
        };
    }

    @Nonnull
    public static <U> CharParser<U> satisfies2(@Nonnull Function<Character, Optional<U>> function) {
        Objects.requireNonNull(function, "'function' must not be null.");
        return seq -> {
            Character c;
            Optional result;
            if (seq.nonEmpty() && (result = (Optional)function.apply(c = (Character)seq.head())).isPresent()) {
                return new Result.Success(result.get(), (Seq)seq.tailView());
            }
            return new Result.NoParse(seq);
        };
    }

    @Nonnull
    public static <T> CharParser<Optional<T>> optional(@Nonnull CharParser<T> parser) {
        Objects.requireNonNull(parser, "'parser' must not be null.");
        return seq -> {
            Result result = parser.parse(seq);
            if (result.isNoParse()) {
                return new Result.Success(Optional.empty(), result.getRemaining());
            }
            return result.map(Optional::of);
        };
    }

    @Nonnull
    public static <T> CharParser<T> option(T fallback, @Nonnull CharParser<T> parser) {
        Objects.requireNonNull(parser, "'parser' must not be null.");
        return CharParser.optional(parser).map(optional -> optional.orElse(fallback));
    }

    @Nonnull
    public static <T> CharParser<T> optionOrGet(@Nonnull Supplier<T> fallbackSupplier, @Nonnull CharParser<T> parser) {
        Objects.requireNonNull(fallbackSupplier, "'fallbackSupplier' must not be null.");
        Objects.requireNonNull(parser, "'parser' must not be null.");
        return CharParser.optional(parser).map(optional -> optional.orElseGet(fallbackSupplier));
    }

    @Nonnull
    @SafeVarargs
    public static <T> CharParser<Seq<T>> sequence(CharParser<T> ... parsers) {
        Objects.requireNonNull(parsers, "'parsers' must not be null");
        if (parsers.length == 1) {
            return parsers[0].map(xva$0 -> Seq.of(xva$0));
        }
        Seq<CharParser<T>> s = Seq.wrap(parsers);
        return CharParser.sequence(s);
    }

    @Nonnull
    public static <T> CharParser<Seq<T>> sequence(@Nonnull Iterable<CharParser<T>> parsers) {
        Objects.requireNonNull(parsers, "'parsers' must not be null");
        if (parsers instanceof Collection && ((Collection)parsers).size() == 1 || parsers instanceof HasLength && ((HasLength)((Object)parsers)).length() == 1) {
            return parsers.iterator().next().map(xva$0 -> Seq.of(xva$0));
        }
        return seq -> {
            SeqBuilder seqBuilder = Seq.builder();
            Seq<Character> remaining = seq;
            for (CharParser p : parsers) {
                if (remaining.isEmpty()) {
                    return new Result.NoParse(seq);
                }
                Result result = p.parse(remaining);
                if (!result.isSuccess()) {
                    return result.withRemaining(seq).as();
                }
                remaining = result.getRemaining();
                seqBuilder.add(result.getValue());
            }
            return new Result.Success<Object>(seqBuilder.result(), remaining);
        };
    }

    @Nonnull
    public static <T> CharParser<Seq<T>> times(@Nonnegative int n, @Nonnull CharParser<T> parser) {
        Objects.requireNonNull(parser, "'parser' must not be null.");
        return seq -> {
            SeqBuilder seqBuilder = Seq.builder();
            Seq<Character> remaining = seq;
            for (int i = 0; i < n; ++i) {
                if (remaining.isEmpty()) {
                    return new Result.NoParse(seq);
                }
                Result result = parser.parse(remaining);
                if (!result.isSuccess()) {
                    return result.withRemaining(seq).as();
                }
                remaining = result.getRemaining();
                seqBuilder.add(result.getValue());
            }
            return new Result.Success<Object>(seqBuilder.result(), remaining);
        };
    }

    @Nonnull
    public static <T, U> CharParser<Pair<T, U>> seq(@Nonnull CharParser<T> p1, @Nonnull CharParser<U> p2) {
        Objects.requireNonNull(p1, "'p1' must not be null.");
        Objects.requireNonNull(p2, "'p2' must not be null.");
        return seq -> {
            Result r1 = p1.parse(seq);
            if (r1.isSuccess()) {
                Result r2 = p2.parse(r1.getRemaining());
                if (r2.isSuccess()) {
                    return new Result.Success(Pair.of(r1.getValue(), r2.getValue()), r2.getRemaining());
                }
                return r2.withRemaining(seq).as();
            }
            return r1.withRemaining(seq).as();
        };
    }

    @Nonnull
    public static <T, U, V> CharParser<Triple<T, U, V>> seq(@Nonnull CharParser<T> p1, @Nonnull CharParser<U> p2, @Nonnull CharParser<V> p3) {
        Objects.requireNonNull(p1, "'p1' must not be null.");
        Objects.requireNonNull(p2, "'p2' must not be null.");
        Objects.requireNonNull(p3, "'p3' must not be null.");
        return seq -> {
            Result r1 = p1.parse(seq);
            if (r1.isSuccess()) {
                Result r2 = p2.parse(r1.getRemaining());
                if (r2.isSuccess()) {
                    Result r3 = p3.parse(r2.getRemaining());
                    if (r3.isSuccess()) {
                        return new Result.Success(Triple.of(r1.getValue(), r2.getValue(), r3.getValue()), r3.getRemaining());
                    }
                    return r3.withRemaining(seq).as();
                }
                return r2.withRemaining(seq).as();
            }
            return r1.withRemaining(seq).as();
        };
    }

    @Nonnull
    public static <T, U, V, W> CharParser<Quadruple<T, U, V, W>> seq(@Nonnull CharParser<T> p1, @Nonnull CharParser<U> p2, @Nonnull CharParser<V> p3, @Nonnull CharParser<W> p4) {
        Objects.requireNonNull(p1, "'p1' must not be null.");
        Objects.requireNonNull(p2, "'p2' must not be null.");
        Objects.requireNonNull(p3, "'p3' must not be null.");
        Objects.requireNonNull(p4, "'p4' must not be null.");
        return seq -> {
            Result r1 = p1.parse(seq);
            if (r1.isSuccess()) {
                Result r2 = p2.parse(r1.getRemaining());
                if (r2.isSuccess()) {
                    Result r3 = p3.parse(r2.getRemaining());
                    if (r3.isSuccess()) {
                        Result r4 = p4.parse(r3.getRemaining());
                        if (r4.isSuccess()) {
                            return new Result.Success(Quadruple.of(r1.getValue(), r2.getValue(), r3.getValue(), r4.getValue()), r4.getRemaining());
                        }
                        return r4.withRemaining(seq).as();
                    }
                    return r3.withRemaining(seq).as();
                }
                return r2.withRemaining(seq).as();
            }
            return r1.withRemaining(seq).as();
        };
    }

    @Nonnull
    public static <T> CharParser<Seq<T>> many(@Nonnull CharParser<T> parser) {
        Objects.requireNonNull(parser, "'parser' must not be null.");
        return seq -> {
            SeqBuilder resultBuilder = Seq.builder();
            Seq<Character> remaining = seq;
            while (remaining.nonEmpty()) {
                Result result = parser.parse(remaining);
                if (!result.isSuccess()) {
                    return new Result.Success<Object>(resultBuilder.result(), remaining);
                }
                resultBuilder.add(result.getValue());
                remaining = result.getRemaining();
            }
            return new Result.Success<Object>(resultBuilder.result(), remaining);
        };
    }

    @Nonnull
    public static <T> CharParser<Seq<T>> many1(@Nonnull CharParser<T> parser) {
        Objects.requireNonNull(parser, "'parser' must not be null.");
        CharParser manyCharParser = CharParser.many(parser);
        return seq -> {
            Result result = manyCharParser.parse(seq);
            if (result.isSuccess() && ((Seq)result.getValue()).isEmpty()) {
                return new Result.NoParse(seq);
            }
            return result;
        };
    }

    @Nonnull
    public static <T> CharParser<Void> skipMany(@Nonnull CharParser<T> parser) {
        Objects.requireNonNull(parser, "'parser' must not be null.");
        return seq -> {
            Seq<Character> remaining = seq;
            while (remaining.nonEmpty()) {
                Result result = parser.parse(remaining);
                if (!result.isSuccess()) {
                    return new Result.Success<Object>(null, remaining);
                }
                remaining = result.getRemaining();
            }
            return new Result.Success<Object>(null, remaining);
        };
    }

    @Nonnull
    public static <T, U> CharParser<Seq<T>> sepBy(@Nonnull CharParser<T> parser, @Nonnull CharParser<U> sep) {
        Objects.requireNonNull(parser, "'parser' must not be null.");
        Objects.requireNonNull(sep, "'sep' must not be null.");
        CharParser p = CharParser.right(sep, parser);
        return seq -> {
            SeqBuilder resultBuilder = Seq.builder();
            Seq<Character> remaining = seq;
            Result result = parser.parse(remaining);
            if (result.isSuccess()) {
                resultBuilder.add(result.getValue());
                remaining = result.getRemaining();
                while (remaining.nonEmpty()) {
                    result = p.parse(remaining);
                    if (!result.isSuccess()) {
                        return new Result.Success<Object>(resultBuilder.result(), remaining);
                    }
                    resultBuilder.add(result.getValue());
                    remaining = result.getRemaining();
                }
            }
            return new Result.Success<Object>(resultBuilder.result(), remaining);
        };
    }

    @Nonnull
    public static <T, U> CharParser<Seq<T>> sepBy1(@Nonnull CharParser<T> parser, @Nonnull CharParser<U> sep) {
        Objects.requireNonNull(parser, "'parser' must not be null.");
        Objects.requireNonNull(sep, "'sep' must not be null.");
        CharParser sepByCharParser = CharParser.sepBy(parser, sep);
        return seq -> {
            Result result = sepByCharParser.parse(seq);
            if (result.isSuccess() && ((Seq)result.getValue()).isEmpty()) {
                return new Result.NoParse(seq);
            }
            return result;
        };
    }

    @Nonnull
    public static <S, T, U> CharParser<T> between(@Nonnull CharParser<S> s, @Nonnull CharParser<T> t, @Nonnull CharParser<U> u) {
        Objects.requireNonNull(s, "'s' must not be null.");
        Objects.requireNonNull(t, "'t' must not be null.");
        Objects.requireNonNull(u, "'u' must not be null.");
        return CharParser.seq(s, t, u).map(Triple::getSecond);
    }

    @Nonnull
    public static <T> CharParser<T> recursive(@Nonnull Supplier<CharParser<T>> supplier) {
        Objects.requireNonNull(supplier, "'supplier' must not be null.");
        Function0 parserSupplier = Control.memoizing(supplier);
        return seq -> ((CharParser)parserSupplier.get()).parse(seq);
    }

    public static abstract class Result<E> {
        @Nonnull
        public abstract <F> Result<F> map(@Nonnull Function<E, F> var1);

        @Nonnull
        public abstract Seq<Character> getRemaining();

        @Nonnull
        public abstract Result<E> withRemaining(@Nonnull Seq<Character> var1);

        public E getValue() {
            return null;
        }

        public boolean isSuccess() {
            return false;
        }

        public boolean isNoParse() {
            return false;
        }

        @Nonnull
        <T> Result<T> as() {
            return this;
        }

        @Generated
        Result() {
        }

        public static final class NoParse<E>
        extends Result<E> {
            private final Seq<Character> remaining;

            @Override
            @Nonnull
            public <F> Result<F> map(@Nonnull Function<E, F> f) {
                return this;
            }

            @Override
            public boolean isNoParse() {
                return true;
            }

            @Generated
            public NoParse(Seq<Character> remaining) {
                this.remaining = remaining;
            }

            @Override
            @Generated
            public Seq<Character> getRemaining() {
                return this.remaining;
            }

            @Generated
            public String toString() {
                return "CharParser.Result.NoParse(remaining=" + this.getRemaining() + ")";
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof NoParse)) {
                    return false;
                }
                NoParse other = (NoParse)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Seq<Character> this$remaining = this.getRemaining();
                Seq<Character> other$remaining = other.getRemaining();
                return !(this$remaining == null ? other$remaining != null : !((Object)this$remaining).equals(other$remaining));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof NoParse;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Seq<Character> $remaining = this.getRemaining();
                result = result * 59 + ($remaining == null ? 43 : ((Object)$remaining).hashCode());
                return result;
            }

            @Override
            @Generated
            public NoParse<E> withRemaining(Seq<Character> remaining) {
                return this.remaining == remaining ? this : new NoParse<E>(remaining);
            }
        }

        public static final class Success<E>
        extends Result<E> {
            private final E value;
            private final Seq<Character> remaining;

            @Override
            @Nonnull
            public <F> Result<F> map(@Nonnull Function<E, F> f) {
                return new Success<F>(f.apply(this.value), this.remaining);
            }

            @Override
            public boolean isSuccess() {
                return true;
            }

            @Generated
            public Success(E value, Seq<Character> remaining) {
                this.value = value;
                this.remaining = remaining;
            }

            @Override
            @Generated
            public E getValue() {
                return this.value;
            }

            @Override
            @Generated
            public Seq<Character> getRemaining() {
                return this.remaining;
            }

            @Generated
            public String toString() {
                return "CharParser.Result.Success(value=" + this.getValue() + ", remaining=" + this.getRemaining() + ")";
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Success)) {
                    return false;
                }
                Success other = (Success)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                E this$value = this.getValue();
                E other$value = other.getValue();
                if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                    return false;
                }
                Seq<Character> this$remaining = this.getRemaining();
                Seq<Character> other$remaining = other.getRemaining();
                return !(this$remaining == null ? other$remaining != null : !((Object)this$remaining).equals(other$remaining));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Success;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                E $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                Seq<Character> $remaining = this.getRemaining();
                result = result * 59 + ($remaining == null ? 43 : ((Object)$remaining).hashCode());
                return result;
            }

            @Override
            @Generated
            public Success<E> withRemaining(Seq<Character> remaining) {
                return this.remaining == remaining ? this : new Success<E>(this.value, remaining);
            }
        }
    }
}

