/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import de.scravy.bedrock.ArrayMap;
import de.scravy.bedrock.ThrowingRunnable;
import de.scravy.bedrock.Unstable;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.Generated;

@Unstable
public final class Context {
    private static final ThreadLocal<Context> currentcontext = ThreadLocal.withInitial(() -> null);
    private final Context parent;
    private final ArrayMap<String, Object> bindings;

    public static Object get(String id) {
        return Context.getInstance().apply(id);
    }

    @Nonnull
    public static <T> Optional<T> getOptionally(@Nonnull String id, @Nonnull Class<T> clazz) {
        Objects.requireNonNull(id);
        Objects.requireNonNull(clazz);
        Object obj = Context.get(id);
        if (obj == null) {
            return Optional.empty();
        }
        if (!clazz.isAssignableFrom(obj.getClass())) {
            return Optional.empty();
        }
        Object result = obj;
        return Optional.of(result);
    }

    @Nonnull
    public static <T> T get(@Nonnull String id, @Nonnull Class<T> clazz) throws IllegalStateException {
        Objects.requireNonNull(id);
        Objects.requireNonNull(clazz);
        Object obj = Context.get(id);
        if (obj == null) {
            throw new IllegalStateException("not in context: " + id);
        }
        if (!clazz.isAssignableFrom(obj.getClass())) {
            throw new IllegalArgumentException("context object is of incompatible type to the one requested.");
        }
        Object result = obj;
        return (T)result;
    }

    private Object apply(@Nonnull String id) {
        Context current = this;
        do {
            Optional<Object> obj;
            if (!(obj = current.bindings.get(id)).isPresent()) continue;
            return obj.get();
        } while ((current = current.parent) != null);
        return null;
    }

    public static void withContext(ArrayMap<String, Object> mappings, ThrowingRunnable f) {
        Context context = currentcontext.get();
        currentcontext.set(new Context(context, mappings));
        try {
            f.run();
        }
        finally {
            currentcontext.set(context);
        }
    }

    @Nonnull
    public static Context getInstance() throws IllegalStateException {
        Context context = currentcontext.get();
        if (context == null) {
            throw new IllegalStateException("no context set currently");
        }
        return currentcontext.get();
    }

    @Generated
    public Context(Context parent, ArrayMap<String, Object> bindings) {
        this.parent = parent;
        this.bindings = bindings;
    }

    @Generated
    public Context getParent() {
        return this.parent;
    }

    @Generated
    public ArrayMap<String, Object> getBindings() {
        return this.bindings;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Context)) {
            return false;
        }
        Context other = (Context)o;
        Context this$parent = this.getParent();
        Context other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !((Object)this$parent).equals(other$parent)) {
            return false;
        }
        ArrayMap<String, Object> this$bindings = this.getBindings();
        ArrayMap<String, Object> other$bindings = other.getBindings();
        return !(this$bindings == null ? other$bindings != null : !((Object)this$bindings).equals(other$bindings));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Context $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : ((Object)$parent).hashCode());
        ArrayMap<String, Object> $bindings = this.getBindings();
        result = result * 59 + ($bindings == null ? 43 : ((Object)$bindings).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Context(parent=" + this.getParent() + ", bindings=" + this.getBindings() + ")";
    }
}

