/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import de.scravy.bedrock.AsyncExecutionException;
import de.scravy.bedrock.Box;
import de.scravy.bedrock.Callback;
import de.scravy.bedrock.Function0;
import de.scravy.bedrock.LightweightRuntimeException;
import de.scravy.bedrock.NoOp;
import de.scravy.bedrock.ParallelExecutionException;
import de.scravy.bedrock.Promise;
import de.scravy.bedrock.Seq;
import de.scravy.bedrock.SeqBuilder;
import de.scravy.bedrock.SeqSimple;
import de.scravy.bedrock.TaskCompletedMoreThanOnceException;
import de.scravy.bedrock.ThrowingBiConsumer;
import de.scravy.bedrock.ThrowingConsumer;
import de.scravy.bedrock.ThrowingFunction;
import de.scravy.bedrock.ThrowingIntConsumer;
import de.scravy.bedrock.ThrowingRunnable;
import de.scravy.bedrock.Try;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.LongFunction;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import lombok.Generated;

public final class Control {
    @Nonnull
    public static <A, T> TypeOfBranch<A, T> type(@Nonnull Class<A> clazz, @Nonnull ThrowingFunction<A, T> f) {
        return new TypeOfBranch(clazz, f);
    }

    @Nonnull
    public static <A> TypeOfVoidBranch<A> type_(@Nonnull Class<A> clazz, @Nonnull ThrowingConsumer<A> f) {
        return new TypeOfVoidBranch(clazz, f);
    }

    @SafeVarargs
    public static <T> T typeOf(Object value, TypeOfBranch<?, ? extends T> ... typeOfBranches) {
        for (TypeOfBranch<?, T> typeOfBranch : typeOfBranches) {
            if (!typeOfBranch.getClazz().isAssignableFrom(value.getClass())) continue;
            return (T)Try.execute(() -> branch.getCallable().execute(value)).orElseThrowRuntime();
        }
        return null;
    }

    public static void typeOf(Object value, TypeOfVoidBranch<?> ... branches) {
        for (TypeOfVoidBranch<?> branch : branches) {
            if (!branch.getClazz().isAssignableFrom(value.getClass())) continue;
            Try.run(() -> branch.getCallable().accept(value));
            return;
        }
    }

    @Nonnull
    public static <A, T> ValueOfBranch<A, T> value(@Nonnull A value, @Nonnull ThrowingFunction<A, T> f) {
        return new ValueOfBranch(value, f);
    }

    @Nonnull
    public static <A> ValueOfVoidBranch<A> value_(@Nonnull A value, @Nonnull ThrowingConsumer<A> f) {
        return new ValueOfVoidBranch(value, f);
    }

    @SafeVarargs
    public static <T> T valueOf(Object value, ValueOfBranch<?, ? extends T> ... typeOfBranches) {
        for (ValueOfBranch<?, T> valueOfBranch : typeOfBranches) {
            if (!Objects.equals(value, valueOfBranch.getValue())) continue;
            return (T)Try.execute(() -> branch.getCallable().execute(value)).orElseThrowRuntime();
        }
        return null;
    }

    public static void valueOf(Object value, ValueOfVoidBranch<?> ... branches) {
        for (ValueOfVoidBranch<?> branch : branches) {
            if (!Objects.equals(value, branch.getValue())) continue;
            Try.run(() -> branch.getCallable().accept(value));
            return;
        }
    }

    public static Thread.UncaughtExceptionHandler uncaughtExceptionHandler() {
        return Optional.ofNullable(Thread.currentThread().getUncaughtExceptionHandler()).orElse(NoOp.uncaughtExceptionHandler());
    }

    public static void report(@Nonnull Object err) {
        Control.uncaughtExceptionHandler().uncaughtException(Thread.currentThread(), Control.toThrowable(err));
    }

    public static void forever(@Nonnull ThrowingRunnable runnable) {
        Control.forever(Control.uncaughtExceptionHandler(), runnable);
    }

    public static void forever(@Nonnull Thread.UncaughtExceptionHandler exceptionHandler, @Nonnull ThrowingRunnable runnable) {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                runnable.execute();
            }
            catch (InterruptedException exc) {
                return;
            }
            catch (Exception exc) {
                exceptionHandler.uncaughtException(Thread.currentThread(), exc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean wait(Object monitor) {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                Object object = monitor;
                synchronized (object) {
                    monitor.wait();
                }
            }
            catch (InterruptedException exc) {
                return false;
            }
        }
        return true;
    }

    public static void sleep(Duration duration) {
        long started = System.nanoTime();
        while (true) {
            try {
                Thread.sleep(duration.toMillis());
                return;
            }
            catch (InterruptedException interruptedException) {
                if (System.nanoTime() - started < duration.toNanos()) continue;
                return;
            }
            break;
        }
    }

    public static void parallel(@Nonnull Executor executor, ThrowingRunnable ... runnables) throws ParallelExecutionException {
        Objects.requireNonNull(executor, "executor must not be null");
        Objects.requireNonNull(runnables, "nullables must not be null");
        Semaphore semaphore = new Semaphore(0);
        List exceptions = Collections.synchronizedList(new ArrayList());
        for (ThrowingRunnable runnable : runnables) {
            executor.execute(() -> {
                try {
                    runnable.run();
                }
                catch (Exception exc) {
                    exceptions.add(exc);
                }
                finally {
                    semaphore.release(1);
                }
            });
        }
        semaphore.acquireUninterruptibly(runnables.length);
        if (!exceptions.isEmpty()) {
            throw new ParallelExecutionException(Seq.ofCollection(exceptions));
        }
    }

    @SafeVarargs
    public static <T> Seq<T> parallel(@Nonnull Executor executor, Callable<? extends T> ... runnables) throws ParallelExecutionException {
        Objects.requireNonNull(executor, "executor must not be null");
        Objects.requireNonNull(runnables, "nullables must not be null");
        Promise[] promises = new Promise[runnables.length];
        int i = 0;
        for (Callable runnable : runnables) {
            Promise promise = Promise.promise();
            promises[i++] = promise;
            executor.execute(() -> {
                try {
                    Object result = runnable.call();
                    promise.fulfill(result);
                }
                catch (Exception exc) {
                    promise.fail(exc);
                }
            });
        }
        SeqBuilder results = Seq.builder();
        SeqBuilder exceptions = Seq.builder();
        for (Promise promise : promises) {
            promise.waitFor();
            if (promise.isSuccess()) {
                results.add(promise.get());
                continue;
            }
            exceptions.add(promise.getException());
        }
        if (exceptions.isEmpty()) {
            return (Seq)results.build();
        }
        throw new ParallelExecutionException((Seq<Throwable>)exceptions.result());
    }

    @SafeVarargs
    public static <T> ThrowingConsumer<Callback<Seq<T>>> parallel(ThrowingConsumer<Callback<T>> ... actions) {
        return callback -> {
            boolean[] hasResult = new boolean[actions.length];
            Object[] results = new Object[actions.length];
            Object[] errors = new Object[actions.length];
            AtomicInteger outstanding = new AtomicInteger(actions.length);
            Function<Integer, Callback> cb = ix -> (err, res) -> {
                ThrowingConsumer throwingConsumer = actions[ix];
                synchronized (throwingConsumer) {
                    if (hasResult[ix]) {
                        Control.report(new TaskCompletedMoreThanOnceException(actions[ix], errors[ix], results[ix], err, res));
                        return;
                    }
                    hasResult[ix.intValue()] = true;
                }
                errors[ix.intValue()] = err;
                results[ix.intValue()] = res;
                if (outstanding.decrementAndGet() == 0) {
                    SeqSimple<Object> errorsSeq = Seq.ofArrayZeroCopyInternal(errors);
                    SeqSimple resultsSeq = Seq.ofArrayZeroCopyInternal(results);
                    ParallelExecutionException error = errorsSeq.exists(Objects::nonNull) ? new ParallelExecutionException(errorsSeq.map(Control::toThrowable)) : null;
                    callback.call(error, resultsSeq);
                }
            };
            int i = 0;
            for (ThrowingConsumer action : actions) {
                int myIndex = i++;
                try {
                    action.consume(cb.apply(myIndex));
                }
                catch (Exception exc) {
                    cb.apply(myIndex).fail(exc);
                }
            }
        };
    }

    @Nonnull
    public static <A> Async<A, A> async() {
        return new Async((t, cb) -> cb.success(t));
    }

    @Nonnull
    public static <In, Out> Async<In, Out> async(@Nonnull ThrowingBiConsumer<In, Callback<Out>> function) {
        Objects.requireNonNull(function, "'function' must not be null.");
        return new Async(function);
    }

    @Nonnull
    public static <A> Async<A, A> waterfall(@Nonnull List<ThrowingBiConsumer<A, Callback<A>>> fs) {
        return Control.waterfall(Seq.wrap(fs));
    }

    @Nonnull
    public static <A> Async<A, A> waterfall(@Nonnull Seq<ThrowingBiConsumer<A, Callback<A>>> fs) {
        return fs.foldl(Async::then, Control.async());
    }

    @Nonnull
    @SafeVarargs
    public static <A> Async<A, A> waterfall(ThrowingBiConsumer<A, Callback<A>> ... fs) {
        return Control.waterfall(Seq.ofArrayZeroCopyInternal(fs));
    }

    public static Throwable toThrowable(Object object) {
        if (object instanceof Throwable) {
            return (Throwable)object;
        }
        if (object instanceof String) {
            return new LightweightRuntimeException((String)object);
        }
        if (object instanceof Seq && ((Seq)object).forAll(obj -> obj instanceof Throwable)) {
            return new ParallelExecutionException((Seq)object);
        }
        return new AsyncExecutionException(object);
    }

    public static <A> A iterate(@Nonnull UnaryOperator<A> operation, @Nonnull BiPredicate<A, A> exitCriterion, A startValue) {
        A previousValue;
        Objects.requireNonNull(operation, "'operation' must not be null");
        Objects.requireNonNull(exitCriterion, "'exitCriterion' must not be null");
        Object currentValue = startValue;
        while (!exitCriterion.test(previousValue = currentValue, currentValue = operation.apply(currentValue))) {
        }
        return currentValue;
    }

    public static <A> A exhaustively(@Nonnull UnaryOperator<A> operation, A startValue) {
        Objects.requireNonNull(operation, "'operation' must not be null");
        return (A)Control.iterate(operation, Objects::equals, startValue);
    }

    public static <E> void swap(@Nonnull E[] array, int i, int j) {
        Objects.requireNonNull(array, "'array' must not be null");
        E src = array[i];
        array[i] = array[j];
        array[j] = src;
    }

    public static void swap(@Nonnull boolean[] array, int i, int j) {
        Objects.requireNonNull(array, "'array' must not be null");
        boolean src = array[i];
        array[i] = array[j];
        array[j] = src;
    }

    public static void swap(@Nonnull char[] array, int i, int j) {
        Objects.requireNonNull(array, "'array' must not be null");
        char src = array[i];
        array[i] = array[j];
        array[j] = src;
    }

    public static void swap(@Nonnull byte[] array, int i, int j) {
        Objects.requireNonNull(array, "'array' must not be null");
        byte src = array[i];
        array[i] = array[j];
        array[j] = src;
    }

    public static void swap(@Nonnull short[] array, int i, int j) {
        Objects.requireNonNull(array, "'array' must not be null");
        short src = array[i];
        array[i] = array[j];
        array[j] = src;
    }

    public static void swap(@Nonnull int[] array, int i, int j) {
        Objects.requireNonNull(array, "'array' must not be null");
        int src = array[i];
        array[i] = array[j];
        array[j] = src;
    }

    public static void swap(@Nonnull long[] array, int i, int j) {
        Objects.requireNonNull(array, "'array' must not be null");
        long src = array[i];
        array[i] = array[j];
        array[j] = src;
    }

    public static void swap(@Nonnull double[] array, int i, int j) {
        Objects.requireNonNull(array, "'array' must not be null");
        double src = array[i];
        array[i] = array[j];
        array[j] = src;
    }

    public static void swap(@Nonnull float[] array, int i, int j) {
        Objects.requireNonNull(array, "'array' must not be null");
        float src = array[i];
        array[i] = array[j];
        array[j] = src;
    }

    @Nonnull
    public static <A, R> Function<A, R> memoizing(@Nonnull Function<A, R> function) {
        Objects.requireNonNull(function, "'function' must not be null");
        HashMap cachedValues = new HashMap();
        return arg -> cachedValues.computeIfAbsent(arg, function);
    }

    @Nonnull
    public static <R> IntFunction<R> memoizing(@Nonnull IntFunction<R> function) {
        Objects.requireNonNull(function, "'function' must not be null");
        HashMap cachedValues = new HashMap();
        return arg -> cachedValues.computeIfAbsent(arg, function::apply);
    }

    @Nonnull
    public static <R> LongFunction<R> memoizing(@Nonnull LongFunction<R> function) {
        Objects.requireNonNull(function, "'function' must not be null");
        HashMap cachedValues = new HashMap();
        return arg -> cachedValues.computeIfAbsent(arg, function::apply);
    }

    @Nonnull
    public static <T> Function0<T> memoizing(final @Nonnull Supplier<T> supplier) {
        Objects.requireNonNull(supplier, "'supplier' must not be null");
        return new Function0<T>(){
            private final SupplierMemoBox<T> box;
            {
                this.box = new SupplierMemoBox<Object>(supplier, null);
            }

            @Override
            public T get() {
                if (this.box.supplier != null) {
                    this.box.value = this.box.supplier.get();
                    this.box.supplier = null;
                }
                return this.box.value;
            }

            @Override
            @Nonnull
            public Function0<T> memoizing() {
                return this;
            }
        };
    }

    @Nonnull
    public static <T> Supplier<T> atomic(@Nonnull Supplier<T> supplier) {
        Objects.requireNonNull(supplier, "'supplier' must not be null");
        return () -> {
            Supplier supplier2 = supplier;
            synchronized (supplier2) {
                return supplier.get();
            }
        };
    }

    public static void times(int n, @Nonnull ThrowingIntConsumer runnable) {
        Objects.requireNonNull(runnable, "'runnable' most not be null");
        for (int i = 0; i < n; ++i) {
            runnable.accept(i);
        }
    }

    @Nonnull
    @SafeVarargs
    public static <K, T> Optional<T> findFirstNonNull(K k, Function<? super K, ? extends T> ... fs) {
        for (Function<K, K> function : fs) {
            T result = function.apply(k);
            if (result == null) continue;
            return Optional.of(result);
        }
        return Optional.empty();
    }

    @Generated
    private Control() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static final class TypeOfBranch<A, T> {
        private final Class<A> clazz;
        private final ThrowingFunction<A, T> callable;

        @Generated
        public Class<A> getClazz() {
            return this.clazz;
        }

        @Generated
        public ThrowingFunction<A, T> getCallable() {
            return this.callable;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TypeOfBranch)) {
                return false;
            }
            TypeOfBranch other = (TypeOfBranch)o;
            Class<A> this$clazz = this.getClazz();
            Class<A> other$clazz = other.getClazz();
            if (this$clazz == null ? other$clazz != null : !this$clazz.equals(other$clazz)) {
                return false;
            }
            ThrowingFunction<A, T> this$callable = this.getCallable();
            ThrowingFunction<A, T> other$callable = other.getCallable();
            return !(this$callable == null ? other$callable != null : !this$callable.equals(other$callable));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<A> $clazz = this.getClazz();
            result = result * 59 + ($clazz == null ? 43 : $clazz.hashCode());
            ThrowingFunction<A, T> $callable = this.getCallable();
            result = result * 59 + ($callable == null ? 43 : $callable.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Control.TypeOfBranch(clazz=" + this.getClazz() + ", callable=" + this.getCallable() + ")";
        }

        @Generated
        private TypeOfBranch(Class<A> clazz, ThrowingFunction<A, T> callable) {
            this.clazz = clazz;
            this.callable = callable;
        }
    }

    public static final class TypeOfVoidBranch<A> {
        private final Class<A> clazz;
        private final ThrowingConsumer<A> callable;

        @Generated
        public Class<A> getClazz() {
            return this.clazz;
        }

        @Generated
        public ThrowingConsumer<A> getCallable() {
            return this.callable;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TypeOfVoidBranch)) {
                return false;
            }
            TypeOfVoidBranch other = (TypeOfVoidBranch)o;
            Class<A> this$clazz = this.getClazz();
            Class<A> other$clazz = other.getClazz();
            if (this$clazz == null ? other$clazz != null : !this$clazz.equals(other$clazz)) {
                return false;
            }
            ThrowingConsumer<A> this$callable = this.getCallable();
            ThrowingConsumer<A> other$callable = other.getCallable();
            return !(this$callable == null ? other$callable != null : !this$callable.equals(other$callable));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<A> $clazz = this.getClazz();
            result = result * 59 + ($clazz == null ? 43 : $clazz.hashCode());
            ThrowingConsumer<A> $callable = this.getCallable();
            result = result * 59 + ($callable == null ? 43 : $callable.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Control.TypeOfVoidBranch(clazz=" + this.getClazz() + ", callable=" + this.getCallable() + ")";
        }

        @Generated
        private TypeOfVoidBranch(Class<A> clazz, ThrowingConsumer<A> callable) {
            this.clazz = clazz;
            this.callable = callable;
        }
    }

    public static final class ValueOfBranch<A, T> {
        private final A value;
        private final ThrowingFunction<A, T> callable;

        @Generated
        public A getValue() {
            return this.value;
        }

        @Generated
        public ThrowingFunction<A, T> getCallable() {
            return this.callable;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ValueOfBranch)) {
                return false;
            }
            ValueOfBranch other = (ValueOfBranch)o;
            A this$value = this.getValue();
            A other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            ThrowingFunction<A, T> this$callable = this.getCallable();
            ThrowingFunction<A, T> other$callable = other.getCallable();
            return !(this$callable == null ? other$callable != null : !this$callable.equals(other$callable));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            A $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            ThrowingFunction<A, T> $callable = this.getCallable();
            result = result * 59 + ($callable == null ? 43 : $callable.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Control.ValueOfBranch(value=" + this.getValue() + ", callable=" + this.getCallable() + ")";
        }

        @Generated
        private ValueOfBranch(A value, ThrowingFunction<A, T> callable) {
            this.value = value;
            this.callable = callable;
        }
    }

    public static final class ValueOfVoidBranch<A> {
        private final A value;
        private final ThrowingConsumer<A> callable;

        @Generated
        public A getValue() {
            return this.value;
        }

        @Generated
        public ThrowingConsumer<A> getCallable() {
            return this.callable;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ValueOfVoidBranch)) {
                return false;
            }
            ValueOfVoidBranch other = (ValueOfVoidBranch)o;
            A this$value = this.getValue();
            A other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            ThrowingConsumer<A> this$callable = this.getCallable();
            ThrowingConsumer<A> other$callable = other.getCallable();
            return !(this$callable == null ? other$callable != null : !this$callable.equals(other$callable));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            A $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            ThrowingConsumer<A> $callable = this.getCallable();
            result = result * 59 + ($callable == null ? 43 : $callable.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Control.ValueOfVoidBranch(value=" + this.getValue() + ", callable=" + this.getCallable() + ")";
        }

        @Generated
        private ValueOfVoidBranch(A value, ThrowingConsumer<A> callable) {
            this.value = value;
            this.callable = callable;
        }
    }

    public static final class Async<In, Out>
    implements ThrowingBiConsumer<In, Callback<Out>>,
    Function<In, Promise<Out>> {
        private final AsyncFunction<In, Out> function;
        private final AsyncOptions options;

        private Async(@Nonnull AsyncFunction<In, Out> function) {
            this(function, AsyncOptions.defaultOptions());
        }

        private Async(@Nonnull ThrowingBiConsumer<In, Callback<Out>> function) {
            this((AsyncOptions opts, In arg, AsyncCallback<Out> callback) -> function.consume(arg, (error, result) -> callback.call(opts, error, result)));
        }

        @Nonnull
        public final <T> Async<In, T> then(@Nonnull ThrowingBiConsumer<Out, Callback<T>> function) {
            Objects.requireNonNull(function, "'function' must not be null.");
            return new Async((options, argument, callback) -> this.runWithOptions(options, argument, (opts, error, result) -> {
                if (error == null) {
                    super.runWithOptions(opts, result, callback);
                } else {
                    opts.getCallbackHandler().accept(() -> callback.call(opts, error, null));
                }
            }), this.options);
        }

        @Nonnull
        @SafeVarargs
        public final <T> Async<In, Seq<T>> then(@Nonnull ThrowingBiConsumer<Out, Callback<T>> function, ThrowingBiConsumer<Out, Callback<T>> ... functions) {
            Objects.requireNonNull(function, "'function' must not be null.");
            Objects.requireNonNull(functions, "'functions' must not be null.");
            Async[] asyncs = new Async[1 + functions.length];
            asyncs[0] = Control.async(function);
            int i = 0;
            while (i < functions.length) {
                Async<Out, T> asyncFunction = Control.async(functions[i]);
                asyncs[++i] = asyncFunction;
            }
            return new Async((options, argument, callback) -> this.runWithOptions(options, argument, (opts, error, result) -> {
                if (error == null) {
                    Object[] results = new Object[asyncs.length];
                    Object[] errors = new Object[asyncs.length];
                    Box.IntBox numberOfReturns = Box.intBox(0);
                    Box.IntBox numberOfErrors = Box.intBox(0);
                    for (int i = 0; i < asyncs.length; ++i) {
                        int myIndex = i;
                        asyncs[i].runWithOptions(opts, result, (opts2, error2, result2) -> {
                            boolean lastOne;
                            if (error2 == null) {
                                results[myIndex] = result2;
                            } else {
                                errors[myIndex] = error2;
                                Box.IntBox intBox = numberOfErrors;
                                synchronized (intBox) {
                                    numberOfErrors.update(n -> n + 1);
                                }
                            }
                            Box.IntBox intBox = numberOfReturns;
                            synchronized (intBox) {
                                lastOne = numberOfReturns.update(n -> n + 1) == asyncs.length;
                            }
                            if (lastOne) {
                                if (numberOfErrors.get() == 0) {
                                    opts.getCallbackHandler().accept(() -> callback.call(opts, null, new SeqSimple(results)));
                                } else {
                                    opts.getCallbackHandler().accept(() -> callback.call(opts, new SeqSimple(errors), new SeqSimple(results)));
                                }
                            }
                        });
                    }
                } else {
                    opts.getCallbackHandler().accept(() -> callback.call(opts, error, null));
                }
            }), this.options);
        }

        private void runWithOptions(@Nonnull AsyncOptions options, In argument, @Nonnull AsyncCallback<Out> callback) {
            try {
                options.getExecutor().execute(() -> {
                    try {
                        this.function.run(options, argument, (AsyncOptions opts, Object error, Out result) -> opts.getCallbackHandler().accept(() -> callback.call(opts, error, result)));
                    }
                    catch (Exception exc) {
                        options.getCallbackHandler().accept(() -> callback.call(options, exc, null));
                    }
                });
            }
            catch (Exception exc) {
                options.getCallbackHandler().accept(() -> callback.call(options, exc, null));
            }
        }

        public void run(In argument, @Nonnull Callback<Out> callback) {
            this.runWithOptions(this.options, argument, (opts, error, result) -> callback.call(error, result));
        }

        public void run(@Nonnull Executor executor, In argument, @Nonnull Callback<Out> callback) {
            this.runWithOptions(this.options.withExecutor(executor), argument, (opts, error, result) -> callback.call(error, result));
        }

        @Nonnull
        public Promise<Out> runPromised(In argument) {
            return this.runPromised(this.options, argument);
        }

        @Nonnull
        public Promise<Out> runPromised(@Nonnull Executor executor, In argument) {
            return this.runPromised(this.options.withExecutor(executor), argument);
        }

        @Nonnull
        private Promise<Out> runPromised(@Nonnull AsyncOptions options, In argument) {
            Promise promise = Promise.promise();
            this.runWithOptions(options, argument, (opts, error, result) -> {
                if (error == null) {
                    promise.fulfill(result);
                } else {
                    promise.fail(Control.toThrowable(error));
                }
            });
            return promise;
        }

        @Override
        public void consume(In argument, @Nonnull Callback<Out> callback) {
            this.run(argument, callback);
        }

        @Override
        @Nonnull
        public Promise<Out> apply(In in) {
            return this.runPromised(in);
        }

        @Generated
        private Async(AsyncFunction<In, Out> function, AsyncOptions options) {
            this.function = function;
            this.options = options;
        }

        @Generated
        private Async<In, Out> withFunction(AsyncFunction<In, Out> function) {
            return this.function == function ? this : new Async<In, Out>(function, this.options);
        }

        @Generated
        private Async<In, Out> withOptions(AsyncOptions options) {
            return this.options == options ? this : new Async<In, Out>(this.function, options);
        }

        private static final class AsyncOptions {
            private final Executor executor;
            private final Consumer<ThrowingRunnable> callbackHandler;
            private static final AsyncOptions DEFAULT_OPTIONS = new AsyncOptions(Runnable::run, Try::unfailable);

            @Nonnull
            public static AsyncOptions defaultOptions() {
                return DEFAULT_OPTIONS;
            }

            @Generated
            public AsyncOptions(Executor executor, Consumer<ThrowingRunnable> callbackHandler) {
                this.executor = executor;
                this.callbackHandler = callbackHandler;
            }

            @Generated
            public Executor getExecutor() {
                return this.executor;
            }

            @Generated
            public Consumer<ThrowingRunnable> getCallbackHandler() {
                return this.callbackHandler;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AsyncOptions)) {
                    return false;
                }
                AsyncOptions other = (AsyncOptions)o;
                Executor this$executor = this.getExecutor();
                Executor other$executor = other.getExecutor();
                if (this$executor == null ? other$executor != null : !this$executor.equals(other$executor)) {
                    return false;
                }
                Consumer<ThrowingRunnable> this$callbackHandler = this.getCallbackHandler();
                Consumer<ThrowingRunnable> other$callbackHandler = other.getCallbackHandler();
                return !(this$callbackHandler == null ? other$callbackHandler != null : !this$callbackHandler.equals(other$callbackHandler));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Executor $executor = this.getExecutor();
                result = result * 59 + ($executor == null ? 43 : $executor.hashCode());
                Consumer<ThrowingRunnable> $callbackHandler = this.getCallbackHandler();
                result = result * 59 + ($callbackHandler == null ? 43 : $callbackHandler.hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Control.Async.AsyncOptions(executor=" + this.getExecutor() + ", callbackHandler=" + this.getCallbackHandler() + ")";
            }

            @Generated
            public AsyncOptions withExecutor(Executor executor) {
                return this.executor == executor ? this : new AsyncOptions(executor, this.callbackHandler);
            }

            @Generated
            public AsyncOptions withCallbackHandler(Consumer<ThrowingRunnable> callbackHandler) {
                return this.callbackHandler == callbackHandler ? this : new AsyncOptions(this.executor, callbackHandler);
            }
        }

        @FunctionalInterface
        private static interface AsyncFunction<In, Out> {
            public void run(@Nonnull AsyncOptions var1, In var2, @Nonnull AsyncCallback<Out> var3) throws Exception;
        }

        @FunctionalInterface
        private static interface AsyncCallback<Out> {
            public void call(@Nonnull AsyncOptions var1, Object var2, Out var3) throws Exception;
        }
    }

    private static final class SupplierMemoBox<T> {
        private Supplier<T> supplier;
        private T value;

        @Generated
        public SupplierMemoBox(Supplier<T> supplier, T value) {
            this.supplier = supplier;
            this.value = value;
        }
    }
}

