/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import de.scravy.bedrock.Box;
import de.scravy.bedrock.Pair;
import de.scravy.bedrock.Seq;
import de.scravy.bedrock.SeqBuilder;
import de.scravy.bedrock.SimpleDirectedGraph;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class DirectedGraph<V>
extends SimpleDirectedGraph {
    private final Object[] vertices;
    private final Map<V, Integer> verticesToIndicesMap;

    private DirectedGraph(Object[] vertices, Map<V, Integer> verticesToIndicesMap, int numberOfEdges, int[][] outgoingEdges) {
        super(vertices.length, numberOfEdges, outgoingEdges, null);
        this.vertices = vertices;
        this.verticesToIndicesMap = verticesToIndicesMap;
    }

    @Nonnull
    public V vertex(int index) {
        return (V)this.vertices[index];
    }

    public int index(@Nonnull V vertex) {
        return this.verticesToIndicesMap.getOrDefault(vertex, -1);
    }

    public Seq<V> vertices() {
        return Seq.ofArrayZeroCopyInternal(this.vertices);
    }

    public void forEachOutgoingEdge(@Nonnull V vertex, @Nonnull Consumer<V> consumer) {
        int index = this.verticesToIndicesMap.get(vertex);
        this.forEachOutgoing(index, to -> consumer.accept(this.vertices[to]));
    }

    @Nonnegative
    public int countOutgoingEdges(@Nonnull V vertex) {
        return this.countOutgoing(this.verticesToIndicesMap.get(vertex));
    }

    public boolean hasOutgoingEdges(@Nonnull V vertex) {
        return this.countOutgoingEdges(vertex) > 0;
    }

    public void forEachIncomingEdge(@Nonnull V vertex, @Nonnull Consumer<V> consumer) {
        int index = this.verticesToIndicesMap.get(vertex);
        this.forEachIncoming(index, from -> consumer.accept(this.vertices[from]));
    }

    @Nonnegative
    public int countIncomingEdges(@Nonnull V vertex) {
        return this.countIncoming(this.verticesToIndicesMap.get(vertex));
    }

    public boolean hasIncomingEdges(@Nonnull V vertex) {
        return this.countIncomingEdges(vertex) > 0;
    }

    public Seq<Pair<V, V>> edges() {
        SeqBuilder edgesBuilder = Seq.builder(this.numberOfEdges);
        this.vertices().forEach(v -> this.forEachOutgoingEdge(v, v2 -> edgesBuilder.add(Pair.pair(v, v2))));
        return edgesBuilder.result();
    }

    @Nonnull
    public static <V> DirectedGraph<V> fromEdges(@Nonnull Seq<Pair<V, V>> edges) {
        Objects.requireNonNull(edges, "'edges' must not be null.");
        HashMap<Object, Integer> verticesToIndicesMap = new HashMap<Object, Integer>();
        HashMap<Integer, TreeSet> outgoingEdgesMap = new HashMap<Integer, TreeSet>();
        Box.IntBox index = Box.intBox(0);
        ToIntFunction<Object> add = vertex -> {
            int ix;
            Integer ixMaybe = (Integer)verticesToIndicesMap.get(vertex);
            if (ixMaybe == null) {
                ix = index.getValue();
                outgoingEdgesMap.put(ix, new TreeSet());
                verticesToIndicesMap.put(vertex, ix);
                index.inc();
            } else {
                ix = ixMaybe;
            }
            return ix;
        };
        edges.forEach(edge -> {
            int from = add.applyAsInt(edge.fst());
            int to = add.applyAsInt(edge.snd());
            ((TreeSet)outgoingEdgesMap.get(from)).add(to);
        });
        int numberOfVertices = index.getValue();
        Object[] vertices = new Object[numberOfVertices];
        verticesToIndicesMap.forEach((vertex, ix) -> {
            vertices[ix.intValue()] = vertex;
        });
        int[][] outgoingEdges = new int[numberOfVertices][];
        Box.IntBox numberOfEdges = Box.intBox(0);
        outgoingEdgesMap.forEach((from, tos) -> {
            int[] out = new int[tos.size()];
            int i = 0;
            Iterator iterator = ((TreeSet)outgoingEdgesMap.get(from)).iterator();
            while (iterator.hasNext()) {
                int to = (Integer)iterator.next();
                out[i++] = to;
            }
            numberOfEdges.add(i);
            outgoingEdges[from.intValue()] = out;
        });
        return new DirectedGraph(vertices, verticesToIndicesMap, numberOfEdges.getValue(), (int[][])outgoingEdges);
    }
}

