/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import java.io.Serializable;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import lombok.Generated;

@Immutable
public abstract class Either<L, R>
implements Serializable,
Comparable<Either<L, R>> {
    public abstract Object getValue();

    public abstract <L2> Either<L2, R> mapLeft(Function<L, L2> var1);

    public abstract <R2> Either<L, R2> mapRight(Function<R, R2> var1);

    public abstract void forEachLeft(Consumer<L> var1);

    public abstract void forEachRight(Consumer<R> var1);

    public abstract boolean isLeft();

    public abstract boolean isRight();

    public abstract Optional<Left<L, R>> getLeft();

    public abstract Optional<Right<L, R>> getRight();

    public abstract Optional<L> getLeftValue();

    public abstract Optional<R> getRightValue();

    public abstract <T> T fold(Function<L, T> var1, Function<R, T> var2);

    public static <L, R> Either<L, R> left(L value) {
        return new Left(value);
    }

    public static <L, R> Either<L, R> right(R value) {
        return new Right(value);
    }

    @Generated
    Either() {
    }

    @Immutable
    public static final class Left<L, R>
    extends Either<L, R> {
        private final L value;

        @Override
        public int compareTo(@Nonnull Either<L, R> other) {
            if (other instanceof Right) {
                return -1;
            }
            return ((Comparable)this.value).compareTo(((Left)other).value);
        }

        @Override
        public <L2> Either<L2, R> mapLeft(Function<L, L2> f) {
            return new Left<L2, R>(f.apply(this.value));
        }

        @Override
        public <R2> Either<L, R2> mapRight(Function<R, R2> f) {
            return this;
        }

        @Override
        public void forEachLeft(Consumer<L> f) {
            f.accept(this.value);
        }

        @Override
        public void forEachRight(Consumer<R> f) {
        }

        @Override
        public boolean isLeft() {
            return true;
        }

        @Override
        public boolean isRight() {
            return false;
        }

        @Override
        public Optional<Left<L, R>> getLeft() {
            return Optional.of(this);
        }

        @Override
        public Optional<Right<L, R>> getRight() {
            return Optional.empty();
        }

        @Override
        public Optional<L> getLeftValue() {
            return Optional.of(this.value);
        }

        @Override
        public Optional<R> getRightValue() {
            return Optional.empty();
        }

        @Override
        public <T> T fold(Function<L, T> f, Function<R, T> g) {
            return f.apply(this.value);
        }

        @Generated
        public Left(L value) {
            this.value = value;
        }

        @Override
        @Generated
        public L getValue() {
            return this.value;
        }

        @Generated
        public String toString() {
            return "Either.Left(value=" + this.getValue() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Left)) {
                return false;
            }
            Left other = (Left)o;
            if (!other.canEqual(this)) {
                return false;
            }
            L this$value = this.getValue();
            L other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Left;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            L $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }
    }

    @Immutable
    public static final class Right<L, R>
    extends Either<L, R> {
        private final R value;

        @Override
        public int compareTo(@Nonnull Either<L, R> other) {
            if (other instanceof Left) {
                return 1;
            }
            return ((Comparable)this.value).compareTo(((Right)other).value);
        }

        @Override
        public <L2> Either<L2, R> mapLeft(Function<L, L2> f) {
            return this;
        }

        @Override
        public <R2> Either<L, R2> mapRight(Function<R, R2> f) {
            return new Right<L, R2>(f.apply(this.value));
        }

        @Override
        public void forEachLeft(Consumer<L> f) {
        }

        @Override
        public void forEachRight(Consumer<R> f) {
            f.accept(this.value);
        }

        @Override
        public boolean isLeft() {
            return false;
        }

        @Override
        public boolean isRight() {
            return true;
        }

        @Override
        public Optional<Left<L, R>> getLeft() {
            return Optional.empty();
        }

        @Override
        public Optional<Right<L, R>> getRight() {
            return Optional.of(this);
        }

        @Override
        public Optional<L> getLeftValue() {
            return Optional.empty();
        }

        @Override
        public Optional<R> getRightValue() {
            return Optional.of(this.value);
        }

        @Override
        public <T> T fold(Function<L, T> f, Function<R, T> g) {
            return g.apply(this.value);
        }

        @Generated
        public Right(R value) {
            this.value = value;
        }

        @Override
        @Generated
        public R getValue() {
            return this.value;
        }

        @Generated
        public String toString() {
            return "Either.Right(value=" + this.getValue() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Right)) {
                return false;
            }
            Right other = (Right)o;
            if (!other.canEqual(this)) {
                return false;
            }
            R this$value = this.getValue();
            R other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Right;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            R $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }
    }
}

