/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import de.scravy.bedrock.Reflections;
import de.scravy.bedrock.Set;
import de.scravy.bedrock.Strings;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public final class EnvironmentVariables {
    private static Function<String, String> defaultEnvironmentVariableRetriever = System::getenv;

    public static Function<String, String> setDefaultEnvironmentVariableRetriever(@Nonnull Function<String, String> retriever) {
        Objects.requireNonNull(retriever, "'retriever' must not be null");
        Function<String, String> oldRetriever = defaultEnvironmentVariableRetriever;
        defaultEnvironmentVariableRetriever = retriever;
        return oldRetriever;
    }

    @Nonnull
    public static Optional<String> getenv(@Nullable Function<String, String> retriever, @Nonnull String key) {
        Objects.requireNonNull(key, "'key' must not be null");
        return Optional.ofNullable(Optional.ofNullable(retriever).orElse(defaultEnvironmentVariableRetriever).apply(key));
    }

    public static <T> T read(@Nonnull Class<T> clazz) {
        return EnvironmentVariables.read(null, clazz);
    }

    public static <T> T read(@Nullable Function<String, String> retriever, @Nonnull Class<T> clazz) {
        try {
            T instance = clazz.newInstance();
            EnvironmentVariables.readInto(retriever, instance);
            return instance;
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }

    public static <T> void readInto(@Nonnull T instance) {
        EnvironmentVariables.readInto(null, instance);
    }

    public static <T> void readInto(@Nullable Function<String, String> retriever, @Nonnull T instance) {
        Objects.requireNonNull(instance);
        Set<Reflections.Property<?>> properties = Reflections.getProperties(instance.getClass());
        properties.forEach(property -> {
            if (property.getSetter() == null) {
                return;
            }
            String environmentVariableName = Strings.toUpperSnakeCase(property.getName());
            EnvironmentVariables.getenv(retriever, environmentVariableName).ifPresent(value -> property.set(instance, value));
        });
    }

    @Generated
    private EnvironmentVariables() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

