/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import de.scravy.bedrock.Hash;
import de.scravy.bedrock.Mapping;
import de.scravy.bedrock.Obj;
import de.scravy.bedrock.Reflections;
import de.scravy.bedrock.Set;
import de.scravy.bedrock.Tuple2;
import de.scravy.bedrock.Tuple3;
import de.scravy.bedrock.Tuple4;
import java.lang.ref.Reference;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public class HashAlgorithm<H extends Hash<H>> {
    private final int length;
    @Nonnull
    private final String algorithm;
    @Nonnull
    private final Function<byte[], H> constructor;
    @Nonnull
    private final Function<MessageDigest, byte[]> finisher;
    private H merkleNodeMarker = null;

    public H empty() {
        return (H)((Hash)this.constructor.apply(this.finisher.apply(this.getMessageDigest())));
    }

    public H zeroed() {
        return (H)((Hash)this.constructor.apply(new byte[this.length]));
    }

    public Builder builder() {
        return new Builder();
    }

    @Nonnull
    private MessageDigest getMessageDigest() {
        try {
            return MessageDigest.getInstance(this.algorithm);
        }
        catch (NoSuchAlgorithmException exc) {
            throw new AssertionError("Your JVM/JRE does not support " + this.algorithm, exc);
        }
    }

    @Nonnull
    public H hashString(@Nonnull String string) {
        Objects.requireNonNull(string, "'string' must not be null");
        byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
        return this.hashBytes(bytes);
    }

    @Nonnull
    public H hashBytes(@Nonnull byte[] bytes) {
        Objects.requireNonNull(bytes, "'bytes' must not be null");
        MessageDigest md = this.getMessageDigest();
        byte[] digest = md.digest(bytes);
        return (H)((Hash)this.constructor.apply(digest));
    }

    @Nonnull
    public H hashRawByte(byte value) {
        return this.hashBytes(new byte[]{value});
    }

    @Nonnull
    public H hashRawShort(short number) {
        return this.hashBytes(ByteBuffer.wrap(new byte[2]).putShort(number).array());
    }

    @Nonnull
    public H hashRawInt(int number) {
        return this.hashBytes(ByteBuffer.wrap(new byte[4]).putInt(number).array());
    }

    @Nonnull
    public H hashRawLong(long number) {
        return this.hashBytes(ByteBuffer.wrap(new byte[8]).putLong(number).array());
    }

    @Nonnull
    public H hashRawFloat(float number) {
        return this.hashBytes(ByteBuffer.wrap(new byte[4]).putFloat(number).array());
    }

    @Nonnull
    public H hashRawDouble(double number) {
        return this.hashBytes(ByteBuffer.wrap(new byte[8]).putDouble(number).array());
    }

    @Nonnull
    public H hashRawChar(char character) {
        return this.hashBytes(ByteBuffer.wrap(new byte[2]).putChar(character).array());
    }

    @Nonnull
    public H hashByte(byte value) {
        return this.hashBigDecimal(BigDecimal.valueOf(value));
    }

    @Nonnull
    public H hashShort(short value) {
        return this.hashBigDecimal(BigDecimal.valueOf(value));
    }

    @Nonnull
    public H hashInt(int value) {
        return this.hashBigDecimal(BigDecimal.valueOf(value));
    }

    @Nonnull
    public H hashLong(long value) {
        return this.hashBigDecimal(BigDecimal.valueOf(value));
    }

    @Nonnull
    public H hashChar(char value) {
        return this.hashBigDecimal(BigDecimal.valueOf(value));
    }

    @Nonnull
    public H hashFloat(float value) {
        if (value == Float.POSITIVE_INFINITY) {
            return this.hashString("+Inf");
        }
        if (value == Float.NEGATIVE_INFINITY) {
            return this.hashString("-Inf");
        }
        if (Float.isNaN(value)) {
            return this.hashString("NaN");
        }
        return this.hashBigDecimal(BigDecimal.valueOf(value));
    }

    @Nonnull
    public H hashDouble(double value) {
        if (value == Double.POSITIVE_INFINITY) {
            return this.hashString("+Inf");
        }
        if (value == Double.NEGATIVE_INFINITY) {
            return this.hashString("-Inf");
        }
        if (Double.isNaN(value)) {
            return this.hashString("NaN");
        }
        return this.hashBigDecimal(BigDecimal.valueOf(value));
    }

    @Nonnull
    public H hashBigDecimal(@Nullable BigDecimal value) {
        if (value == null) {
            return this.zeroed();
        }
        return this.hashString(value.toPlainString().replaceAll("\\.0$", ""));
    }

    @Nonnull
    public H hashBigInteger(@Nullable BigInteger value) {
        if (value == null) {
            return this.zeroed();
        }
        return this.hashBigDecimal(new BigDecimal(value));
    }

    @Nonnull
    public H hashSequence(@Nullable Iterable<?> seq) {
        if (seq == null) {
            return this.zeroed();
        }
        ArrayList hashes = seq instanceof Collection ? new ArrayList(((Collection)seq).size()) : new ArrayList();
        seq.forEach(obj -> hashes.add(this.hashObject(obj)));
        return (H)this.merkleTree(hashes);
    }

    @Nonnull
    public H hashUnorderedCollection(@Nullable Iterable<?> seq) {
        if (seq == null) {
            return this.zeroed();
        }
        ArrayList hashes = new ArrayList();
        seq.forEach(obj -> hashes.add(this.hashObject(obj)));
        Collections.sort(hashes);
        return (H)this.merkleTree(hashes);
    }

    @Nonnull
    public H hashTreeMap(@Nullable TreeMap<?, ?> ts) {
        if (ts == null) {
            return this.zeroed();
        }
        ArrayList hashes = new ArrayList(ts.size());
        ts.forEach((keyHash, valueHash) -> hashes.add(this.hash(keyHash, valueHash)));
        return (H)this.merkleTree(hashes);
    }

    @Nonnull
    public H hashMap(@Nullable Mapping<?, ?> map) {
        if (map == null) {
            return this.zeroed();
        }
        TreeMap ts = new TreeMap();
        map.forEach((key, obj) -> ts.put(this.hashObject(key), this.hashObject(obj)));
        return this.hashTreeMap(ts);
    }

    @Nonnull
    public <T> H hashPojo(@Nullable T obj) {
        if (obj == null) {
            return this.zeroed();
        }
        TreeMap ts = new TreeMap();
        Reflections.getProperties(Obj.getClass(obj)).forEach(property -> {
            if (!property.getName().equals("class")) {
                String key = property.getName();
                H keyHash = this.hashString(key);
                H valueHash = this.hashObject(property.get(obj));
                ts.put(keyHash, valueHash);
            }
        });
        return this.hashTreeMap(ts);
    }

    public H hash(Object ... objects) {
        ArrayList hashes = new ArrayList(objects.length);
        Arrays.stream(objects).forEach(obj -> hashes.add(this.hashObject(obj)));
        return (H)this.merkleTree(hashes);
    }

    private boolean isUnorderedCollection(Object obj) {
        return obj instanceof java.util.Set && !(obj instanceof LinkedHashSet) || obj instanceof Set;
    }

    @Nonnull
    public H hashObject(Object obj) {
        if (obj == null) {
            return this.zeroed();
        }
        if (obj instanceof String) {
            return this.hashString((String)obj);
        }
        if (obj instanceof Object[]) {
            return this.hash((Object[])obj);
        }
        if (obj instanceof Hash) {
            return this.hashBytes(((Hash)obj).getBytes());
        }
        if (obj instanceof byte[]) {
            return this.hashBytes((byte[])obj);
        }
        if (obj instanceof Byte) {
            return this.hashByte((Byte)obj);
        }
        if (obj instanceof Short) {
            return this.hashShort((Short)obj);
        }
        if (obj instanceof Integer) {
            return this.hashInt((Integer)obj);
        }
        if (obj instanceof Long) {
            return this.hashLong((Long)obj);
        }
        if (obj instanceof Float) {
            return this.hashFloat(((Float)obj).floatValue());
        }
        if (obj instanceof Double) {
            return this.hashDouble((Double)obj);
        }
        if (obj instanceof BigDecimal) {
            return this.hashBigDecimal((BigDecimal)obj);
        }
        if (obj instanceof BigInteger) {
            return this.hashBigInteger((BigInteger)obj);
        }
        if (obj instanceof Character) {
            return this.hashChar(((Character)obj).charValue());
        }
        if (obj instanceof Tuple4) {
            return this.hash(((Tuple4)obj).getFirst(), ((Tuple4)obj).getSecond(), ((Tuple4)obj).getThird(), ((Tuple4)obj).getFourth());
        }
        if (obj instanceof Tuple3) {
            return this.hash(((Tuple3)obj).getFirst(), ((Tuple3)obj).getSecond(), ((Tuple3)obj).getThird());
        }
        if (obj instanceof Tuple2) {
            return this.hash(((Tuple2)obj).getFirst(), ((Tuple2)obj).getSecond());
        }
        if (obj instanceof Map.Entry) {
            return this.hash(((Map.Entry)obj).getKey(), ((Map.Entry)obj).getValue());
        }
        if (obj instanceof Mapping) {
            return this.hashMap((Mapping)obj);
        }
        if (obj instanceof Map) {
            return this.hashMap(Mapping.wrap((Map)obj));
        }
        if (this.isUnorderedCollection(obj)) {
            return this.hashUnorderedCollection((Iterable)obj);
        }
        if (obj instanceof Iterable) {
            return this.hashSequence((Iterable)obj);
        }
        if (obj instanceof Reference) {
            return this.hashObject(((Reference)obj).get());
        }
        if (obj instanceof ThreadLocal) {
            return this.hashObject(((ThreadLocal)obj).get());
        }
        return this.hashPojo(obj);
    }

    public H merkleTree(@Nonnull Collection<H> collection) {
        if (collection.isEmpty()) {
            return this.empty();
        }
        Collection<H> items = collection;
        while (items.size() > 1) {
            ArrayList<H> nextItems = new ArrayList<H>(items.size() / 2);
            Iterator<H> it = items.iterator();
            while (it.hasNext()) {
                Hash nodeHash;
                Hash hashLeft = (Hash)it.next();
                if (it.hasNext()) {
                    Hash hashRight = (Hash)it.next();
                    Builder builder = this.builder().addHash(hashLeft).addHash(hashRight);
                    if (this.merkleNodeMarker != null) {
                        builder.addHash(this.merkleNodeMarker);
                    }
                    nodeHash = builder.build();
                } else {
                    nodeHash = hashLeft;
                }
                nextItems.add(nodeHash);
            }
            items = nextItems;
        }
        return (H)((Hash)items.iterator().next());
    }

    @Generated
    HashAlgorithm(int length, @Nonnull String algorithm, @Nonnull Function<byte[], H> constructor, @Nonnull Function<MessageDigest, byte[]> finisher) {
        if (algorithm == null) {
            throw new NullPointerException("algorithm is marked non-null but is null");
        }
        if (constructor == null) {
            throw new NullPointerException("constructor is marked non-null but is null");
        }
        if (finisher == null) {
            throw new NullPointerException("finisher is marked non-null but is null");
        }
        this.length = length;
        this.algorithm = algorithm;
        this.constructor = constructor;
        this.finisher = finisher;
    }

    @Generated
    public void setMerkleNodeMarker(H merkleNodeMarker) {
        this.merkleNodeMarker = merkleNodeMarker;
    }

    public class Builder {
        private final MessageDigest md;

        @Nonnull
        final Builder addHash(@Nonnull H hash) {
            return this.addBytes(hash.getBytes());
        }

        @Nonnull
        final Builder addBytes(@Nonnull byte[] bytes) {
            this.md.update(bytes);
            return this;
        }

        @Nonnull
        public final H build() {
            return (Hash)HashAlgorithm.this.constructor.apply(this.md.digest());
        }

        @Generated
        private Builder() {
            this.md = HashAlgorithm.this.getMessageDigest();
        }
    }
}

