/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import de.scravy.bedrock.Function1;
import de.scravy.bedrock.NoOp;
import de.scravy.bedrock.Seq;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public class MultiValuedKeyMap<T>
implements Function1<Seq<Object>, T> {
    private final Node<T> rootNode;

    public <K> Optional<T> get(Seq<K> key) {
        return Optional.ofNullable(MultiValuedKeyMap.find(this.rootNode, key, null));
    }

    public <K> T get(Seq<K> key, T fallback) {
        return this.get(key, fallback, null);
    }

    public <K> T get(Seq<K> key, Supplier<T> fallbackSupplier) {
        return this.get(key, fallbackSupplier, (List<Object>)null);
    }

    public <K> T get(Seq<K> key, @Nullable T fallback, List<Object> trace) {
        T result = MultiValuedKeyMap.find(this.rootNode, key, trace);
        if (result == null) {
            return fallback;
        }
        return result;
    }

    public <K> T get(Seq<K> key, @Nonnull Supplier<T> fallbackSupplier, List<Object> trace) {
        Objects.requireNonNull(fallbackSupplier);
        T result = MultiValuedKeyMap.find(this.rootNode, key, trace);
        if (result == null) {
            return fallbackSupplier.get();
        }
        return result;
    }

    @Override
    public T apply(Seq<Object> key) {
        return MultiValuedKeyMap.find(this.rootNode, key, null);
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    private static <T> T find(Node<T> node, Seq<Object> key, @Nullable List<Object> trace) {
        Node currentNode = node;
        Consumer<Object> tracer = trace == null ? NoOp.consumer() : trace::add;
        for (int i = 0; i < key.length(); ++i) {
            Node nextNode;
            if (trace != null) {
                trace.add(key.get(i));
            }
            if (currentNode.keys == null) {
                if (currentNode.fallback == null) break;
                tracer.accept(null);
                nextNode = currentNode.fallback;
            } else {
                int ix;
                Object k = key.get(i);
                int n = ix = k == null ? -1 : Arrays.binarySearch(currentNode.keys, k);
                if (ix >= 0) {
                    tracer.accept(k);
                    nextNode = currentNode.children[ix];
                } else {
                    tracer.accept(null);
                    nextNode = currentNode.fallback;
                }
                if (nextNode == null) break;
            }
            currentNode = nextNode;
        }
        return (T)currentNode.value;
    }

    @Generated
    private MultiValuedKeyMap(Node<T> rootNode) {
        this.rootNode = rootNode;
    }

    private static final class Node<T> {
        private final T value;
        private final Node<T> fallback;
        private final Object[] keys;
        private final Node<T>[] children;

        @Generated
        public Node(T value, Node<T> fallback, Object[] keys, Node<T>[] children) {
            this.value = value;
            this.fallback = fallback;
            this.keys = keys;
            this.children = children;
        }

        @Generated
        public T getValue() {
            return this.value;
        }

        @Generated
        public Node<T> getFallback() {
            return this.fallback;
        }

        @Generated
        public Object[] getKeys() {
            return this.keys;
        }

        @Generated
        public Node<T>[] getChildren() {
            return this.children;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Node)) {
                return false;
            }
            Node other = (Node)o;
            T this$value = this.getValue();
            T other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            Node<T> this$fallback = this.getFallback();
            Node<T> other$fallback = other.getFallback();
            if (this$fallback == null ? other$fallback != null : !((Object)this$fallback).equals(other$fallback)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getKeys(), other.getKeys())) {
                return false;
            }
            return Arrays.deepEquals(this.getChildren(), other.getChildren());
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            T $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            Node<T> $fallback = this.getFallback();
            result = result * 59 + ($fallback == null ? 43 : ((Object)$fallback).hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getKeys());
            result = result * 59 + Arrays.deepHashCode(this.getChildren());
            return result;
        }

        @Generated
        public String toString() {
            return "MultiValuedKeyMap.Node(value=" + this.getValue() + ", fallback=" + this.getFallback() + ", keys=" + Arrays.deepToString(this.getKeys()) + ", children=" + Arrays.deepToString(this.getChildren()) + ")";
        }
    }

    public static class Builder<T> {
        private BuilderNode<T> root = new BuilderNode();

        public <K> Builder<T> add(Seq<K> key, T value) {
            Builder.add(this.root, value, key);
            return this;
        }

        public MultiValuedKeyMap<T> build() {
            return new MultiValuedKeyMap(Builder.build(this.root));
        }

        private static <T> void add(BuilderNode<T> node, T value, Seq<Object> key) {
            if (key.isEmpty()) {
                node.value = value;
            } else if (key.head() == null) {
                if (node.fallback == null) {
                    node.fallback = new BuilderNode();
                }
                Builder.add(node.fallback, value, (Seq)key.tail());
            } else {
                BuilderNode child;
                if (node.children == null) {
                    node.children = new TreeMap();
                }
                if ((child = node.children.get(key.head())) == null) {
                    child = new BuilderNode();
                    node.children.put(key.head(), child);
                }
                Builder.add(child, value, (Seq)key.tail());
            }
        }

        private static <T> Node<T> build(BuilderNode<T> node) {
            Node[] children;
            Object[] keys;
            if (node == null) {
                return null;
            }
            if (node.children != null) {
                keys = node.children.keySet().toArray();
                children = Seq.of(keys).map(key -> Builder.build(node.children.get(key))).toArray(Node.class);
            } else {
                keys = null;
                children = null;
            }
            return new Node(node.value, Builder.build(node.fallback), keys, children);
        }
    }

    private static class BuilderNode<T> {
        T value = null;
        BuilderNode<T> fallback = null;
        TreeMap<Object, BuilderNode<T>> children = new TreeMap();

        private BuilderNode() {
        }
    }
}

