/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import de.scravy.bedrock.Seq;
import de.scravy.bedrock.Tuple2;
import de.scravy.bedrock.hlist.C;
import de.scravy.bedrock.hlist.HList;
import de.scravy.bedrock.hlist.Nil;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import lombok.Generated;

@Immutable
public final class Pair<A, B>
implements Map.Entry<A, B>,
Serializable,
Comparable<Pair<A, B>>,
Tuple2<A, B> {
    private final A first;
    private final B second;

    public A fst() {
        return this.first;
    }

    public B snd() {
        return this.second;
    }

    @Override
    public A getKey() {
        return this.first;
    }

    @Override
    public B getValue() {
        return this.second;
    }

    @Override
    public B setValue(B value) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int compareTo(@Nonnull Pair<A, B> p) {
        int r;
        if (this.first == null) {
            if (p.first != null) return -1;
            r = 0;
        } else {
            if (p.first == null) {
                return 1;
            }
            r = ((Comparable)this.first).compareTo(p.first);
        }
        if (r != 0) {
            return r;
        }
        if (this.second == null) {
            if (p.second != null) return -1;
            return 0;
        }
        if (p.second != null) return ((Comparable)this.second).compareTo(p.second);
        return 1;
    }

    @Nonnull
    public static <A, B> Pair<A, B> pair(A a, B b) {
        return new Pair<A, B>(a, b);
    }

    @Nonnull
    public static <A, B> Pair<A, B> of(A a, B b) {
        return new Pair<A, B>(a, b);
    }

    @Nonnull
    public static <A, B> Pair<A, B> of(Map.Entry<A, B> entry) {
        if (entry instanceof Pair) {
            return (Pair)entry;
        }
        return new Pair<A, B>(entry.getKey(), entry.getValue());
    }

    @Nonnull
    public static <C, A extends C, B extends C> List<C> toList(final @Nonnull Tuple2<A, B> pair) {
        return new AbstractList<C>(){

            @Override
            public C get(int index) {
                switch (index) {
                    case 0: {
                        return pair.getFirst();
                    }
                    case 1: {
                        return pair.getSecond();
                    }
                }
                throw new IndexOutOfBoundsException(Integer.toString(index));
            }

            @Override
            public int size() {
                return 2;
            }
        };
    }

    @Nonnull
    public Pair<B, A> swapped() {
        return Pair.of(this.getSecond(), this.getFirst());
    }

    @Nonnull
    public C<A, C<B, Nil>> toHList() {
        return this.toHList2();
    }

    public static <A, B, L extends HList<L>> Pair<A, B> fromHList(C<A, C<B, L>> hlist) {
        return Pair.pair(hlist.getHead(), hlist.getTail().getHead());
    }

    @Nonnull
    public static <C, A extends C, B extends C> Seq<C> toSeq(Tuple2<A, B> pair) {
        return Tuple2.toSeq(pair);
    }

    @Nonnull
    public <C, D> Pair<C, D> map(Function<A, C> f, Function<B, D> g) {
        return Pair.of(f.apply(this.fst()), g.apply(this.snd()));
    }

    @Nonnull
    public <C> Pair<C, B> mapFirst(Function<A, C> f) {
        return Pair.of(f.apply(this.fst()), this.snd());
    }

    @Nonnull
    public <C> Pair<A, C> mapSecond(Function<B, C> f) {
        return Pair.of(this.fst(), f.apply(this.snd()));
    }

    @Nonnull
    public <C> Pair<C, B> withFirst(C v) {
        return Pair.of(v, this.snd());
    }

    @Nonnull
    public <C> Pair<A, C> withSecond(C v) {
        return Pair.of(this.fst(), v);
    }

    @Generated
    public Pair(A first, B second) {
        this.first = first;
        this.second = second;
    }

    @Override
    @Generated
    public A getFirst() {
        return this.first;
    }

    @Override
    @Generated
    public B getSecond() {
        return this.second;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pair)) {
            return false;
        }
        Pair other = (Pair)o;
        A this$first = this.getFirst();
        A other$first = other.getFirst();
        if (this$first == null ? other$first != null : !this$first.equals(other$first)) {
            return false;
        }
        B this$second = this.getSecond();
        B other$second = other.getSecond();
        return !(this$second == null ? other$second != null : !this$second.equals(other$second));
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        A $first = this.getFirst();
        result = result * 59 + ($first == null ? 43 : $first.hashCode());
        B $second = this.getSecond();
        result = result * 59 + ($second == null ? 43 : $second.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Pair(first=" + this.getFirst() + ", second=" + this.getSecond() + ")";
    }
}

