/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import de.scravy.bedrock.AsyncExecutionException;
import de.scravy.bedrock.Callback;
import de.scravy.bedrock.ThrowingConsumer;
import de.scravy.bedrock.ThrowingFunction;
import de.scravy.bedrock.Try;
import de.scravy.bedrock.ValueDidNotSatisfyPredicateException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import lombok.Generated;

public class Promise<T>
implements Callback<T> {
    @Nonnull
    private volatile State state;
    private volatile Object result;
    private final Deque<UntypedPromise> children = new ArrayDeque<UntypedPromise>(1);

    private Promise(@Nonnull State state, Object result) {
        this.state = state;
        this.result = result;
    }

    @Nonnull
    public static <T> Promise<T> promise() {
        return new Promise<T>(State.PENDING, null);
    }

    @Nonnull
    public static <T> Promise<T> fulfilled(T value) {
        return new FulfilledPromise(value);
    }

    @Nonnull
    public static <T> Promise<T> failed(Throwable value) {
        return new FailedPromise(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fulfill(T result) {
        Deque<UntypedPromise> deque = this.children;
        synchronized (deque) {
            if (this.state != State.PENDING) {
                throw new IllegalStateException("Already fulfilled (" + (Object)((Object)this.state) + ").");
            }
            this.result = result;
            this.state = State.FULFILLED;
            while (!this.children.isEmpty()) {
                UntypedPromise child = this.children.pop();
                try {
                    child.fulfill(result);
                }
                catch (Exception exc) {
                    Try.unfailable(() -> child.fail(exc));
                }
            }
            this.children.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fail(Throwable exc) {
        Deque<UntypedPromise> deque = this.children;
        synchronized (deque) {
            if (this.state != State.PENDING) {
                throw new IllegalStateException("Already fulfilled (" + (Object)((Object)this.state) + ").");
            }
            this.result = exc;
            this.state = State.FAILED;
            while (!this.children.isEmpty()) {
                UntypedPromise child = this.children.pop();
                Try.unfailable(() -> child.fail(exc));
            }
            this.children.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() throws AsyncExecutionException {
        while (true) {
            Deque<UntypedPromise> deque = this.children;
            synchronized (deque) {
                switch (this.state) {
                    case PENDING: {
                        try {
                            this.children.wait();
                            break;
                        }
                        catch (InterruptedException exc) {
                            throw new AsyncExecutionException((Object)exc);
                        }
                    }
                    case FULFILLED: {
                        return (T)this.result;
                    }
                    case FAILED: {
                        throw new AsyncExecutionException(this.result);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitFor() {
        while (true) {
            Deque<UntypedPromise> deque = this.children;
            synchronized (deque) {
                switch (this.state) {
                    case PENDING: {
                        try {
                            this.children.wait();
                            break;
                        }
                        catch (InterruptedException exc) {
                            throw new AsyncExecutionException((Object)exc);
                        }
                    }
                    case FULFILLED: 
                    case FAILED: {
                        return;
                    }
                }
            }
        }
    }

    public Throwable getException() {
        if (this.state == State.FAILED) {
            return (Throwable)this.result;
        }
        return null;
    }

    public T getValue() {
        if (this.state == State.FULFILLED) {
            return (T)this.result;
        }
        return null;
    }

    public boolean isSuccess() {
        return this.state == State.FULFILLED;
    }

    public boolean isFailure() {
        return this.state == State.FAILED;
    }

    public boolean isPending() {
        return this.state == State.PENDING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public <U> Promise<U> map(@Nonnull ThrowingFunction<T, U> function) {
        Objects.requireNonNull(function, "'function' must not be null.");
        Deque<UntypedPromise> deque = this.children;
        synchronized (deque) {
            if (this.state == State.PENDING) {
                MappedPromise mappedPromise = new MappedPromise(function);
                this.children.push(mappedPromise);
                return mappedPromise;
            }
        }
        if (this.state == State.FULFILLED) {
            try {
                return Promise.fulfilled(function.execute(this.result));
            }
            catch (Exception exc) {
                return Promise.failed(exc);
            }
        }
        return Promise.failed((Throwable)this.result);
    }

    @Nonnull
    public Promise<T> filter(@Nonnull Predicate<T> predicate) {
        Objects.requireNonNull(predicate, "'predicate' must not be null.");
        return this.map(value -> {
            if (predicate.test(value)) {
                return value;
            }
            throw new ValueDidNotSatisfyPredicateException(predicate, value);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Promise<T> onComplete(@Nonnull Callback<T> callback) {
        Objects.requireNonNull(callback, "'callback' must not be null.");
        Deque<UntypedPromise> deque = this.children;
        synchronized (deque) {
            if (this.state == State.PENDING) {
                CallbackPromise callbackPromise = new CallbackPromise(callback);
                this.children.push(callbackPromise);
                return this;
            }
        }
        if (this.state == State.FULFILLED) {
            Try.unfailable(() -> callback.call(null, this.result));
        } else {
            Try.unfailable(() -> callback.call(this.result, null));
        }
        return this;
    }

    @Nonnull
    public Promise<T> onSuccess(@Nonnull ThrowingConsumer<T> consumer) {
        return this.onComplete((error, result) -> {
            if (error == null) {
                Try.unfailable(() -> consumer.accept((Object)result));
            }
        });
    }

    @Nonnull
    public Promise<T> onFailure(@Nonnull ThrowingConsumer<Throwable> consumer) {
        return this.onComplete((error, result) -> {
            if (error instanceof Throwable) {
                Try.unfailable(() -> consumer.accept((Throwable)error));
            }
        });
    }

    @Nonnull
    public final Optional<T> toOptional() {
        this.waitFor();
        if (this.isSuccess()) {
            return Optional.ofNullable(this.getValue());
        }
        return Optional.empty();
    }

    @Nonnull
    public final Try<T> toTry() {
        this.waitFor();
        if (this.isSuccess()) {
            return Try.success(this.getValue());
        }
        Throwable exception = this.getException();
        if (exception instanceof Exception) {
            return Try.failure((Exception)exception);
        }
        return Try.failure(new AsyncExecutionException((Object)exception));
    }

    @Override
    public final void call(Object error, T result) {
        if (error == null) {
            this.fulfill(result);
        } else if (error instanceof Throwable) {
            this.fail((Throwable)error);
        } else {
            this.fail(new AsyncExecutionException(error));
        }
    }

    @Nonnull
    @Generated
    public State getState() {
        return this.state;
    }

    public static enum State {
        PENDING,
        FULFILLED,
        FAILED;

    }

    private static class FulfilledPromise<T>
    extends Promise<T> {
        private FulfilledPromise(T result) {
            super(State.FULFILLED, result);
        }

        @Override
        public void fulfill(T result) {
            throw new IllegalStateException("Already fulfilled (" + (Object)((Object)this.getState()) + ").");
        }

        @Override
        public void fail(Throwable result) {
            throw new IllegalStateException("Already fulfilled (" + (Object)((Object)this.getState()) + ").");
        }

        @Override
        @Nonnull
        public Promise<T> onComplete(@Nonnull Callback<T> callback) {
            Try.unfailable(() -> callback.call(null, this.getValue()));
            return this;
        }
    }

    private static class FailedPromise<T>
    extends Promise<T> {
        private FailedPromise(Throwable exc) {
            super(State.FAILED, exc);
        }

        @Override
        public void fulfill(T result) {
            throw new IllegalStateException("Already fulfilled (" + (Object)((Object)this.getState()) + ").");
        }

        @Override
        public void fail(Throwable result) {
            throw new IllegalStateException("Already fulfilled (" + (Object)((Object)this.getState()) + ").");
        }

        @Override
        @Nonnull
        public Promise<T> onComplete(@Nonnull Callback<T> callback) {
            Try.unfailable(() -> callback.call(this.getException(), null));
            return this;
        }
    }

    private static abstract class UntypedPromise
    extends Promise<Object> {
        private UntypedPromise() {
            super(State.PENDING, null);
        }
    }

    private static class MappedPromise
    extends UntypedPromise {
        private ThrowingFunction transform;

        private MappedPromise(ThrowingFunction transform) {
            this.transform = transform;
        }

        @Override
        public void fulfill(Object result) {
            try {
                super.fulfill(this.transform.execute(result));
            }
            catch (Exception exc) {
                Try.unfailable(() -> super.fail(exc));
            }
            finally {
                this.transform = null;
            }
        }
    }

    private static class CallbackPromise
    extends UntypedPromise {
        private final Callback<Object> callback;

        private <T> CallbackPromise(Callback<T> callback) {
            this.callback = callback;
        }

        @Override
        public void fulfill(Object result) {
            Try.unfailable(() -> this.callback.call(null, result));
        }

        @Override
        public void fail(Throwable exc) {
            Try.unfailable(() -> this.callback.call(exc, null));
        }
    }
}

