/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import de.scravy.bedrock.Seq;
import de.scravy.bedrock.Tuple4;
import de.scravy.bedrock.hlist.C;
import de.scravy.bedrock.hlist.HList;
import de.scravy.bedrock.hlist.Nil;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import lombok.Generated;

@Immutable
public final class Quadruple<A, B, C, D>
implements Serializable,
Comparable<Quadruple<A, B, C, D>>,
Tuple4<A, B, C, D> {
    private final A first;
    private final B second;
    private final C third;
    private final D fourth;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int compareTo(@Nonnull Quadruple<A, B, C, D> tuple) {
        int r;
        if (this.first == null) {
            if (tuple.first != null) return -1;
            r = 0;
        } else {
            if (tuple.first == null) {
                return 1;
            }
            r = ((Comparable)this.first).compareTo(tuple.first);
        }
        if (r != 0) {
            return r;
        }
        if (this.second == null) {
            if (tuple.second != null) return -1;
            r = 0;
        } else {
            if (tuple.second == null) {
                return 1;
            }
            r = ((Comparable)this.second).compareTo(tuple.second);
        }
        if (r != 0) {
            return r;
        }
        if (this.third == null) {
            if (tuple.third != null) return -1;
            r = 0;
        } else {
            if (tuple.third == null) {
                return 1;
            }
            r = ((Comparable)this.third).compareTo(tuple.third);
        }
        if (r != 0) {
            return r;
        }
        if (this.fourth == null) {
            if (tuple.fourth != null) return -1;
            return 0;
        }
        if (tuple.fourth != null) return ((Comparable)this.fourth).compareTo(tuple.fourth);
        return 1;
    }

    @Nonnull
    public static <E, A extends E, B extends E, C extends E, D extends E> List<E> toList(final @Nonnull Tuple4<A, B, C, D> tuple) {
        Objects.requireNonNull(tuple, "'tuple' must not be null");
        return new AbstractList<E>(){

            @Override
            public E get(int index) {
                switch (index) {
                    case 0: {
                        return tuple.getFirst();
                    }
                    case 1: {
                        return tuple.getSecond();
                    }
                    case 2: {
                        return tuple.getThird();
                    }
                    case 3: {
                        return tuple.getFourth();
                    }
                }
                throw new IndexOutOfBoundsException(Integer.toString(index));
            }

            @Override
            public int size() {
                return 4;
            }
        };
    }

    @Nonnull
    public C<A, C<B, C<C, C<D, Nil>>>> toHList() {
        return this.toHList4();
    }

    @Nonnull
    public static <A, B, C, D, L extends HList<L>> Quadruple<A, B, C, D> fromHList(@Nonnull C<A, C<B, C<C, C<D, L>>>> hlist) {
        return Quadruple.quadruple(hlist.getHead(), hlist.getTail().getHead(), hlist.getTail().getTail().getHead(), hlist.getTail().getTail().getTail().getHead());
    }

    @Nonnull
    public static <E, A extends E, B extends E, C extends E, D extends E> Seq<E> toSeq(Tuple4<A, B, C, D> quadruple) {
        return Seq.of(quadruple.getFirst(), quadruple.getSecond(), quadruple.getThird(), quadruple.getFourth());
    }

    @Nonnull
    public <E, F, G, H> Quadruple<E, F, G, H> map(Function<A, E> f, Function<B, F> g, Function<C, G> h, Function<D, H> i) {
        return Quadruple.of(f.apply(this.getFirst()), g.apply(this.getSecond()), h.apply(this.getThird()), i.apply(this.getFourth()));
    }

    @Nonnull
    public <E> Quadruple<E, B, C, D> mapFirst(@Nonnull Function<A, E> f) {
        Objects.requireNonNull(f, "Function 'f' must not be null");
        return Quadruple.of(f.apply(this.getFirst()), this.getSecond(), this.getThird(), this.getFourth());
    }

    @Nonnull
    public <E> Quadruple<A, E, C, D> mapSecond(@Nonnull Function<B, E> f) {
        Objects.requireNonNull(f, "Function 'f' must not be null");
        return Quadruple.of(this.getFirst(), f.apply(this.getSecond()), this.getThird(), this.getFourth());
    }

    @Nonnull
    public <E> Quadruple<A, B, E, D> mapThird(@Nonnull Function<C, E> f) {
        Objects.requireNonNull(f, "Function 'f' must not be null");
        return Quadruple.of(this.getFirst(), this.getSecond(), f.apply(this.getThird()), this.getFourth());
    }

    @Nonnull
    public <E> Quadruple<A, B, C, E> mapFourth(@Nonnull Function<D, E> f) {
        Objects.requireNonNull(f, "Function 'f' must not be null");
        return Quadruple.of(this.getFirst(), this.getSecond(), this.getThird(), f.apply(this.getFourth()));
    }

    @Nonnull
    public <E> Quadruple<E, B, C, D> withFirst(E v) {
        return Quadruple.of(v, this.getSecond(), this.getThird(), this.getFourth());
    }

    @Nonnull
    public <E> Quadruple<A, E, C, D> withSecond(E v) {
        return Quadruple.of(this.getFirst(), v, this.getThird(), this.getFourth());
    }

    @Nonnull
    public <E> Quadruple<A, B, E, D> withThird(E v) {
        return Quadruple.of(this.getFirst(), this.getSecond(), v, this.getFourth());
    }

    @Nonnull
    public <E> Quadruple<A, B, C, E> withFourth(E v) {
        return Quadruple.of(this.getFirst(), this.getSecond(), this.getThird(), v);
    }

    public static <A, B, C, D> Quadruple<A, B, C, D> quadruple(A a, B b, C c, D d) {
        return Quadruple.of(a, b, c, d);
    }

    @Generated
    private Quadruple(A first, B second, C third, D fourth) {
        this.first = first;
        this.second = second;
        this.third = third;
        this.fourth = fourth;
    }

    @Generated
    public static <A, B, C, D> Quadruple<A, B, C, D> of(A first, B second, C third, D fourth) {
        return new Quadruple<A, B, C, D>(first, second, third, fourth);
    }

    @Override
    @Generated
    public A getFirst() {
        return this.first;
    }

    @Override
    @Generated
    public B getSecond() {
        return this.second;
    }

    @Override
    @Generated
    public C getThird() {
        return this.third;
    }

    @Override
    @Generated
    public D getFourth() {
        return this.fourth;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Quadruple)) {
            return false;
        }
        Quadruple other = (Quadruple)o;
        A this$first = this.getFirst();
        A other$first = other.getFirst();
        if (this$first == null ? other$first != null : !this$first.equals(other$first)) {
            return false;
        }
        B this$second = this.getSecond();
        B other$second = other.getSecond();
        if (this$second == null ? other$second != null : !this$second.equals(other$second)) {
            return false;
        }
        C this$third = this.getThird();
        C other$third = other.getThird();
        if (this$third == null ? other$third != null : !this$third.equals(other$third)) {
            return false;
        }
        D this$fourth = this.getFourth();
        D other$fourth = other.getFourth();
        return !(this$fourth == null ? other$fourth != null : !this$fourth.equals(other$fourth));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        A $first = this.getFirst();
        result = result * 59 + ($first == null ? 43 : $first.hashCode());
        B $second = this.getSecond();
        result = result * 59 + ($second == null ? 43 : $second.hashCode());
        C $third = this.getThird();
        result = result * 59 + ($third == null ? 43 : $third.hashCode());
        D $fourth = this.getFourth();
        result = result * 59 + ($fourth == null ? 43 : $fourth.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Quadruple(first=" + this.getFirst() + ", second=" + this.getSecond() + ", third=" + this.getThird() + ", fourth=" + this.getFourth() + ")";
    }
}

