/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import de.scravy.bedrock.AbstractBuilder;
import de.scravy.bedrock.Arithmetic;
import de.scravy.bedrock.ArrayMap;
import de.scravy.bedrock.Container;
import de.scravy.bedrock.Control;
import de.scravy.bedrock.Mapping;
import de.scravy.bedrock.Operators;
import de.scravy.bedrock.Pair;
import de.scravy.bedrock.PermutationIterator;
import de.scravy.bedrock.Quadruple;
import de.scravy.bedrock.SeqBuilder;
import de.scravy.bedrock.SeqEmpty;
import de.scravy.bedrock.SeqGenerated;
import de.scravy.bedrock.SeqSimple;
import de.scravy.bedrock.SeqSimpleSorted;
import de.scravy.bedrock.SequenceMethods;
import de.scravy.bedrock.Strings;
import de.scravy.bedrock.Triple;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.RandomAccess;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class Seq<E>
implements Serializable,
RandomAccess,
SequenceMethods<Predicate<? super E>, BiPredicate<? super E, ? super E>, Seq<E>>,
Container<E>,
IntFunction<E> {
    public static final long serialVersionUID = -2984177390254L;
    private int hashCode = 0;

    public abstract E get(@Nonnegative int var1);

    @Override
    public E apply(@Nonnegative int index) {
        return this.get(index);
    }

    @Override
    public boolean isEmpty() {
        return this.length() == 0;
    }

    @Override
    @Nonnull
    public Seq<E> shuffled(@Nonnull Random random) {
        Objects.requireNonNull(random, "the supplied 'random' generator must not be null");
        Object[] array = this.toArray();
        int len = array.length;
        for (int i = 0; i < len; ++i) {
            Control.swap(array, i, random.nextInt(len));
        }
        return new SeqSimple(array);
    }

    @Override
    public E draw(@Nonnull Random random) throws NoSuchElementException {
        Objects.requireNonNull(random, "the supplied 'random' generator must not be null");
        if (this.isEmpty()) {
            throw new NoSuchElementException("drawing from an empty set");
        }
        int ix = random.nextInt(this.size());
        return this.get(ix);
    }

    @Nonnull
    public abstract Seq<E> sortedBy(@Nonnull Comparator<? super E> var1);

    @Nonnull
    public <F extends Comparable<? super F>> Seq<E> sortedOn(@Nonnull Function<? super E, ? extends F> function) {
        Objects.requireNonNull(function, "'function' must not be null");
        return this.sortedBy(Comparator.comparing(function));
    }

    @Nonnull
    public abstract E[] toArray(@Nonnull Class<E> var1);

    @Nonnull
    public abstract Object[] toArray();

    @Override
    @Nonnull
    public String asString(@Nonnull String delimiter) {
        return this.stream().map(Objects::toString).collect(Collectors.joining(delimiter));
    }

    <T> T nonEmpty(Supplier<T> ifEmpty, Supplier<T> ifNonEmpty) {
        return (this.isEmpty() ? ifEmpty : ifNonEmpty).get();
    }

    @Nonnegative
    public int count(@Nullable E e) {
        int len = this.length();
        int c = 0;
        for (int i = 0; i < len; ++i) {
            E el = this.get(i);
            if (!Objects.equals(el, e)) continue;
            ++c;
        }
        return c;
    }

    @Nonnegative
    public int countBy(@Nonnull Predicate<? super E> predicate) {
        Objects.requireNonNull(predicate, "'predicate' must not be null");
        int len = this.length();
        int c = 0;
        for (int i = 0; i < len; ++i) {
            E el = this.get(i);
            if (!predicate.test(el)) continue;
            ++c;
        }
        return c;
    }

    public int find(@Nullable E e) {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            E el = this.get(i);
            if (!Objects.equals(el, e)) continue;
            return i;
        }
        return -1;
    }

    public int findBy(@Nonnull Predicate<? super E> predicate) {
        Objects.requireNonNull(predicate, "'predicate' must not be null");
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            E element = this.get(i);
            if (!predicate.test(element)) continue;
            return i;
        }
        return -1;
    }

    public Optional<E> findFirst(@Nonnull Predicate<? super E> predicate) {
        Objects.requireNonNull(predicate, "'predicate' must not be null");
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            E element = this.get(i);
            if (!predicate.test(element)) continue;
            return Optional.ofNullable(element);
        }
        return Optional.empty();
    }

    @Override
    public boolean contains(@Nullable E e) {
        return this.find(e) > -1;
    }

    @Override
    public boolean exists(@Nonnull Predicate<? super E> predicate) {
        return this.findBy(predicate) > -1;
    }

    @Override
    public boolean forAll(@Nonnull Predicate<? super E> predicate) {
        return this.countBy(predicate) == this.length();
    }

    void checkBounds(int index) {
        if (index >= this.length() || index < 0) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Nonnull
    public <F> Seq<F> map(@Nonnull Function<? super E, ? extends F> function) {
        Objects.requireNonNull(function, "'function' must not be null");
        Object[] array = new Object[this.length()];
        int i = 0;
        for (E e : this) {
            array[i++] = function.apply(e);
        }
        return new SeqSimple(array);
    }

    @Nonnull
    public <F> Seq<F> flatMap(@Nonnull Function<? super E, Seq<F>> function) {
        Objects.requireNonNull(function, "'function' must not be null");
        Seq[] array = new Seq[this.length()];
        int i = 0;
        int c = 0;
        for (E e : this) {
            Seq<F> result = function.apply(e);
            c += result.length();
            array[i++] = result;
        }
        Object[] resultArray = new Object[c];
        i = 0;
        for (Seq s : array) {
            for (E e : s) {
                resultArray[i++] = e;
            }
        }
        return new SeqSimple(resultArray);
    }

    @Nonnull
    public <F> Seq<F> flatMapOptional(@Nonnull Function<? super E, Optional<F>> function) {
        Objects.requireNonNull(function, "'function' must not be null");
        Seq[] array = new Seq[this.length()];
        SeqBuilder<E> resultBuilder = Seq.builder();
        for (E e : this) {
            Optional<F> result = function.apply(e);
            result.ifPresent(resultBuilder::add);
        }
        return (Seq)resultBuilder.build();
    }

    @Nonnull
    public <F> Seq<F> flatMapIterable(@Nonnull Function<? super E, ? extends Iterable<F>> function) {
        Objects.requireNonNull(function, "'function' must not be null");
        Seq[] array = new Seq[this.length()];
        SeqBuilder<E> resultBuilder = Seq.builder();
        for (E e : this) {
            resultBuilder.addElements(function.apply(e));
        }
        return (Seq)resultBuilder.build();
    }

    @Nonnull
    public <A> Seq<Pair<E, A>> zip(@Nonnull Seq<A> a) {
        return this.zipWith(Pair::new, a);
    }

    @Nonnull
    public <A, C> Seq<C> zipWith(@Nonnull BiFunction<? super E, ? super A, ? extends C> function, @Nonnull Seq<A> sequence) {
        Objects.requireNonNull(function, "'function' must not be null");
        Objects.requireNonNull(sequence, "'sequence' must not be null");
        int len = Math.min(this.length(), sequence.length());
        Object[] arr = new Object[len];
        for (int i = 0; i < len; ++i) {
            arr[i] = function.apply(this.get(i), sequence.get(i));
        }
        return new SeqSimple(arr);
    }

    @Nonnull
    public Seq<Pair<Integer, E>> zipWithIndex() {
        return Seq.rangeExclusive(0, this.length()).zip(this);
    }

    public <A> A foldl(@Nonnull BiFunction<? super A, ? super E, ? extends A> function, A startValue) {
        Objects.requireNonNull(function, "'function' must not be null");
        A acc = startValue;
        for (int i = 0; i < this.length(); ++i) {
            acc = function.apply(acc, this.get(i));
        }
        return acc;
    }

    public E foldl1(@Nonnull BiFunction<? super E, ? super E, ? extends E> function) {
        return ((Seq)this.tailView()).foldl(function, this.head());
    }

    public <A> A foldl1f(@Nonnull BiFunction<? super A, ? super E, ? extends A> function, @Nonnull Function<? super E, ? extends A> startValueFunction) {
        return ((Seq)this.tail()).foldl(function, startValueFunction.apply(this.head()));
    }

    public <A> A foldr(@Nonnull BiFunction<? super E, ? super A, ? extends A> function, A startValue) {
        Objects.requireNonNull(function, "'function' must not be null");
        A acc = startValue;
        for (int i = this.length() - 1; i >= 0; --i) {
            acc = function.apply(this.get(i), acc);
        }
        return acc;
    }

    public E foldr1(@Nonnull BiFunction<? super E, ? super E, ? extends E> function) {
        return ((Seq)this.initView()).foldr(function, this.last());
    }

    public <A> A foldr1f(@Nonnull BiFunction<? super E, ? super A, ? extends A> function, @Nonnull Function<? super E, ? extends A> startValueFunction) {
        Objects.requireNonNull(startValueFunction, "'startValueFunction' must not be null");
        return ((Seq)this.initView()).foldr(function, startValueFunction.apply(this.last()));
    }

    @Override
    @Nonnull
    public Pair<Seq<E>, Seq<E>> partitionBy(@Nonnull Predicate<? super E> predicate) {
        Objects.requireNonNull(predicate, "'predicate' must not be null");
        int sizeHint = this.length() / 2 + 1;
        SeqBuilder b1 = Seq.builder(sizeHint);
        SeqBuilder b2 = Seq.builder(sizeHint);
        this.forEach(x -> {
            if (predicate.test((Object)x)) {
                b1.add(x);
            } else {
                b2.add(x);
            }
        });
        return Pair.of(b1.result(), b2.result());
    }

    public E maximum() {
        try {
            return Seq.maximum(this);
        }
        catch (ClassCastException exc) {
            return null;
        }
    }

    public E minimum() {
        try {
            return Seq.minimum(this);
        }
        catch (ClassCastException exc) {
            return null;
        }
    }

    public E maximumBy(Comparator<? super E> comparator) {
        return (E)this.foldl1((left, right) -> comparator.compare((Object)left, (Object)right) < 0 ? right : left);
    }

    public E minimumBy(Comparator<? super E> comparator) {
        return (E)this.foldl1((left, right) -> comparator.compare((Object)left, (Object)right) > 0 ? right : left);
    }

    @Override
    @Nonnull
    public Seq<Seq<E>> group() {
        return this.groupBy(Objects::equals);
    }

    @Override
    @Nonnull
    public Seq<Seq<E>> groupBy(@Nonnull BiPredicate<? super E, ? super E> operator) {
        Objects.requireNonNull(operator, "'operator' must not be null");
        return this.nonEmpty(Seq::empty, () -> {
            SeqBuilder<E> b1 = Seq.builder();
            SeqBuilder<E> b2 = Seq.builder();
            E previous = this.head();
            b2.add((Object)previous);
            for (int i = 1; i < this.size(); ++i) {
                E current = this.get(i);
                if (!operator.test((E)previous, (E)current)) {
                    b1.add(b2.result());
                    b2.clear();
                }
                b2.add((Object)current);
                previous = current;
            }
            b1.add(b2.result());
            return b1.result();
        });
    }

    @Override
    @Nonnull
    public <F extends E> Seq<F> filter(@Nonnull Class<F> clazz) {
        return this.filter((? super E element) -> element != null && clazz.isAssignableFrom(element.getClass()));
    }

    @Override
    @Nonnull
    public Seq<E> filter(@Nonnull Predicate<? super E> predicate) {
        Objects.requireNonNull(predicate, "'predicate' must not be null");
        int sizeHint = this.length() / 2;
        SeqBuilder b = Seq.builder(sizeHint);
        this.forEach(x -> {
            if (predicate.test((Object)x)) {
                b.add(x);
            }
        });
        return b.result();
    }

    @Override
    @Nonnull
    public Seq<E> filterNot(@Nonnull Predicate<? super E> predicate) {
        Objects.requireNonNull(predicate, "'predicate' must not be null");
        return this.filter(predicate.negate());
    }

    @Override
    @Nonnull
    public Seq<E> takeWhile(@Nonnull Predicate<? super E> predicate) {
        int i;
        Objects.requireNonNull(predicate, "'predicate' must not be null");
        for (i = 0; i < this.length() && predicate.test(this.get(i)); ++i) {
        }
        return (Seq)this.take(i);
    }

    @Override
    @Nonnull
    public Seq<E> takeWhileView(@Nonnull Predicate<? super E> predicate) {
        int i;
        Objects.requireNonNull(predicate, "'predicate' must not be null");
        for (i = 0; i < this.length() && predicate.test(this.get(i)); ++i) {
        }
        return (Seq)this.takeView(i);
    }

    @Override
    @Nonnull
    public Seq<E> dropWhile(@Nonnull Predicate<? super E> predicate) {
        int i;
        Objects.requireNonNull(predicate, "'predicate' must not be null");
        for (i = 0; i < this.length() && predicate.test(this.get(i)); ++i) {
        }
        return (Seq)this.drop(i);
    }

    @Override
    @Nonnull
    public Seq<E> dropWhileView(@Nonnull Predicate<? super E> predicate) {
        int i;
        Objects.requireNonNull(predicate, "'predicate' must not be null");
        for (i = 0; i < this.length() && predicate.test(this.get(i)); ++i) {
        }
        return (Seq)this.dropView(i);
    }

    @Override
    @Nonnull
    public Pair<Seq<E>, Seq<E>> breakBy(@Nonnull Predicate<? super E> predicate) {
        Objects.requireNonNull(predicate, "'predicate' must not be null");
        int ix = this.findBy(predicate);
        if (ix < 0) {
            return Pair.of(this, Seq.empty());
        }
        if (ix == 0) {
            return Pair.of(Seq.empty(), this);
        }
        return Pair.of((Seq)this.subSequence(0, ix), (Seq)this.subSequence(ix, this.length()));
    }

    @Override
    @Nonnull
    public Pair<Seq<E>, Seq<E>> breakByView(@Nonnull Predicate<? super E> predicate) {
        Objects.requireNonNull(predicate, "'predicate' must not be null");
        int ix = this.findBy(predicate);
        if (ix < 0) {
            return Pair.of(this, Seq.empty());
        }
        if (ix == 0) {
            return Pair.of(Seq.empty(), this);
        }
        return Pair.of((Seq)this.subSequenceView(0, ix), (Seq)this.subSequenceView(ix, this.length()));
    }

    @Override
    @Nonnull
    public Pair<Seq<E>, Seq<E>> spanBy(@Nonnull Predicate<? super E> predicate) {
        Objects.requireNonNull(predicate, "'predicate' must not be null");
        return this.breakBy(predicate.negate());
    }

    @Override
    @Nonnull
    public Pair<Seq<E>, Seq<E>> spanByView(@Nonnull Predicate<? super E> predicate) {
        Objects.requireNonNull(predicate, "'predicate' must not be null");
        return this.breakByView(predicate.negate());
    }

    @Override
    @Nonnull
    public Seq<Seq<E>> inits() {
        int len = this.length();
        Object[] seqs = new Seq[len + 1];
        for (int i = 0; i <= len; ++i) {
            seqs[i] = (Seq)this.take(i);
        }
        return new SeqSimple<Seq<E>>(seqs);
    }

    @Override
    @Nonnull
    public Seq<Seq<E>> initsView() {
        int len = this.length();
        Object[] seqs = new Seq[len + 1];
        for (int i = 0; i <= len; ++i) {
            seqs[i] = (Seq)this.takeView(i);
        }
        return new SeqSimple<Seq<E>>(seqs);
    }

    @Override
    @Nonnull
    public Seq<Seq<E>> tails() {
        int len = this.length();
        Object[] seqs = new Seq[len + 1];
        for (int i = 0; i <= len; ++i) {
            seqs[i] = (Seq)this.takeRight(i);
        }
        return new SeqSimple<Seq<E>>(seqs);
    }

    @Override
    @Nonnull
    public Seq<Seq<E>> tailsView() {
        int len = this.length();
        Object[] seqs = new Seq[len + 1];
        for (int i = 0; i <= len; ++i) {
            seqs[i] = (Seq)this.takeRightView(i);
        }
        return new SeqSimple<Seq<E>>(seqs);
    }

    public E head() {
        return this.get(0);
    }

    public E last() {
        return this.get(this.length() - 1);
    }

    @Nonnull
    public Optional<E> headOptional() {
        return this.nonEmpty(Optional::empty, () -> Optional.of(this.head()));
    }

    @Nonnull
    public Optional<E> lastOptional() {
        return this.nonEmpty(Optional::empty, () -> Optional.of(this.last()));
    }

    @Nonnull
    public Seq<E> intercalate(@Nonnull Seq<E> seq) {
        return this.nonEmpty(Seq::empty, () -> {
            int targetSize = (seq.size() + 1) * this.size() - seq.size();
            Object[] targetArray = new Object[targetSize];
            targetArray[0] = this.head();
            int targetIndex = 1;
            for (int i = 1; i < this.size(); ++i) {
                for (int j = 0; j < seq.size(); ++j) {
                    targetArray[targetIndex++] = seq.get(j);
                }
                targetArray[targetIndex++] = this.get(i);
            }
            return new SeqSimple(targetArray);
        });
    }

    @Nonnull
    public Seq<E> intersperse(E e) {
        return this.nonEmpty(Seq::empty, () -> {
            int targetSize = this.size() * 2 - 1;
            Object[] targetArray = new Object[targetSize];
            targetArray[0] = this.head();
            int targetIndex = 1;
            for (int i = 1; i < this.size(); ++i) {
                targetArray[targetIndex++] = e;
                targetArray[targetIndex++] = this.get(i);
            }
            return new SeqSimple(targetArray);
        });
    }

    @Override
    @Nonnull
    public Seq<E> distinct() {
        HashSet elements = new HashSet();
        SeqBuilder builder = Seq.builder(this.size());
        this.forEach(element -> {
            if (!elements.contains(element)) {
                builder.add(element);
                elements.add(element);
            }
        });
        return builder.result();
    }

    public Seq<E> without(Seq<E> seq) {
        return this.filter((? super E element) -> !seq.contains(element));
    }

    public Seq<E> union(Seq<E> seq) {
        HashSet elements = new HashSet();
        SeqBuilder builder = Seq.builder(this.size());
        Consumer<Object> appender = element -> {
            if (!elements.contains(element)) {
                builder.add(element);
                elements.add(element);
            }
        };
        this.forEach(appender);
        seq.forEach(appender);
        return builder.result();
    }

    public Seq<E> intersect(Seq<E> seq) {
        return this.union(seq).filter((? super E e) -> this.contains(e) && seq.contains(e));
    }

    public boolean equals(@Nullable Object that) {
        Seq thatSeq;
        if (this == that) {
            return true;
        }
        if (!(that instanceof Seq)) {
            return false;
        }
        int len = this.length();
        if (len != (thatSeq = (Seq)that).length()) {
            return false;
        }
        Iterator<E> thisIterator = this.iterator();
        Iterator<E> thatIterator = thatSeq.iterator();
        for (int i = 0; i < len; ++i) {
            E thatElement;
            E thisElement = thisIterator.next();
            if (Objects.equals(thisElement, thatElement = thatIterator.next())) continue;
            return false;
        }
        return true;
    }

    public final int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.calculateHashCode();
        }
        return this.hashCode;
    }

    int calculateHashCode() {
        int result = 1;
        for (E element : this) {
            result = 31 * result + (element == null ? 0 : element.hashCode());
        }
        return result;
    }

    public String toString() {
        return this.stream().map(Objects::toString).collect(Collectors.joining(", ", "[", "]"));
    }

    static <E> void reverse(@Nonnull E[] array) {
        int len = array.length;
        int halfLen = len / 2;
        int i = 0;
        int j = len - 1;
        while (i < halfLen) {
            Control.swap(array, i, j);
            ++i;
            --j;
        }
    }

    @Override
    @Nonnull
    public Seq<E> rotated(int amount) {
        Object[] array = new Object[this.size()];
        if (amount == 0) {
            return this;
        }
        if (amount < 0) {
            return this.leftRotated(-amount);
        }
        for (int i = 0; i < this.size(); ++i) {
            array[(i + amount) % this.size()] = this.get(i);
        }
        return Seq.ofArrayZeroCopyInternal(array);
    }

    @Nonnull
    private Seq<E> leftRotated(int amount) {
        Object[] array = new Object[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            array[i] = this.get((i + amount) % this.size());
        }
        return Seq.ofArrayZeroCopyInternal(array);
    }

    @Override
    @Nonnull
    public Iterator<Seq<E>> permutationsIterator() {
        return new PermutationIterator(this);
    }

    @Override
    @Nonnull
    public Seq<Seq<E>> permutations() {
        return this.permutationsStream().collect(Seq.collector());
    }

    @Override
    @Nonnull
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private int current = 0;

            @Override
            public boolean hasNext() {
                return this.current < Seq.this.length();
            }

            @Override
            public E next() {
                return Seq.this.get(this.current++);
            }
        };
    }

    @Nonnull
    public Iterator<E> reverseIterator() {
        return ((Seq)this.reversed()).iterator();
    }

    @Override
    @Nonnull
    public List<E> toList() {
        return new AbstractList<E>(){

            @Override
            public E get(int index) {
                return Seq.this.get(index);
            }

            @Override
            public int size() {
                return Seq.this.length();
            }
        };
    }

    public static <T> Collector<T, SeqBuilder<T>, Seq<T>> collector() {
        return new Collector<T, SeqBuilder<T>, Seq<T>>(){

            @Override
            public Supplier<SeqBuilder<T>> supplier() {
                return Seq::builder;
            }

            @Override
            public BiConsumer<SeqBuilder<T>, T> accumulator() {
                return SeqBuilder::add;
            }

            @Override
            public BinaryOperator<SeqBuilder<T>> combiner() {
                return AbstractBuilder::addElements;
            }

            @Override
            public Function<SeqBuilder<T>, Seq<T>> finisher() {
                return SeqBuilder::result;
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return Collections.emptySet();
            }
        };
    }

    @Nonnull
    public <K> Mapping<K, Seq<E>> toMap(@Nonnull Function<? super E, ? extends K> groupingFunction) {
        Objects.requireNonNull(groupingFunction, "'groupingFunction' must not be null");
        HashMap<Object, SeqBuilder> map = new HashMap<Object, SeqBuilder>();
        boolean allComparable = true;
        for (E element : this) {
            K key2 = groupingFunction.apply(element);
            boolean bl = allComparable = allComparable && key2 instanceof Comparable;
            if (!map.containsKey(key2)) {
                map.put(key2, Seq.builder());
            }
            ((SeqBuilder)map.get(key2)).add((Object)element);
        }
        if (map.isEmpty()) {
            return Mapping.empty();
        }
        HashMap finalMap = new HashMap();
        map.forEach((? super K key, ? super V builder) -> finalMap.put(key, builder.result()));
        return Mapping.wrap(finalMap);
    }

    @Nonnull
    public <K extends Comparable<K>> ArrayMap<K, Seq<E>> toArrayMap(@Nonnull Function<? super E, ? extends K> groupingFunction) {
        Objects.requireNonNull(groupingFunction, "'groupingFunction' must not be null");
        TreeMap<Comparable, SeqBuilder<E>> map = new TreeMap<Comparable, SeqBuilder<E>>();
        for (E element : this) {
            Comparable key = (Comparable)groupingFunction.apply(element);
            if (!map.containsKey(key)) {
                map.put(key, Seq.builder());
            }
            ((SeqBuilder)map.get(key)).add((Object)element);
        }
        if (map.isEmpty()) {
            return ArrayMap.empty();
        }
        Object[] keys = Seq.ofCollectionInternal(map.keySet()).backingArray;
        Object[] values = new Object[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            values[i] = ((SeqBuilder)map.get(keys[i])).result();
        }
        return new ArrayMap(keys, values);
    }

    @Nonnull
    public static <E> Seq<E> empty() {
        return SeqEmpty.EMPTY;
    }

    @SafeVarargs
    @Nonnull
    public static <E> Seq<E> of(E ... es) {
        Objects.requireNonNull(es);
        if (es.length == 0) {
            return Seq.empty();
        }
        return new SeqSimple(es);
    }

    @SafeVarargs
    @Nonnull
    public static <E> Seq<E> seq(E ... es) {
        return Seq.ofArray(es);
    }

    @Nonnull
    public static <E> Seq<E> ofArray(@Nonnull E[] array) {
        Objects.requireNonNull(array);
        if (array.length == 0) {
            return Seq.empty();
        }
        return new SeqSimple((Object[])array.clone());
    }

    @Nonnull
    static <E> SeqSimple<E> ofArrayZeroCopyInternal(@Nonnull Object[] array) {
        return new SeqSimple(array);
    }

    @Nonnull
    public static <E> Seq<E> ofCollection(@Nonnull Collection<? extends E> collection) {
        Objects.requireNonNull(collection);
        if (collection.isEmpty()) {
            return Seq.empty();
        }
        return Seq.ofCollectionInternal(collection);
    }

    @Nonnull
    static <E> SeqSimple<E> ofCollectionInternal(@Nonnull Collection<? extends E> collection) {
        Object[] array = new Object[collection.size()];
        int i = 0;
        for (E e : collection) {
            array[i++] = e;
        }
        return new SeqSimple(array);
    }

    @Nonnull
    public static <E> Seq<E> ofIterable(@Nonnull Iterable<? extends E> iterable) {
        Objects.requireNonNull(iterable);
        SeqBuilder builder = new SeqBuilder();
        iterable.forEach(builder::add);
        return builder.result();
    }

    @Nonnull
    public static <E> Seq<E> ofIterator(@Nonnull Iterator<? extends E> iterator) {
        Objects.requireNonNull(iterator);
        SeqBuilder builder = new SeqBuilder();
        while (iterator.hasNext()) {
            builder.add((Object)iterator.next());
        }
        return builder.result();
    }

    @Nonnull
    public static <C, A extends C, B extends C> Seq<C> ofPair(@Nonnull Pair<A, B> pair) {
        Objects.requireNonNull(pair, "'pair' must not be null");
        return ((SeqBuilder)Seq.builder().addAll(pair.fst(), pair.snd())).result();
    }

    @Nonnull
    public static Seq<Character> ofString(@Nonnull String string) {
        Objects.requireNonNull(string);
        Object[] array = new Character[string.length()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = Character.valueOf(string.charAt(i));
        }
        return new SeqSimple<Character>(array);
    }

    @Nonnull
    public static Seq<Integer> codepointsOfString(@Nonnull String string) {
        SeqBuilder b = Seq.builder();
        Strings.forEachCodepoint(string, b::add);
        return b.result();
    }

    @SafeVarargs
    @Nonnull
    public static <E> Seq<E> concatView(final Seq<E> ... seqs) {
        Objects.requireNonNull(seqs);
        if (seqs.length == 0) {
            return Seq.empty();
        }
        int size = 0;
        for (Seq<E> seq : seqs) {
            size += seq.length();
        }
        if (size == 0) {
            return Seq.empty();
        }
        return new SeqGenerated<E>(ix -> {
            Seq seq = seqs[0];
            int i = 1;
            while (ix >= seq.length()) {
                ix -= seq.length();
                seq = seqs[i++];
            }
            return seq.get(ix);
        }, size){

            @Override
            @Nonnull
            public Iterator<E> iterator() {
                return new Iterator<E>(){
                    private int i = 0;
                    private int j = 0;

                    @Override
                    public boolean hasNext() {
                        return this.i < seqs.length && this.j < seqs[this.i].length();
                    }

                    @Override
                    public E next() {
                        Object elem = seqs[this.i].get(this.j);
                        ++this.j;
                        if (this.j == seqs[this.i].length()) {
                            this.j = 0;
                            ++this.i;
                        }
                        return elem;
                    }
                };
            }
        };
    }

    @SafeVarargs
    @Nonnull
    public static <E> Seq<E> concat(Seq<E> ... seqs) {
        Objects.requireNonNull(seqs);
        int size = 0;
        for (Seq<E> seq : seqs) {
            size += seq.length();
        }
        if (size == 0) {
            return Seq.empty();
        }
        Object[] array = new Object[size];
        int i = 0;
        for (Seq<E> seq : seqs) {
            for (E elem : seq) {
                array[i++] = elem;
            }
        }
        return new SeqSimple(array);
    }

    @Nonnull
    public static <E> SeqBuilder<E> builder() {
        return new SeqBuilder();
    }

    @Nonnull
    public static <E> SeqBuilder<E> builder(int sizeHint) {
        return new SeqBuilder(sizeHint);
    }

    @Nonnull
    public static <E> Seq<E> ofGenerator(@Nonnull IntFunction<E> function, @Nonnegative int length) {
        Objects.requireNonNull(function, "'function' must not be null.");
        return new SeqGenerated<E>(function, length);
    }

    @Nonnull
    public static <E> Seq<E> ofGeneratorMemoizing(@Nonnull IntFunction<E> function, @Nonnegative int length) {
        Objects.requireNonNull(function, "'function' must not be null.");
        return new SeqGenerated<E>(Control.memoizing(function), length);
    }

    @Nonnull
    public static Seq<Character> wrap(@Nonnull char[] array) {
        if (array.length == 0) {
            return Seq.empty();
        }
        return Seq.ofGenerator(ix -> Character.valueOf(array[ix]), array.length);
    }

    @Nonnull
    public static Seq<Boolean> wrap(@Nonnull boolean[] array) {
        if (array.length == 0) {
            return Seq.empty();
        }
        return Seq.ofGenerator(ix -> array[ix], array.length);
    }

    @Nonnull
    public static Seq<Byte> wrap(@Nonnull byte[] array) {
        if (array.length == 0) {
            return Seq.empty();
        }
        return Seq.ofGenerator(ix -> array[ix], array.length);
    }

    @Nonnull
    public static Seq<Short> wrap(@Nonnull short[] array) {
        if (array.length == 0) {
            return Seq.empty();
        }
        return Seq.ofGenerator(ix -> array[ix], array.length);
    }

    @Nonnull
    public static Seq<Integer> wrap(@Nonnull int[] array) {
        if (array.length == 0) {
            return Seq.empty();
        }
        return Seq.ofGenerator(ix -> array[ix], array.length);
    }

    @Nonnull
    public static Seq<Long> wrap(@Nonnull long[] array) {
        if (array.length == 0) {
            return Seq.empty();
        }
        return Seq.ofGenerator(ix -> array[ix], array.length);
    }

    @Nonnull
    public static Seq<Float> wrap(@Nonnull float[] array) {
        if (array.length == 0) {
            return Seq.empty();
        }
        return Seq.ofGenerator(ix -> Float.valueOf(array[ix]), array.length);
    }

    @Nonnull
    public static Seq<Double> wrap(@Nonnull double[] array) {
        if (array.length == 0) {
            return Seq.empty();
        }
        return Seq.ofGenerator(ix -> array[ix], array.length);
    }

    @Nonnull
    public static Seq<Character> wrap(@Nonnull Character[] array) {
        if (array.length == 0) {
            return Seq.empty();
        }
        return Seq.ofGenerator(ix -> array[ix], array.length);
    }

    @Nonnull
    public static Seq<Boolean> wrap(@Nonnull Boolean[] array) {
        if (array.length == 0) {
            return Seq.empty();
        }
        return Seq.ofGenerator(ix -> array[ix], array.length);
    }

    @Nonnull
    public static Seq<Byte> wrap(@Nonnull Byte[] array) {
        if (array.length == 0) {
            return Seq.empty();
        }
        return Seq.ofGenerator(ix -> array[ix], array.length);
    }

    @Nonnull
    public static Seq<Short> wrap(@Nonnull Short[] array) {
        if (array.length == 0) {
            return Seq.empty();
        }
        return Seq.ofGenerator(ix -> array[ix], array.length);
    }

    @Nonnull
    public static Seq<Integer> wrap(@Nonnull Integer[] array) {
        if (array.length == 0) {
            return Seq.empty();
        }
        return Seq.ofGenerator(ix -> array[ix], array.length);
    }

    @Nonnull
    public static Seq<Long> wrap(@Nonnull Long[] array) {
        if (array.length == 0) {
            return Seq.empty();
        }
        return Seq.ofGenerator(ix -> array[ix], array.length);
    }

    @Nonnull
    public static Seq<Float> wrap(@Nonnull Float[] array) {
        if (array.length == 0) {
            return Seq.empty();
        }
        return Seq.ofGenerator(ix -> array[ix], array.length);
    }

    @Nonnull
    public static Seq<Double> wrap(@Nonnull Double[] array) {
        if (array.length == 0) {
            return Seq.empty();
        }
        return Seq.ofGenerator(ix -> array[ix], array.length);
    }

    @Nonnull
    public static <E> Seq<E> wrap(@Nonnull E[] array) {
        if (array.length == 0) {
            return Seq.empty();
        }
        return Seq.ofGenerator(ix -> array[ix], array.length);
    }

    @Nonnull
    public static <E> Seq<E> wrap(@Nonnull List<E> list) {
        if (list.isEmpty()) {
            return Seq.empty();
        }
        return Seq.ofGenerator(list::get, list.size());
    }

    @Nonnull
    public static Seq<Boolean> wrap(@Nonnull BitSet bitSet) {
        if (bitSet.isEmpty()) {
            return Seq.empty();
        }
        return Seq.ofGenerator(bitSet::get, bitSet.length());
    }

    @Nonnull
    public static Seq<Character> wrap(@Nonnull String string) {
        if (string.isEmpty()) {
            return Seq.empty();
        }
        return Seq.ofGenerator(string::charAt, string.length());
    }

    public static <E extends Comparable<? super E>> E minimum(Seq<E> seq) {
        if (seq instanceof SeqSimpleSorted) {
            return (E)((Comparable)seq.head());
        }
        Objects.requireNonNull(seq, "'seq' must not be null");
        return (E)((Comparable)seq.minimumBy(Comparable::compareTo));
    }

    public static <E extends Comparable<? super E>> E maximum(Seq<E> seq) {
        if (seq instanceof SeqSimpleSorted) {
            return (E)((Comparable)seq.last());
        }
        Objects.requireNonNull(seq, "'seq' must not be null");
        return (E)((Comparable)seq.maximumBy(Comparable::compareTo));
    }

    public static boolean any(@Nonnull Seq<Boolean> seq) {
        Objects.requireNonNull(seq, "the supplied sequence must not be null");
        for (Boolean e : seq) {
            if (!Boolean.TRUE.equals(e)) continue;
            return true;
        }
        return false;
    }

    public static boolean all(@Nonnull Seq<Boolean> seq) {
        Objects.requireNonNull(seq, "the supplied sequence must not be null");
        for (Boolean e : seq) {
            if (Boolean.TRUE.equals(e)) continue;
            return false;
        }
        return true;
    }

    public static int intSum(Seq<Integer> seq) {
        Objects.requireNonNull(seq, "'seq' must not be null");
        return seq.foldl(Operators::plus, 0);
    }

    public static long longSum(Seq<Long> seq) {
        Objects.requireNonNull(seq, "'seq' must not be null");
        return seq.foldl(Operators::plus, 0L);
    }

    public static double doubleSum(Seq<Double> seq) {
        Objects.requireNonNull(seq, "'seq' must not be null");
        return seq.foldl(Operators::plus, 0.0);
    }

    public static int intProduct(Seq<Integer> seq) {
        Objects.requireNonNull(seq, "'seq' must not be null");
        return seq.foldl(Operators::times, 1);
    }

    public static long longProduct(Seq<Long> seq) {
        Objects.requireNonNull(seq, "'seq' must not be null");
        return seq.foldl(Operators::times, 1L);
    }

    public static double doubleProduct(Seq<Double> seq) {
        Objects.requireNonNull(seq, "'seq' must not be null");
        return seq.foldl(Operators::times, 1.0);
    }

    public static boolean and(Seq<Boolean> seq) {
        return Seq.all(seq);
    }

    public static boolean or(Seq<Boolean> seq) {
        return Seq.any(seq);
    }

    public static <A, B> int commonPrefixLength(@Nonnull Seq<A> as, @Nonnull Seq<B> bs) {
        B b;
        A a;
        Objects.requireNonNull(as, "'as' must not be null");
        Objects.requireNonNull(bs, "'bs' must not be null");
        int length = Math.min(as.size(), bs.size());
        int commonPrefixLength = 0;
        for (int i = 0; i < length && Objects.equals(a = as.get(i), b = bs.get(i)); ++i) {
            ++commonPrefixLength;
        }
        return commonPrefixLength;
    }

    @Nonnull
    public static <E, A extends E, B extends E> Seq<A> commonPrefix(Seq<A> as, Seq<B> bs) {
        int commonPrefixLength = Seq.commonPrefixLength(as, bs);
        return (Seq)as.subSequence(0, commonPrefixLength);
    }

    @Nonnull
    public static <E, A extends E, B extends E> Seq<A> commonPrefixView(Seq<A> as, Seq<B> bs) {
        int commonPrefixLength = Seq.commonPrefixLength(as, bs);
        return (Seq)as.subSequenceView(0, commonPrefixLength);
    }

    @Nonnull
    public static Seq<Integer> rangeInclusive(int from, int to) {
        if (from <= to) {
            return Seq.ofGenerator(index -> from + index, to - from + 1);
        }
        int length = from - to;
        return Seq.ofGenerator(index -> to + (length - index), length + 1);
    }

    @Nonnull
    public static Seq<Integer> rangeExclusive(int from, int to) {
        if (from == to) {
            return Seq.empty();
        }
        if (from < to) {
            return Seq.ofGenerator(index -> from + index, to - from);
        }
        int length = from - to;
        return Seq.ofGenerator(index -> to + (length - index), length);
    }

    public static <A, B, C, D> Seq<Quadruple<A, B, C, D>> zip(Seq<A> as, Seq<B> bs, Seq<C> cs, Seq<D> ds) {
        int length = Arithmetic.minimum(as.length(), bs.length(), cs.length(), ds.length());
        SeqBuilder builder = Seq.builder(length);
        for (int i = 0; i < length; ++i) {
            builder.add(Quadruple.of(as.get(i), bs.get(i), cs.get(i), ds.get(i)));
        }
        return builder.result();
    }

    public static <A, B, C> Seq<Triple<A, B, C>> zip(Seq<A> as, Seq<B> bs, Seq<C> cs) {
        int length = Arithmetic.minimum(as.length(), bs.length(), cs.length());
        SeqBuilder builder = Seq.builder(length);
        for (int i = 0; i < length; ++i) {
            builder.add(Triple.of(as.get(i), bs.get(i), cs.get(i)));
        }
        return builder.result();
    }

    public static <A, B, C> Seq<Pair<A, B>> zip(Seq<A> as, Seq<B> bs) {
        int length = Arithmetic.minimum(as.length(), bs.length());
        SeqBuilder builder = Seq.builder(length);
        for (int i = 0; i < length; ++i) {
            builder.add(Pair.of(as.get(i), bs.get(i)));
        }
        return builder.result();
    }

    @FunctionalInterface
    @Deprecated
    public static interface WithIndexConsumer<E> {
        public void consume(int var1, E var2);
    }
}

