/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import de.scravy.bedrock.Seq;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class SeqEmpty
extends Seq<Object> {
    static Seq<Object> EMPTY = new SeqEmpty();

    private SeqEmpty() {
    }

    @Override
    @Nonnegative
    public int length() {
        return 0;
    }

    @Override
    public Object get(@Nonnegative int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    @Nonnull
    public Seq<Object> reversed() {
        return this;
    }

    @Override
    @Nonnull
    public Seq<Object> sorted() {
        return this;
    }

    @Override
    @Nonnull
    public Seq<Object> sortedBy(@Nonnull Comparator<? super Object> comparator) {
        Objects.requireNonNull(comparator);
        return this;
    }

    @Override
    @Nonnull
    public Seq<Object> shuffled(@Nonnull Random random) {
        Objects.requireNonNull(random);
        return this;
    }

    @Override
    @Nonnull
    public <T> Seq<T> map(@Nonnull Function<? super Object, ? extends T> function) {
        Objects.requireNonNull(function);
        return this;
    }

    @Override
    @Nonnull
    public Seq<Object> subSequence(@Nonnegative int beginOffset, @Nonnegative int endOffset) {
        return this;
    }

    @Override
    @Nonnull
    public Seq<Object> subSequenceView(@Nonnegative int beginOffset, @Nonnegative int endOffset) {
        return this;
    }

    @Override
    @Nonnull
    public Seq<Seq<Object>> inits() {
        return SeqEmpty.empty();
    }

    @Override
    @Nonnull
    public Seq<Seq<Object>> tails() {
        return SeqEmpty.empty();
    }

    @Override
    @Nonnegative
    public int count(@Nullable Object e) {
        return 0;
    }

    @Override
    @Nonnegative
    public int countBy(@Nonnull Predicate<? super Object> predicate) {
        Objects.requireNonNull(predicate);
        return 0;
    }

    @Override
    public int find(@Nullable Object e) {
        return -1;
    }

    @Override
    public int findBy(@Nonnull Predicate<? super Object> predicate) {
        return -1;
    }

    @Override
    public boolean contains(@Nullable Object e) {
        return false;
    }

    @Override
    public boolean exists(@Nonnull Predicate<? super Object> predicate) {
        return false;
    }

    @Override
    public boolean forAll(@Nonnull Predicate<? super Object> predicate) {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    @Nonnull
    public Seq<Object> trimmedToSize() {
        return this;
    }

    @Override
    @Nonnull
    public Object[] toArray() {
        return new Object[0];
    }

    @Override
    @Nonnull
    public Object[] toArray(@Nonnull Class<Object> evidence) {
        Objects.requireNonNull(evidence);
        return (Object[])Array.newInstance(evidence, 0);
    }

    @Override
    @Nonnull
    public List<Object> toList() {
        return Collections.emptyList();
    }

    @Override
    @Nonnull
    public Stream<Object> stream() {
        return Stream.empty();
    }

    @Override
    int calculateHashCode() {
        return 1;
    }
}

