/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import de.scravy.bedrock.Seq;
import java.lang.reflect.Array;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.IntFunction;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import lombok.Generated;

class SeqGenerated<E>
extends Seq<E> {
    private final IntFunction<E> backingFunction;
    private final int length;

    SeqGenerated(@Nonnull IntFunction<E> function, @Nonnegative int length) {
        this.backingFunction = function;
        this.length = length;
    }

    @Override
    public E get(@Nonnegative int index) {
        if (index >= this.length || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.backingFunction.apply(index);
    }

    @Override
    @Nonnull
    public Seq<E> sortedBy(@Nonnull Comparator<? super E> comparator) {
        return ((Seq)this.trimmedToSize()).sortedBy(comparator);
    }

    @Override
    @Nonnull
    public E[] toArray(@Nonnull Class<E> evidence) {
        Objects.requireNonNull(evidence);
        int length = this.size();
        Object[] array = (Object[])Array.newInstance(evidence, length);
        for (int i = 0; i < length; ++i) {
            array[i] = this.get(i);
        }
        return array;
    }

    @Override
    @Nonnull
    public Object[] toArray() {
        Object[] array = new Object[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            array[i] = this.backingFunction.apply(i);
        }
        return array;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    @Nonnull
    public Seq<E> reversed() {
        if (this.backingFunction instanceof ReversedFunction) {
            ReversedFunction f = (ReversedFunction)this.backingFunction;
            return Seq.ofGenerator(f.backingFunction, f.length);
        }
        return Seq.ofGenerator(new ReversedFunction<E>(this.length, this.backingFunction), this.length);
    }

    @Override
    @Nonnull
    public Seq<E> sorted() {
        return (Seq)this.trimmedToSize().sorted();
    }

    @Override
    @Nonnull
    public Seq<E> trimmedToSize() {
        return Seq.ofArrayZeroCopyInternal(this.toArray());
    }

    @Override
    @Nonnull
    public Seq<E> subSequence(int beginOffset, int endOffset) {
        int begin = Math.max(0, beginOffset);
        int end = Math.min(this.length(), endOffset);
        int len = end - begin;
        if (len <= 0) {
            return SeqGenerated.empty();
        }
        Object[] array = new Object[len];
        for (int i = 0; i < len; ++i) {
            array[i] = this.get(begin + i);
        }
        return Seq.ofArrayZeroCopyInternal(array);
    }

    @Override
    @Nonnull
    public Seq<E> subSequenceView(int beginOffset, int endOffset) {
        return this.subSequence(beginOffset, endOffset);
    }

    private static class ReversedFunction<X>
    implements IntFunction<X> {
        private int length;
        private IntFunction<X> backingFunction;

        @Override
        public X apply(int ix) {
            return this.backingFunction.apply(this.length - ix - 1);
        }

        @Generated
        public ReversedFunction(int length, IntFunction<X> backingFunction) {
            this.length = length;
            this.backingFunction = backingFunction;
        }
    }
}

