/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import de.scravy.bedrock.Seq;
import de.scravy.bedrock.SeqReversedView;
import de.scravy.bedrock.SeqSimple;
import de.scravy.bedrock.SeqSimpleSorted;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

class SeqReversed<E>
extends Seq<E> {
    private final Object[] backingArray;

    SeqReversed(@Nonnull Object[] array) {
        this.backingArray = array;
    }

    @Override
    public E get(@Nonnegative int index) {
        this.checkBounds(index);
        return (E)this.backingArray[this.backingArray.length - index - 1];
    }

    @Override
    @Nonnull
    public Seq<E> reversed() {
        return new SeqSimple(this.backingArray);
    }

    @Override
    @Nonnull
    public Seq<E> sorted() {
        Object[] array = (Object[])this.backingArray.clone();
        Arrays.sort(array, NULL_ACCEPTING_COMPARATOR);
        return new SeqSimpleSorted(array);
    }

    @Override
    @Nonnull
    public Seq<E> sortedBy(@Nonnull Comparator<? super E> comparator) {
        Objects.requireNonNull(comparator);
        Object[] array = (Object[])this.backingArray.clone();
        Arrays.sort(array, comparator);
        return new SeqSimple(array);
    }

    @Override
    @Nonnull
    public Seq<E> trimmedToSize() {
        return this;
    }

    @Override
    @Nonnull
    public Object[] toArray() {
        Object[] array = (Object[])this.backingArray.clone();
        SeqReversed.reverse(array);
        return array;
    }

    @Override
    @Nonnull
    public Seq<E> subSequence(@Nonnegative int beginOffset, @Nonnegative int endOffset) {
        int begin = Math.max(0, beginOffset);
        int end = Math.min(this.length(), endOffset);
        int len = end - begin;
        if (len <= 0) {
            return SeqReversed.empty();
        }
        Object[] array = new Object[len];
        System.arraycopy(this.backingArray, this.length() - end, array, 0, len);
        return new SeqReversed<E>(array);
    }

    @Override
    @Nonnull
    public Seq<E> subSequenceView(@Nonnegative int beginOffset, @Nonnegative int endOffset) {
        int begin = Math.max(0, beginOffset);
        int end = Math.min(this.length(), endOffset);
        int len = end - begin;
        if (len <= 0) {
            return SeqReversed.empty();
        }
        return new SeqReversedView(this.backingArray, this.length() - end, this.length() - begin);
    }

    @Override
    @Nonnull
    public E[] toArray(@Nonnull Class<E> evidence) {
        Objects.requireNonNull(evidence);
        int len = this.backingArray.length;
        Object[] array = (Object[])Array.newInstance(evidence, len);
        System.arraycopy(this.backingArray, 0, array, 0, len);
        SeqReversed.reverse(array);
        return array;
    }

    @Override
    @Nonnegative
    public int length() {
        return this.backingArray.length;
    }
}

