/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import de.scravy.bedrock.Seq;
import de.scravy.bedrock.SeqReversed;
import de.scravy.bedrock.SeqSimpleSorted;
import de.scravy.bedrock.SeqSimpleView;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

class SeqSimple<E>
extends Seq<E> {
    final Object[] backingArray;

    SeqSimple(@Nonnull Object[] array) {
        this.backingArray = array;
    }

    @Override
    public E get(@Nonnegative int index) {
        this.checkBounds(index);
        return (E)this.backingArray[index];
    }

    @Override
    @Nonnull
    public Seq<E> reversed() {
        return new SeqReversed(this.backingArray);
    }

    @Override
    @Nonnull
    public Seq<E> sorted() {
        return this.sortedInternal();
    }

    @Nonnull
    SeqSimpleSorted sortedInternal() {
        Object[] array = (Object[])this.backingArray.clone();
        Arrays.sort(array, NULL_ACCEPTING_COMPARATOR);
        return new SeqSimpleSorted(array);
    }

    @Override
    @Nonnull
    public Seq<E> sortedBy(@Nonnull Comparator<? super E> comparator) {
        Objects.requireNonNull(comparator);
        Object[] array = (Object[])this.backingArray.clone();
        Arrays.sort(array, comparator);
        return new SeqSimple<E>(array);
    }

    @Override
    @Nonnull
    public Seq<E> trimmedToSize() {
        return this;
    }

    @Override
    @Nonnull
    public E[] toArray(@Nonnull Class<E> evidence) {
        Objects.requireNonNull(evidence);
        int length = this.backingArray.length;
        Object[] array = (Object[])Array.newInstance(evidence, length);
        System.arraycopy(this.backingArray, 0, array, 0, length);
        return array;
    }

    @Override
    @Nonnull
    public Object[] toArray() {
        return (Object[])this.backingArray.clone();
    }

    @Override
    @Nonnull
    public Seq<E> subSequence(@Nonnegative int beginOffset, @Nonnegative int endOffset) {
        int begin = Math.max(0, beginOffset);
        int end = Math.min(this.length(), endOffset);
        int len = end - begin;
        if (len <= 0) {
            return SeqSimple.empty();
        }
        Object[] array = new Object[len];
        System.arraycopy(this.backingArray, begin, array, 0, len);
        return new SeqSimple<E>(array);
    }

    @Override
    @Nonnull
    public Seq<E> subSequenceView(@Nonnegative int beginOffset, @Nonnegative int endOffset) {
        int begin = Math.max(0, beginOffset);
        int end = Math.min(this.length(), endOffset);
        int len = end - begin;
        if (len <= 0) {
            return SeqSimple.empty();
        }
        return new SeqSimpleView(this.backingArray, begin, end);
    }

    @Override
    @Nonnull
    public Stream<E> stream() {
        return Arrays.stream(this.backingArray);
    }

    @Override
    @Nonnegative
    public int length() {
        return this.backingArray.length;
    }
}

