/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import de.scravy.bedrock.Seq;
import de.scravy.bedrock.SeqBuilder;
import de.scravy.bedrock.SeqSimple;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class SeqSimpleSorted<E extends Comparable<? super E>>
extends SeqSimple<E> {
    SeqSimpleSorted(@Nonnull Object[] array) {
        super(array);
    }

    @Override
    public boolean contains(@Nullable E element) {
        return Arrays.binarySearch(this.backingArray, element, NULL_ACCEPTING_COMPARATOR) >= 0;
    }

    @Override
    public int find(@Nullable E element) {
        int ix = Arrays.binarySearch(this.backingArray, element, NULL_ACCEPTING_COMPARATOR);
        return ix >= 0 ? ix : -1;
    }

    @Override
    @Nonnull
    public SeqSimpleSorted<E> sorted() {
        return this;
    }

    @Override
    @Nonnull
    public Seq<E> distinct() {
        return this.nonEmpty(Seq::empty, () -> {
            Comparable prev = (Comparable)this.head();
            SeqBuilder builder = Seq.builder();
            for (int i = 1; i < this.size(); ++i) {
                Comparable current = (Comparable)this.get(i);
                if (current.equals(prev)) {
                    if (builder.isEmpty()) {
                        builder.addElements(this.subSequenceView(0, i));
                    }
                } else if (builder.nonEmpty()) {
                    builder.add(current);
                }
                prev = current;
            }
            if (builder.isEmpty()) {
                return this;
            }
            return builder.resultSortedInternal();
        });
    }

    @Override
    @Nonnull
    public Seq<E> union(Seq<E> other) {
        return this.nonEmpty(other::distinct, () -> {
            Comparable toAdd;
            if (other.isEmpty()) {
                return this.distinct();
            }
            if (!(other instanceof SeqSimpleSorted)) {
                return super.union(other);
            }
            SeqBuilder builder = Seq.builder(this.size() + other.size());
            Comparator<Comparable> comparator = Comparator.nullsFirst(Comparable::compareTo);
            int i = 0;
            int j = 0;
            Comparable mostRecentlyAdded = comparator.compare((Comparable)this.get(i), (Comparable)other.get(j)) <= 0 ? (Comparable)this.get(i++) : (Comparable)other.get(j++);
            builder.add(mostRecentlyAdded);
            while (i < this.size() && j < other.size()) {
                toAdd = comparator.compare((Comparable)this.get(i), (Comparable)other.get(j)) <= 0 ? (Comparable)this.get(i++) : (Comparable)other.get(j++);
                if (Objects.equals(mostRecentlyAdded, toAdd)) continue;
                mostRecentlyAdded = toAdd;
                builder.add(mostRecentlyAdded);
            }
            while (i < this.size()) {
                if (Objects.equals(mostRecentlyAdded, toAdd = (Comparable)this.get(i++))) continue;
                mostRecentlyAdded = toAdd;
                builder.add(mostRecentlyAdded);
            }
            while (j < other.size()) {
                if (Objects.equals(mostRecentlyAdded, toAdd = (Comparable)other.get(j++))) continue;
                mostRecentlyAdded = toAdd;
                builder.add(mostRecentlyAdded);
            }
            return builder.resultSortedInternal();
        });
    }

    @Override
    @Nonnull
    public Seq<E> without(Seq<E> other) {
        SeqBuilder builder = Seq.builder();
        this.forEach(element -> {
            if (!other.contains(element)) {
                builder.add(element);
            }
        });
        return builder.resultSortedInternal();
    }
}

