/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import de.scravy.bedrock.Seq;
import de.scravy.bedrock.SeqReversedView;
import de.scravy.bedrock.SeqSimple;
import de.scravy.bedrock.SeqSimpleSorted;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

class SeqSimpleView<E>
extends Seq<E> {
    private final int beginOffset;
    private final int endOffset;
    private final Object[] backingArray;

    SeqSimpleView(@Nonnull Object[] array, @Nonnegative int beginOffset, @Nonnegative int endOffset) {
        this.backingArray = array;
        this.beginOffset = beginOffset;
        this.endOffset = endOffset;
    }

    @Override
    public E get(@Nonnegative int index) {
        this.checkBounds(index);
        return (E)this.backingArray[this.beginOffset + index];
    }

    @Override
    @Nonnull
    public Seq<E> reversed() {
        return new SeqReversedView(this.backingArray, this.beginOffset, this.endOffset);
    }

    @Override
    @Nonnull
    public Seq<E> sorted() {
        Object[] array = new Object[this.length()];
        System.arraycopy(this.backingArray, this.beginOffset, array, 0, this.length());
        Arrays.sort(array, NULL_ACCEPTING_COMPARATOR);
        return new SeqSimpleSorted(array);
    }

    @Override
    @Nonnull
    public Seq<E> sortedBy(@Nonnull Comparator<? super E> comparator) {
        Objects.requireNonNull(comparator);
        Object[] array = new Object[this.length()];
        System.arraycopy(this.backingArray, this.beginOffset, array, 0, this.length());
        Arrays.sort(array, comparator);
        return new SeqSimple(array);
    }

    @Override
    @Nonnull
    public Seq<E> trimmedToSize() {
        Object[] array = new Object[this.length()];
        System.arraycopy(this.backingArray, this.beginOffset, array, 0, this.length());
        return new SeqSimple(array);
    }

    @Override
    @Nonnull
    public Object[] toArray() {
        int len = this.length();
        Object[] array = new Object[len];
        System.arraycopy(this.backingArray, this.beginOffset, array, 0, len);
        return array;
    }

    @Override
    @Nonnull
    public Seq<E> subSequence(@Nonnegative int beginOffset, @Nonnegative int endOffset) {
        int begin = Math.max(0, beginOffset);
        int end = Math.min(this.length(), endOffset);
        int len = end - begin;
        if (len <= 0) {
            return SeqSimpleView.empty();
        }
        Object[] array = new Object[len];
        System.arraycopy(this.backingArray, this.beginOffset + begin, array, 0, len);
        return new SeqSimple(array);
    }

    @Override
    @Nonnull
    public Seq<E> subSequenceView(@Nonnegative int beginOffset, @Nonnegative int endOffset) {
        int begin = Math.max(0, beginOffset);
        int end = Math.min(this.length(), endOffset);
        int len = end - begin;
        if (len <= 0) {
            return SeqSimpleView.empty();
        }
        return new SeqSimpleView<E>(this.backingArray, this.beginOffset + begin, this.beginOffset + end);
    }

    @Override
    @Nonnull
    public E[] toArray(@Nonnull Class<E> evidence) {
        Objects.requireNonNull(evidence);
        int len = this.length();
        Object[] array = (Object[])Array.newInstance(evidence, len);
        System.arraycopy(this.backingArray, this.beginOffset, array, 0, len);
        return array;
    }

    @Override
    @Nonnegative
    public int length() {
        return this.endOffset - this.beginOffset;
    }
}

