/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import de.scravy.bedrock.Container;
import de.scravy.bedrock.Seq;
import de.scravy.bedrock.SeqSimpleSorted;
import de.scravy.bedrock.SetBuilder;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.SortedSet;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import lombok.Generated;

@Immutable
public final class Set<E extends Comparable<? super E>>
implements Serializable,
Container<E> {
    private final SeqSimpleSorted<E> underlying;
    private static final Set EMPTY = new Set(null);

    private Set(SeqSimpleSorted<E> underlying) {
        this.underlying = underlying;
    }

    @Override
    public boolean contains(E element) {
        return this.underlying != null && this.underlying.contains(element);
    }

    public boolean containsAll(Iterable<E> iterable) {
        Objects.requireNonNull(iterable, "'iterable' must not be null");
        if (this.underlying == null) {
            return !iterable.iterator().hasNext();
        }
        for (Comparable e : iterable) {
            if (this.underlying.contains(e)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAny(Iterable<E> iterable) {
        Objects.requireNonNull(iterable, "'iterable' must not be null");
        if (this.underlying == null) {
            return false;
        }
        for (Comparable e : iterable) {
            if (!this.underlying.contains(e)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean forAll(@Nonnull Predicate<? super E> predicate) {
        return this.underlying == null || this.underlying.forAll(predicate);
    }

    @Override
    public boolean exists(@Nonnull Predicate<? super E> predicate) {
        return this.underlying != null && this.underlying.exists(predicate);
    }

    @Override
    public E draw(@Nonnull Random random) throws NoSuchElementException {
        if (this.underlying == null) {
            throw new NoSuchElementException("drawing from an empty set");
        }
        int ix = random.nextInt(this.size());
        return (E)((Comparable)this.underlying.get(ix));
    }

    @Nonnull
    public <F extends E> Set<F> filter(@Nonnull Class<F> clazz) {
        if (this.underlying == null) {
            return Set.empty();
        }
        Set<Comparable> set = this.filter((E element) -> element != null && clazz.isAssignableFrom(element.getClass()));
        return set;
    }

    public Set<E> filter(@Nonnull Predicate<E> predicate) {
        Objects.requireNonNull(predicate, "'predicate' must not be null");
        if (this.isEmpty()) {
            return Set.empty();
        }
        return Set.ofSeqInternal(this.underlying.filter(predicate));
    }

    public Set<E> filterNot(@Nonnull Predicate<E> predicate) {
        Objects.requireNonNull(predicate, "'predicate' must not be null");
        return this.filter(predicate.negate());
    }

    public Set<E> union(Set<E> other) {
        Objects.requireNonNull(other, "'other' must not be null");
        if (other.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return other;
        }
        return Set.ofSeqInternal(this.underlying.union(other.underlying));
    }

    public Set<E> intersect(Set<E> other) {
        Objects.requireNonNull(other, "'other' must not be null");
        if (this.isEmpty() || other.isEmpty()) {
            return Set.empty();
        }
        return Set.ofSeqInternal(this.underlying.intersect(other.underlying));
    }

    public Set<E> without(Set<E> other) {
        Objects.requireNonNull(other, "'other' must not be null");
        if (this.isEmpty() || other.isEmpty()) {
            return this;
        }
        return Set.ofSeqInternal(this.underlying.without(other.underlying));
    }

    public <F extends Comparable<? super F>> Set<F> transform(Function<E, F> f) {
        return (Set)this.stream().map(f).collect(Set.builder());
    }

    public E maximum() {
        return (E)((Comparable)this.toSeq().lastOptional().orElseThrow(NoSuchElementException::new));
    }

    public E minimum() {
        return (E)((Comparable)this.toSeq().headOptional().orElseThrow(NoSuchElementException::new));
    }

    @Nonnull
    public Optional<E> maximumOptional() {
        return this.toSeq().lastOptional();
    }

    @Nonnull
    public Optional<E> minimumOptional() {
        return this.toSeq().headOptional();
    }

    @Override
    public boolean isEmpty() {
        return this.underlying == null;
    }

    @Override
    @Nonnull
    public String asString(@Nonnull String delimiter) {
        return this.underlying == null ? "" : this.underlying.asString(delimiter);
    }

    public int size() {
        return this.underlying == null ? 0 : this.underlying.size();
    }

    @Nonnull
    public Seq<E> toSeq() {
        return this.underlying == null ? Seq.empty() : this.underlying;
    }

    @Override
    @Nonnull
    public List<E> toList() {
        return this.underlying == null ? Collections.emptyList() : this.underlying.toList();
    }

    @Nonnull
    public java.util.Set<E> toSet() {
        return new AbstractSet<E>(){

            @Override
            @Nonnull
            public Iterator<E> iterator() {
                return Set.this.iterator();
            }

            @Override
            public int size() {
                return Set.this.size();
            }
        };
    }

    @Nonnull
    private static <E extends Comparable<? super E>> Set<E> ofSeqInternal(Seq<E> seq) {
        if (seq.isEmpty()) {
            return Set.empty();
        }
        SeqSimpleSorted seqSimpleSorted = seq instanceof SeqSimpleSorted ? (SeqSimpleSorted)seq : (SeqSimpleSorted)((Seq)seq.sorted()).distinct();
        return new Set<E>(seqSimpleSorted);
    }

    @SafeVarargs
    @Nonnull
    public static <E extends Comparable<? super E>> Set<E> of(E ... elements) {
        return Set.ofSeqInternal(Seq.ofArray(elements));
    }

    @SafeVarargs
    @Nonnull
    public static <E extends Comparable<? super E>> Set<E> set(E ... elements) {
        return Set.ofSeqInternal(Seq.ofArray(elements));
    }

    @Nonnull
    public static <E extends Comparable<? super E>> Set<E> ofSeq(@Nonnull Seq<E> elements) {
        return Set.ofSeqInternal(elements.distinct());
    }

    @Nonnull
    public static <E extends Comparable<? super E>> Set<E> ofIterable(@Nonnull Iterable<E> elements) {
        if (elements instanceof Collection) {
            return Set.ofCollection((Collection)elements);
        }
        return Set.ofSeqInternal(Seq.ofIterable(elements).distinct());
    }

    @Nonnull
    public static <E extends Comparable<? super E>> Set<E> ofIterator(@Nonnull Iterator<E> elements) {
        SetBuilder<E> b = Set.builder();
        elements.forEachRemaining(b::add);
        return b.result();
    }

    @Nonnull
    public static <E extends Comparable<? super E>> Set<E> ofCollection(@Nonnull Collection<E> elements) {
        if (elements.isEmpty()) {
            return Set.empty();
        }
        if (elements instanceof SortedSet) {
            return Set.ofSortedSet((SortedSet)elements);
        }
        return Set.ofSeqInternal(Seq.ofCollection(elements).distinct());
    }

    @Nonnull
    public static <E extends Comparable<? super E>> Set<E> ofSortedSet(@Nonnull SortedSet<E> elements) {
        return Set.ofSeqInternal(new SeqSimpleSorted(elements.toArray()));
    }

    @Nonnull
    public static <E extends Comparable<? super E>> SetBuilder<E> builder() {
        return new SetBuilder();
    }

    @Nonnull
    public static <E extends Comparable<? super E>> Set<E> empty() {
        return EMPTY;
    }

    @Override
    @Nonnull
    public Iterator<E> iterator() {
        return this.underlying == null ? Seq.empty().iterator() : this.underlying.iterator();
    }

    @Nonnull
    public String toString() {
        return this.underlying == null ? "\u2205" : '{' + this.underlying.asString(", ") + '}';
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Set)) {
            return false;
        }
        Set other = (Set)o;
        SeqSimpleSorted<E> this$underlying = this.underlying;
        SeqSimpleSorted<E> other$underlying = other.underlying;
        return !(this$underlying == null ? other$underlying != null : !((Object)this$underlying).equals(other$underlying));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SeqSimpleSorted<E> $underlying = this.underlying;
        result = result * 59 + ($underlying == null ? 43 : ((Object)$underlying).hashCode());
        return result;
    }
}

