/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import de.scravy.bedrock.Hash;
import de.scravy.bedrock.HashAlgorithm;
import java.security.MessageDigest;
import javax.annotation.Nonnull;

public class Sha256
extends Hash.Hash256<Sha256> {
    private static final String ALGORITHM = "SHA-256";

    private Sha256(byte[] digest) {
        super(digest);
    }

    @Nonnull
    public static HashAlgorithm<Sha256> singleHash() {
        return new HashAlgorithm<Sha256>(32, ALGORITHM, Sha256::new, MessageDigest::digest);
    }

    @Nonnull
    public static HashAlgorithm<Sha256> doubleHash() {
        return new HashAlgorithm<Sha256>(32, ALGORITHM, Sha256::new, md -> md.digest(md.digest()));
    }

    public static boolean isSupported() {
        try {
            Sha256.singleHash().empty();
            return true;
        }
        catch (AssertionError exc) {
            return false;
        }
    }
}

