/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import de.scravy.bedrock.Hash;
import de.scravy.bedrock.HashAlgorithm;
import java.security.MessageDigest;
import javax.annotation.Nonnull;

public class Sha512
extends Hash.Hash512<Sha512> {
    private static final String ALGORITHM = "SHA-512";

    private Sha512(byte[] digest) {
        super(digest);
    }

    @Nonnull
    public static HashAlgorithm<Sha512> singleHash() {
        return new HashAlgorithm<Sha512>(64, ALGORITHM, Sha512::new, MessageDigest::digest);
    }

    @Nonnull
    public static HashAlgorithm<Sha512> doubleHash() {
        return new HashAlgorithm<Sha512>(64, ALGORITHM, Sha512::new, md -> md.digest(md.digest()));
    }

    public static boolean isSupported() {
        try {
            Sha512.singleHash().empty();
            return true;
        }
        catch (AssertionError exc) {
            return false;
        }
    }
}

