/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.function.IntConsumer;
import javax.annotation.Nullable;
import lombok.Generated;

public class SimpleDirectedGraph {
    final int numberOfVertices;
    final int numberOfEdges;
    private final int[][] outgoingEdges;
    private int[][] incomingEdges;

    SimpleDirectedGraph(int numberOfVertices, int numberOfEdges, int[][] outgoingEdges, @Nullable int[][] incomingEdges) {
        this.numberOfVertices = numberOfVertices;
        this.numberOfEdges = numberOfEdges;
        this.outgoingEdges = outgoingEdges;
        this.incomingEdges = incomingEdges;
    }

    public final void forEachOutgoing(int index, IntConsumer consumer) {
        int[] outgoing;
        for (int value : outgoing = this.outgoingEdges[index]) {
            consumer.accept(value);
        }
    }

    public final int countOutgoing(int index) {
        return this.outgoingEdges[index].length;
    }

    public final boolean hasOutgoing(int index) {
        return this.countIncoming(index) > 0;
    }

    public final void forEachIncoming(int index, IntConsumer consumer) {
        int[] incoming;
        this.checkIncoming();
        for (int value : incoming = this.incomingEdges[index]) {
            consumer.accept(value);
        }
    }

    public final int countIncoming(int index) {
        this.checkIncoming();
        return this.incomingEdges[index].length;
    }

    public final boolean hasIncoming(int index) {
        return this.countIncoming(index) > 0;
    }

    private void checkIncoming() {
        if (this.incomingEdges == null) {
            this.incomingEdges = this.calculateIncoming();
        }
    }

    private int[][] calculateIncoming() {
        HashMap<Integer, TreeSet> incomingEdgesMap = new HashMap<Integer, TreeSet>();
        for (int i = 0; i < this.numberOfVertices; ++i) {
            incomingEdgesMap.put(i, new TreeSet());
        }
        for (int from = 0; from < this.outgoingEdges.length; ++from) {
            int[] out;
            for (int to2 : out = this.outgoingEdges[from]) {
                ((TreeSet)incomingEdgesMap.get(to2)).add(from);
            }
        }
        int[][] incomingEdges = new int[this.numberOfVertices][];
        incomingEdgesMap.forEach((to, froms) -> {
            int[] in = new int[froms.size()];
            int i = 0;
            Iterator iterator = ((TreeSet)incomingEdgesMap.get(to)).iterator();
            while (iterator.hasNext()) {
                int from = (Integer)iterator.next();
                in[i++] = from;
            }
            incomingEdges[to.intValue()] = in;
        });
        return incomingEdges;
    }

    @Generated
    public int getNumberOfVertices() {
        return this.numberOfVertices;
    }

    @Generated
    public int getNumberOfEdges() {
        return this.numberOfEdges;
    }
}

