/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock;

import de.scravy.bedrock.Promise;
import de.scravy.bedrock.ThrowingConsumer;
import de.scravy.bedrock.ThrowingFunction;
import de.scravy.bedrock.ThrowingRunnable;
import de.scravy.bedrock.ValueDidNotSatisfyPredicateException;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import lombok.Generated;

@Immutable
public abstract class Try<E>
implements Iterable<E> {
    public boolean isSuccess() {
        return false;
    }

    public boolean isFailure() {
        return false;
    }

    @Nonnull
    public abstract <F> Try<F> map(@Nonnull ThrowingFunction<? super E, ? extends F> var1);

    @Nonnull
    public abstract <F> Try<F> flatMap(@Nonnull ThrowingFunction<? super E, Try<F>> var1);

    @Nonnull
    public final <F> Try<F> flatMapOptional(@Nonnull ThrowingFunction<? super E, Optional<F>> function) {
        Objects.requireNonNull(function, "'function' must not be null");
        return this.flatMap(value -> {
            Try<Optional> result = Try.execute(() -> (Optional)function.apply((Object)value));
            return result.flatMap(res -> res.map(Try::success).orElseGet(() -> Try.failure(new NoSuchElementException())));
        });
    }

    @Nonnull
    public abstract Try<E> filter(@Nonnull Predicate<? super E> var1);

    @Nonnull
    public abstract <F> Try<F> recover(@Nonnull ThrowingFunction<Exception, F> var1);

    @Nonnull
    public abstract <F> Try<F> recoverWith(@Nonnull ThrowingFunction<Exception, Try<F>> var1);

    public abstract E orElse(E var1);

    public abstract E orElseDo(ThrowingConsumer<Exception> var1);

    public abstract E orElseGet(@Nonnull Supplier<? extends E> var1);

    @Nullable
    public abstract E orElseNull();

    public abstract E orElseThrow() throws RethrownException;

    public abstract E orElseThrowRuntime();

    public abstract E get();

    public abstract Throwable getException();

    @Nonnull
    public abstract Try<E> otherwise(@Nonnull Try<E> var1);

    @Nonnull
    public abstract <F> Try<F> transform(@Nonnull ThrowingFunction<Exception, F> var1, ThrowingFunction<E, F> var2);

    @Nonnull
    public abstract <F> Try<F> transformWith(@Nonnull ThrowingFunction<Exception, Try<F>> var1, ThrowingFunction<E, Try<F>> var2);

    @Nonnull
    public abstract Try<E> fallback(E var1);

    @Nonnull
    public abstract Try<E> fallbackWith(@Nonnull Supplier<E> var1);

    public abstract <F> F fold(@Nonnull ThrowingFunction<? super Exception, F> var1, @Nonnull ThrowingFunction<E, F> var2);

    public abstract void consume(@Nonnull ThrowingConsumer<? super Exception> var1, @Nonnull ThrowingConsumer<E> var2);

    @Nonnull
    public abstract Optional<E> toOptional();

    @Nonnull
    public abstract Promise<E> toPromise();

    public static <E> Try<E> fromOptional(Optional<E> optional) {
        return optional.map(Try::success).orElseGet(() -> Try.failure(new NoSuchElementException()));
    }

    @Nonnull
    public static <E> Try<E> success(E element) {
        return new Success<E>(element);
    }

    @Nonnull
    public static <E> Try<E> failure(@Nonnull Exception exception) {
        Objects.requireNonNull(exception, "exception must not be null");
        return new Failure(exception);
    }

    @Nonnull
    public static <E> Try<E> execute(@Nonnull Callable<E> callable) {
        Objects.requireNonNull(callable, "callable must not be null");
        try {
            return Try.success(callable.call());
        }
        catch (Exception exc) {
            return Try.failure(exc);
        }
    }

    public static void run(@Nonnull ThrowingRunnable runnable) {
        Objects.requireNonNull(runnable, "runnable must not be null");
        try {
            runnable.run();
        }
        catch (RuntimeException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }

    public static void run(@Nonnull String message, @Nonnull ThrowingRunnable runnable) {
        Objects.requireNonNull(message, "message must not be null");
        Objects.requireNonNull(runnable, "runnable must not be null");
        try {
            runnable.run();
        }
        catch (Exception exc) {
            throw new RuntimeException(message, exc);
        }
    }

    public static void unfailable(@Nonnull ThrowingRunnable runnable) {
        try {
            runnable.run();
        }
        catch (Exception exc) {
            Optional.ofNullable(Thread.currentThread().getUncaughtExceptionHandler()).ifPresent(ueh -> ueh.uncaughtException(Thread.currentThread(), exc));
        }
    }

    @Nonnull
    public static <A, R> Function<A, Try<R>> lift(@Nonnull Function<A, R> function) {
        Objects.requireNonNull(function, "'function' must not be null");
        return arg -> Try.execute(() -> function.apply(arg));
    }

    @Generated
    private Try() {
    }

    @Immutable
    public static final class Success<E>
    extends Try<E> {
        private final E value;

        Success(E value) {
            this.value = value;
        }

        @Override
        public final boolean isSuccess() {
            return true;
        }

        @Override
        @Nonnull
        public <F> Try<F> map(@Nonnull ThrowingFunction<? super E, ? extends F> function) {
            Objects.requireNonNull(function, "function must not be null");
            try {
                return Success.success(function.execute(this.value));
            }
            catch (Exception exc) {
                return Success.failure(exc);
            }
        }

        @Override
        @Nonnull
        public <F> Try<F> flatMap(@Nonnull ThrowingFunction<? super E, Try<F>> function) {
            Objects.requireNonNull(function, "function must not be null");
            try {
                return function.execute(this.value);
            }
            catch (Exception exc) {
                return Success.failure(exc);
            }
        }

        @Override
        @Nonnull
        public Try<E> filter(@Nonnull Predicate<? super E> predicate) {
            Objects.requireNonNull(predicate, "predicate must not be null");
            if (predicate.test(this.value)) {
                return this;
            }
            return Success.failure(new ValueDidNotSatisfyPredicateException(predicate, this.value));
        }

        @Override
        @Nonnull
        public <F> Try<F> recover(@Nonnull ThrowingFunction<Exception, F> exceptionTransformer) {
            Objects.requireNonNull(exceptionTransformer, "exceptionTransformer must not be null");
            return this;
        }

        @Override
        @Nonnull
        public <F> Try<F> recoverWith(@Nonnull ThrowingFunction<Exception, Try<F>> exceptionTransformer) {
            Objects.requireNonNull(exceptionTransformer, "exceptionTransformer must not be null");
            return this;
        }

        @Override
        public E orElse(E value) {
            return this.value;
        }

        @Override
        public E orElseDo(ThrowingConsumer<Exception> block) {
            return this.value;
        }

        @Override
        public E orElseGet(@Nonnull Supplier<? extends E> supplier) {
            Objects.requireNonNull(supplier, "supplier must not be null");
            return this.value;
        }

        @Override
        public E orElseNull() {
            return this.value;
        }

        @Override
        public E orElseThrow() {
            return this.value;
        }

        @Override
        public E orElseThrowRuntime() {
            return this.value;
        }

        @Override
        public E get() {
            return this.value;
        }

        @Override
        public Throwable getException() {
            return null;
        }

        @Override
        @Nonnull
        public Try<E> otherwise(@Nonnull Try<E> alternative) {
            Objects.requireNonNull(alternative, "alternative must not be null");
            return this;
        }

        @Override
        @Nonnull
        public <F> Try<F> transform(@Nonnull ThrowingFunction<Exception, F> f, ThrowingFunction<E, F> g) {
            Objects.requireNonNull(f, "f must not be null");
            Objects.requireNonNull(g, "g must not be null");
            try {
                return Success.success(g.execute(this.value));
            }
            catch (Exception exc) {
                return Success.failure(exc);
            }
        }

        @Override
        @Nonnull
        public <F> Try<F> transformWith(@Nonnull ThrowingFunction<Exception, Try<F>> f, ThrowingFunction<E, Try<F>> g) {
            Objects.requireNonNull(f, "f must not be null");
            Objects.requireNonNull(g, "g must not be null");
            try {
                return g.execute(this.value);
            }
            catch (Exception exc) {
                return Success.failure(exc);
            }
        }

        @Override
        @Nonnull
        public Optional<E> toOptional() {
            return Optional.ofNullable(this.value);
        }

        @Override
        @Nonnull
        public Promise<E> toPromise() {
            return Promise.fulfilled(this.value);
        }

        @Override
        @Nonnull
        public Try<E> fallback(E value) {
            return this;
        }

        @Override
        @Nonnull
        public Try<E> fallbackWith(@Nonnull Supplier<E> value) {
            return this;
        }

        @Override
        public <F> F fold(@Nonnull ThrowingFunction<? super Exception, F> ifFailure, @Nonnull ThrowingFunction<E, F> ifSuccess) {
            Objects.requireNonNull(ifFailure, "'ifFailure' must not be null");
            Objects.requireNonNull(ifSuccess, "'ifSuccess' must not be null");
            return ifSuccess.apply(this.value);
        }

        @Override
        public void consume(@Nonnull ThrowingConsumer<? super Exception> ifFailure, @Nonnull ThrowingConsumer<E> ifSuccess) {
            Objects.requireNonNull(ifFailure, "'ifFailure' must not be null");
            Objects.requireNonNull(ifSuccess, "'ifSuccess' must not be null");
            ifSuccess.accept(this.value);
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator<E>(){
                private boolean consumed = false;

                @Override
                public boolean hasNext() {
                    return !this.consumed;
                }

                @Override
                public E next() {
                    try {
                        Object object = value;
                        return object;
                    }
                    finally {
                        this.consumed = true;
                    }
                }
            };
        }

        @Generated
        public E getValue() {
            return this.value;
        }

        @Generated
        public String toString() {
            return "Try.Success(value=" + this.getValue() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Success)) {
                return false;
            }
            Success other = (Success)o;
            if (!other.canEqual(this)) {
                return false;
            }
            E this$value = this.getValue();
            E other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Success;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            E $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }
    }

    @Immutable
    public static final class Failure<E>
    extends Try<E> {
        private final Exception exception;

        Failure(@Nonnull Exception exception) {
            this.exception = exception;
        }

        @Override
        public final boolean isFailure() {
            return true;
        }

        @Override
        @Nonnull
        public <F> Try<F> map(@Nonnull ThrowingFunction<? super E, ? extends F> f) {
            Objects.requireNonNull(f, "f must not be null");
            return this;
        }

        @Override
        @Nonnull
        public <F> Try<F> flatMap(@Nonnull ThrowingFunction<? super E, Try<F>> f) {
            Objects.requireNonNull(f, "f must not be null");
            return this;
        }

        @Override
        @Nonnull
        public Try<E> filter(@Nonnull Predicate<? super E> predicate) {
            Objects.requireNonNull(predicate, "predicate must not be null");
            return this;
        }

        @Override
        @Nonnull
        public <F> Try<F> recover(@Nonnull ThrowingFunction<Exception, F> f) {
            Objects.requireNonNull(f, "f must not be null");
            try {
                return Failure.success(f.execute(this.exception));
            }
            catch (Exception exc) {
                return Failure.failure(new FailedRecoveringException(this.exception, exc));
            }
        }

        @Override
        @Nonnull
        public <F> Try<F> recoverWith(@Nonnull ThrowingFunction<Exception, Try<F>> f) {
            Objects.requireNonNull(f, "f must not be null");
            try {
                return f.execute(this.exception);
            }
            catch (Exception exc) {
                return Failure.failure(new FailedRecoveringException(this.exception, exc));
            }
        }

        @Override
        public E orElse(E value) {
            return value;
        }

        @Override
        public E orElseDo(@Nonnull ThrowingConsumer<Exception> block) {
            block.accept(this.exception);
            throw new RuntimeException(this.exception);
        }

        @Override
        public E orElseGet(@Nonnull Supplier<? extends E> supplier) {
            Objects.requireNonNull(supplier, "supplier must not be null");
            return supplier.get();
        }

        @Override
        @Nullable
        public E orElseNull() {
            return null;
        }

        @Override
        public E orElseThrow() throws RethrownException {
            throw new RethrownException(this.exception);
        }

        @Override
        public E orElseThrowRuntime() {
            throw new RuntimeException(this.exception);
        }

        @Override
        public E get() {
            throw new NoSuchElementException();
        }

        @Override
        @Nonnull
        public Try<E> otherwise(@Nonnull Try<E> alternative) {
            Objects.requireNonNull(alternative, "alternative must not be null");
            return alternative;
        }

        @Override
        @Nonnull
        public <F> Try<F> transform(@Nonnull ThrowingFunction<Exception, F> f, @Nonnull ThrowingFunction<E, F> g) {
            Objects.requireNonNull(f, "f must not be null");
            Objects.requireNonNull(g, "g must not be null");
            try {
                return Failure.success(f.execute(this.exception));
            }
            catch (Exception exc) {
                return Failure.failure(new FailedRecoveringException(this.exception, exc));
            }
        }

        @Override
        @Nonnull
        public <F> Try<F> transformWith(@Nonnull ThrowingFunction<Exception, Try<F>> f, @Nonnull ThrowingFunction<E, Try<F>> g) {
            Objects.requireNonNull(f, "f must not be null");
            Objects.requireNonNull(g, "g must not be null");
            try {
                return f.execute(this.exception);
            }
            catch (Exception exc) {
                return Failure.failure(new FailedRecoveringException(this.exception, exc));
            }
        }

        @Override
        @Nonnull
        public Optional<E> toOptional() {
            return Optional.empty();
        }

        @Override
        @Nonnull
        public Promise<E> toPromise() {
            return Promise.failed(this.exception);
        }

        @Override
        @Nonnull
        public Try<E> fallback(E value) {
            return Failure.success(value);
        }

        @Override
        @Nonnull
        public Try<E> fallbackWith(@Nonnull Supplier<E> value) {
            try {
                return Failure.success(value.get());
            }
            catch (Exception exc) {
                return Failure.failure(exc);
            }
        }

        @Override
        public <F> F fold(@Nonnull ThrowingFunction<? super Exception, F> ifFailure, @Nonnull ThrowingFunction<E, F> ifSuccess) {
            Objects.requireNonNull(ifFailure, "'ifFailure' must not be null");
            Objects.requireNonNull(ifSuccess, "'ifSuccess' must not be null");
            return ifFailure.apply(this.exception);
        }

        @Override
        public void consume(@Nonnull ThrowingConsumer<? super Exception> ifFailure, @Nonnull ThrowingConsumer<E> ifSuccess) {
            Objects.requireNonNull(ifFailure, "'ifFailure' must not be null");
            Objects.requireNonNull(ifSuccess, "'ifSuccess' must not be null");
            ifFailure.accept(this.exception);
        }

        @Override
        public Iterator<E> iterator() {
            return Collections.emptyIterator();
        }

        @Override
        @Generated
        public Exception getException() {
            return this.exception;
        }

        @Generated
        public String toString() {
            return "Try.Failure(exception=" + this.getException() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Failure)) {
                return false;
            }
            Failure other = (Failure)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Exception this$exception = this.getException();
            Exception other$exception = other.getException();
            return !(this$exception == null ? other$exception != null : !this$exception.equals(other$exception));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Failure;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Exception $exception = this.getException();
            result = result * 59 + ($exception == null ? 43 : $exception.hashCode());
            return result;
        }
    }

    public static class FailedRecoveringException
    extends Exception {
        private final Exception originalException;

        public FailedRecoveringException(@Nonnull Exception originalException, @Nonnull Exception exc) {
            super(exc);
            this.originalException = originalException;
        }

        @Generated
        public Exception getOriginalException() {
            return this.originalException;
        }
    }

    public static class RethrownException
    extends Exception {
        public RethrownException(Exception cause) {
            super(cause);
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RethrownException)) {
                return false;
            }
            RethrownException other = (RethrownException)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return super.equals(o);
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RethrownException;
        }

        @Generated
        public int hashCode() {
            int result = super.hashCode();
            return result;
        }
    }
}

