/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock.hlist;

import de.scravy.bedrock.hlist.HList;
import de.scravy.bedrock.hlist.Nil;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import lombok.Generated;

public final class C<E, L extends HList<L>>
extends HList<C<E, L>> {
    private final E head;
    private final L tail;

    @Override
    public int size() {
        return 1 + ((HList)this.tail).size();
    }

    @Override
    public <T> T foldl(@Nonnull BiFunction<T, Object, T> f, T init) {
        return ((HList)this.tail).foldl(f, f.apply(init, this.head));
    }

    @Override
    public <T> T foldr(@Nonnull BiFunction<Object, T, T> f, T init) {
        return f.apply(this.head, ((HList)this.tail).foldr(f, init));
    }

    @Override
    C<E, L> mask(@Nonnegative int index, @Nonnull HList.ForEachWithIndexPredicate predicate) {
        C<Object, L> thiz = predicate.test(index, this.head) ? this : this.withHead(null);
        return thiz.withTail((HList)((HList)this.tail).mask(index + 1, predicate));
    }

    @Override
    @Nonnull
    public Iterator<Object> iterator() {
        return new Iterator<Object>(){
            HList current;
            {
                this.current = C.this;
            }

            @Override
            public boolean hasNext() {
                return this.current != Nil.INSTANCE;
            }

            @Override
            public Object next() {
                C xs = (C)this.current;
                this.current = xs.tail;
                return xs.head;
            }
        };
    }

    @Nonnull
    public <F> C<F, C<E, L>> cons(F elem) {
        return new C<F, C>(elem, this);
    }

    @Nonnull
    public <F> C<F, L> withHead(F head) {
        if (head == this.head) {
            C thiz = this;
            return thiz;
        }
        return new C<F, L>(head, this.tail);
    }

    @Nonnull
    public <M extends HList<M>> C<E, M> withTail(M tail) {
        if (tail == this.tail) {
            C thiz = this;
            return thiz;
        }
        return new C<E, M>(this.head, tail);
    }

    public String toString() {
        return this.stream().map(Objects::toString).collect(Collectors.joining(",", "[", "]"));
    }

    @Override
    public int compareTo(@Nonnull C<E, L> that) {
        int headComparison = Objects.compare(this.getHead(), that.getHead(), Comparator.nullsFirst((l, r) -> {
            int result = ((Comparable)l).compareTo(r);
            return result;
        }));
        if (headComparison != 0) {
            return headComparison;
        }
        return this.getTail().compareTo(that.getTail());
    }

    @Generated
    public E getHead() {
        return this.head;
    }

    @Generated
    public L getTail() {
        return this.tail;
    }

    @Generated
    C(E head, L tail) {
        this.head = head;
        this.tail = tail;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof C)) {
            return false;
        }
        C other = (C)o;
        if (!other.canEqual(this)) {
            return false;
        }
        E this$head = this.getHead();
        E other$head = other.getHead();
        if (this$head == null ? other$head != null : !this$head.equals(other$head)) {
            return false;
        }
        L this$tail = this.getTail();
        L other$tail = other.getTail();
        return !(this$tail == null ? other$tail != null : !this$tail.equals(other$tail));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof C;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        E $head = this.getHead();
        result = result * 59 + ($head == null ? 43 : $head.hashCode());
        L $tail = this.getTail();
        result = result * 59 + ($tail == null ? 43 : $tail.hashCode());
        return result;
    }
}

