/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.bedrock.hlist;

import de.scravy.bedrock.Container;
import de.scravy.bedrock.hlist.C;
import de.scravy.bedrock.hlist.Nil;
import java.util.Objects;
import java.util.function.BiFunction;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import lombok.Generated;

public abstract class HList<This extends HList<This>>
implements Container<Object>,
Comparable<This> {
    @Nonnull
    public static Nil empty() {
        return Nil.INSTANCE;
    }

    @Nonnull
    public static Nil nil() {
        return HList.empty();
    }

    @Nonnull
    public static <E, L extends HList<L>> C<E, L> cons(E head, L tail) {
        return new C<E, L>(head, Objects.requireNonNull(tail, "'tail' must not be null"));
    }

    @Nonnull
    public static <E> C<E, Nil> hlist(E e) {
        return HList.cons(e, HList.empty());
    }

    @Nonnull
    public static <E, F> C<E, C<F, Nil>> hlist(E e, F f) {
        return HList.cons(e, HList.hlist(f));
    }

    @Nonnull
    public static <E, F, G> C<E, C<F, C<G, Nil>>> hlist(E e, F f, G g) {
        return HList.cons(e, HList.hlist(f, g));
    }

    @Nonnull
    public static <E, F, G, H> C<E, C<F, C<G, C<H, Nil>>>> hlist(E e, F f, G g, H h) {
        return HList.cons(e, HList.hlist(f, g, h));
    }

    @Nonnull
    public static <E, F, G, H, I> C<E, C<F, C<G, C<H, C<I, Nil>>>>> hlist(E e, F f, G g, H h, I i) {
        return HList.cons(e, HList.hlist(f, g, h, i));
    }

    @Nonnull
    public static <E, F, G, H, I, J> C<E, C<F, C<G, C<H, C<I, C<J, Nil>>>>>> hlist(E e, F f, G g, H h, I i, J j) {
        return HList.cons(e, HList.hlist(f, g, h, i, j));
    }

    @Nonnull
    public static <E, F, G, H, I, J, K> C<E, C<F, C<G, C<H, C<I, C<J, C<K, Nil>>>>>>> hlist(E e, F f, G g, H h, I i, J j, K k) {
        return HList.cons(e, HList.hlist(f, g, h, i, j, k));
    }

    @Nonnull
    public static <E, F, G, H, I, J, K, L> C<E, C<F, C<G, C<H, C<I, C<J, C<K, C<L, Nil>>>>>>>> hlist(E e, F f, G g, H h, I i, J j, K k, L l) {
        return HList.cons(e, HList.hlist(f, g, h, i, j, k, l));
    }

    @Nonnull
    public static <E, F, G, H, I, J, K, L, M> C<E, C<F, C<G, C<H, C<I, C<J, C<K, C<L, C<M, Nil>>>>>>>>> hlist(E e, F f, G g, H h, I i, J j, K k, L l, M m) {
        return HList.cons(e, HList.hlist(f, g, h, i, j, k, l, m));
    }

    @Nonnull
    public static <E, F, G, H, I, J, K, L, M, N> C<E, C<F, C<G, C<H, C<I, C<J, C<K, C<L, C<M, C<N, Nil>>>>>>>>>> hlist(E e, F f, G g, H h, I i, J j, K k, L l, M m, N n) {
        return HList.cons(e, HList.hlist(f, g, h, i, j, k, l, m, n));
    }

    @Nonnull
    public static <E, F, G, H, I, J, K, L, M, N, O> C<E, C<F, C<G, C<H, C<I, C<J, C<K, C<L, C<M, C<N, C<O, Nil>>>>>>>>>>> hlist(E e, F f, G g, H h, I i, J j, K k, L l, M m, N n, O o) {
        return HList.cons(e, HList.hlist(f, g, h, i, j, k, l, m, n, o));
    }

    @Nonnegative
    public abstract int size();

    public abstract <T> T foldl(@Nonnull BiFunction<T, Object, T> var1, T var2);

    public abstract <T> T foldr(@Nonnull BiFunction<Object, T, T> var1, T var2);

    public static HList dynamic(Iterable<?> keys) {
        return HList.empty();
    }

    @Nonnull
    public This mask(@Nonnull ForEachWithIndexPredicate predicate) {
        return this.mask(0, predicate);
    }

    abstract This mask(@Nonnegative int var1, @Nonnull ForEachWithIndexPredicate var2);

    @Generated
    HList() {
    }

    @FunctionalInterface
    public static interface ForEachWithIndexPredicate {
        public boolean test(@Nonnegative int var1, Object var2);
    }
}

