/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.pair;

import de.scravy.pair.ComparablePair;
import de.scravy.pair.Pairs;
import java.beans.ConstructorProperties;

final class ImmutableComparablePair<First extends Comparable<? super First>, Second extends Comparable<? super Second>>
implements ComparablePair<First, Second>,
Comparable<ComparablePair<First, Second>> {
    private final First first;
    private final Second second;

    @Override
    public boolean equals(Object other) {
        return Pairs.equals(this, other);
    }

    public int hashCode() {
        return Pairs.hashCode(this);
    }

    @Override
    public int compareTo(ComparablePair<First, Second> other) {
        return Pairs.compare(this.first, this.second, (Comparable)other.getFirst(), (Comparable)other.getSecond());
    }

    @ConstructorProperties(value={"first", "second"})
    public ImmutableComparablePair(First first, Second second) {
        this.first = first;
        this.second = second;
    }

    @Override
    public First getFirst() {
        return this.first;
    }

    @Override
    public Second getSecond() {
        return this.second;
    }

    public String toString() {
        return "ImmutableComparablePair(first=" + this.getFirst() + ", second=" + this.getSecond() + ")";
    }

    public ImmutableComparablePair<First, Second> withFirst(First first) {
        return this.first == first ? this : new ImmutableComparablePair<First, Second>(first, this.second);
    }

    public ImmutableComparablePair<First, Second> withSecond(Second second) {
        return this.second == second ? this : new ImmutableComparablePair<First, Second>(this.first, second);
    }
}

