/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.pair;

import de.scravy.pair.ComparableSerializablePair;
import de.scravy.pair.Pairs;
import java.beans.ConstructorProperties;
import java.io.Serializable;

final class ImmutableComparableSerializablePair<First extends Serializable & Comparable<? super First>, Second extends Serializable & Comparable<? super Second>>
implements ComparableSerializablePair<First, Second>,
Comparable<ComparableSerializablePair<First, Second>>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final First first;
    private final Second second;

    @Override
    public boolean equals(Object other) {
        return Pairs.equals(this, other);
    }

    public int hashCode() {
        return Pairs.hashCode(this);
    }

    @Override
    public int compareTo(ComparableSerializablePair<First, Second> other) {
        return Pairs.compare((Comparable)this.first, (Comparable)this.second, (Comparable)other.getFirst(), (Comparable)other.getSecond());
    }

    @ConstructorProperties(value={"first", "second"})
    public ImmutableComparableSerializablePair(First first, Second second) {
        this.first = first;
        this.second = second;
    }

    @Override
    public First getFirst() {
        return this.first;
    }

    @Override
    public Second getSecond() {
        return this.second;
    }

    public String toString() {
        return "ImmutableComparableSerializablePair(first=" + this.getFirst() + ", second=" + this.getSecond() + ")";
    }

    public ImmutableComparableSerializablePair<First, Second> withFirst(First first) {
        return this.first == first ? this : new ImmutableComparableSerializablePair<First, Second>(first, this.second);
    }

    public ImmutableComparableSerializablePair<First, Second> withSecond(Second second) {
        return this.second == second ? this : new ImmutableComparableSerializablePair<First, Second>(this.first, second);
    }
}

