/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.pair;

import de.scravy.pair.Pair;
import de.scravy.pair.Pairs;
import java.beans.ConstructorProperties;

final class ImmutablePair<First, Second>
implements Pair<First, Second> {
    private final First first;
    private final Second second;

    @Override
    public boolean equals(Object other) {
        return Pairs.equals(this, other);
    }

    public int hashCode() {
        return Pairs.hashCode(this);
    }

    @ConstructorProperties(value={"first", "second"})
    public ImmutablePair(First first, Second second) {
        this.first = first;
        this.second = second;
    }

    @Override
    public First getFirst() {
        return this.first;
    }

    @Override
    public Second getSecond() {
        return this.second;
    }

    public String toString() {
        return "ImmutablePair(first=" + this.getFirst() + ", second=" + this.getSecond() + ")";
    }

    public ImmutablePair<First, Second> withFirst(First first) {
        return this.first == first ? this : new ImmutablePair<First, Second>(first, this.second);
    }

    public ImmutablePair<First, Second> withSecond(Second second) {
        return this.second == second ? this : new ImmutablePair<First, Second>(this.first, second);
    }
}

