/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.pair;

import de.scravy.pair.Pairs;
import de.scravy.pair.SerializablePair;
import java.beans.ConstructorProperties;
import java.io.Serializable;

final class ImmutableSerializablePair<First extends Serializable, Second extends Serializable>
implements SerializablePair<First, Second>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final First first;
    private final Second second;

    @Override
    public boolean equals(Object other) {
        return Pairs.equals(this, other);
    }

    public int hashCode() {
        return Pairs.hashCode(this);
    }

    @ConstructorProperties(value={"first", "second"})
    public ImmutableSerializablePair(First first, Second second) {
        this.first = first;
        this.second = second;
    }

    @Override
    public First getFirst() {
        return this.first;
    }

    @Override
    public Second getSecond() {
        return this.second;
    }

    public String toString() {
        return "ImmutableSerializablePair(first=" + this.getFirst() + ", second=" + this.getSecond() + ")";
    }

    public ImmutableSerializablePair<First, Second> withFirst(First first) {
        return this.first == first ? this : new ImmutableSerializablePair<First, Second>(first, this.second);
    }

    public ImmutableSerializablePair<First, Second> withSecond(Second second) {
        return this.second == second ? this : new ImmutableSerializablePair<First, Second>(this.first, second);
    }
}

