/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.pair;

import de.scravy.pair.ComparablePair;
import de.scravy.pair.ComparableSerializablePair;
import de.scravy.pair.ImmutableComparablePair;
import de.scravy.pair.ImmutableComparableSerializablePair;
import de.scravy.pair.ImmutablePair;
import de.scravy.pair.ImmutableSerializablePair;
import de.scravy.pair.Pair;
import de.scravy.pair.SerializablePair;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Map;
import java.util.Objects;

public final class Pairs {
    public static <First, Second> Pair<First, Second> from(First first, Second second) {
        return new ImmutablePair<First, Second>(first, second);
    }

    public static <First extends Comparable<? super First>, Second extends Comparable<? super Second>> ComparablePair<First, Second> fromComparables(First first, Second second) {
        return new ImmutableComparablePair<First, Second>(first, second);
    }

    public static <First extends Serializable, Second extends Serializable> SerializablePair<First, Second> fromSerializables(First first, Second second) {
        return new ImmutableSerializablePair<First, Second>(first, second);
    }

    public static <First extends Serializable & Comparable<? super First>, Second extends Serializable & Comparable<? super Second>> ComparableSerializablePair<First, Second> fromComparableSerializables(First first, Second second) {
        return new ImmutableComparableSerializablePair<First, Second>(first, second);
    }

    public static <CommonSuperType, First extends CommonSuperType, Second extends CommonSuperType> CommonSuperType[] toArray(Pair<First, Second> pair, Class<CommonSuperType> commonSuperType) {
        Object[] array = (Object[])Array.newInstance(commonSuperType, 2);
        return Pairs.toArray(pair, array, 0);
    }

    public static <CommonSuperType, First extends CommonSuperType, Second extends CommonSuperType> CommonSuperType[] toArray(Pair<First, Second> pair, CommonSuperType[] target, int offset) {
        target[offset] = pair.getFirst();
        target[offset + 1] = pair.getSecond();
        return target;
    }

    public static <First extends Comparable<? super First>, Second extends Comparable<? super Second>> int compare(Pair<First, Second> left, Pair<First, Second> right) {
        return Pairs.compare((Comparable)left.getFirst(), (Comparable)left.getSecond(), (Comparable)right.getFirst(), (Comparable)right.getSecond());
    }

    public static <First extends Comparable<? super First>, Second extends Comparable<? super Second>> int compare(First firstOfLeft, Second secondOfLeft, First firstOfRight, Second secondOfRight) {
        if (firstOfLeft == null) {
            if (firstOfRight == null) {
                if (secondOfLeft == null) {
                    if (secondOfRight == null) {
                        return 0;
                    }
                    return -1;
                }
                if (secondOfRight == null) {
                    return 1;
                }
                return secondOfLeft.compareTo(secondOfRight);
            }
            return 1;
        }
        int comparisonOfFirsts = firstOfLeft.compareTo(firstOfRight);
        if (comparisonOfFirsts != 0) {
            return comparisonOfFirsts;
        }
        if (secondOfLeft == null) {
            if (secondOfRight == null) {
                return 0;
            }
            return -1;
        }
        if (secondOfRight == null) {
            return 1;
        }
        return secondOfLeft.compareTo(secondOfRight);
    }

    public static <K, V, M extends Map<K, V>> M toMap(Iterable<Pair<K, V>> pairs, Class<M> mapType) {
        try {
            Map map = (Map)mapType.newInstance();
            return (M)Pairs.toMap(pairs, map);
        }
        catch (Exception exc) {
            return null;
        }
    }

    public static <K, V, M extends Map<K, V>> M toMap(Iterable<Pair<K, V>> pairs, M map) {
        if (map == null) {
            throw new IllegalArgumentException("`map' must not be null.");
        }
        try {
            for (Pair<K, V> pair : pairs) {
                map.put(pair.getFirst(), pair.getSecond());
            }
            return map;
        }
        catch (Exception exc) {
            return null;
        }
    }

    public static <F, S> boolean equals(Pair<F, S> left, Object right) {
        if (left == right) {
            return true;
        }
        if (right instanceof Pair) {
            return Objects.equals(left.getFirst(), ((Pair)right).getFirst()) && Objects.equals(left.getSecond(), ((Pair)right).getSecond());
        }
        return false;
    }

    public static <F, S> int hashCode(Pair<F, S> pair) {
        if (pair == null) {
            return 0;
        }
        int prime = 31;
        F first = pair.getFirst();
        S second = pair.getSecond();
        int result = 1;
        result = 31 * result + (first == null ? 0 : first.hashCode());
        result = 31 * result + (second == null ? 0 : second.hashCode());
        return result;
    }

    private Pairs() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

