/*
 * Decompiled with CFR 0.152.
 */
package de.scravy.maven.waitfor;

import de.scravy.bedrock.Control;
import de.scravy.bedrock.Seq;
import de.scravy.maven.waitfor.Check;
import de.scravy.maven.waitfor.Header;
import de.scravy.maven.waitfor.HttpMethod;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="waitfor", threadSafe=true)
public class WaitForMojo
extends AbstractMojo {
    @Parameter
    Check[] checks;
    @Parameter(defaultValue="30")
    int timeoutSeconds;
    @Parameter(defaultValue="500")
    int checkEveryMillis;
    @Parameter(defaultValue="false")
    boolean quiet;
    @Parameter(defaultValue="false")
    boolean chatty;
    @Parameter(defaultValue="false")
    boolean insecure;
    @Parameter(defaultValue="true")
    boolean redirect;
    @Parameter(defaultValue="false")
    protected boolean skip;

    public Check[] getChecks() {
        return this.checks;
    }

    public void setChecks(Check[] checks) {
        this.checks = checks;
    }

    public int getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public void setTimeoutSeconds(int timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    private int timeoutInMillis() {
        return this.timeoutSeconds * 1000;
    }

    private RequestConfig requestConfig() {
        int timeoutInMillis = this.timeoutInMillis();
        return RequestConfig.custom().setConnectionRequestTimeout(timeoutInMillis).setSocketTimeout(timeoutInMillis).setConnectTimeout(timeoutInMillis).build();
    }

    private void info(String message) {
        if (!this.quiet) {
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)(">>> " + message));
            this.getLog().info((CharSequence)"");
        }
    }

    private void warn(String message) {
        if (!this.quiet) {
            this.getLog().warn((CharSequence)message);
        }
    }

    private void alwaysInfo(String message) {
        this.getLog().info((CharSequence)message);
    }

    private void alwaysWarn(String message) {
        this.getLog().warn((CharSequence)message);
    }

    private HttpUriRequest httpUriRequest(Check check, URI uri) throws MojoFailureException, UnsupportedEncodingException {
        switch (Optional.ofNullable(check.getMethod()).orElse(HttpMethod.GET)) {
            case HEAD: {
                HttpHead httpHead = new HttpHead(uri);
                httpHead.setConfig(this.requestConfig());
                return httpHead;
            }
            case GET: {
                HttpGet httpGet = new HttpGet(uri);
                httpGet.setConfig(this.requestConfig());
                return httpGet;
            }
            case POST: {
                HttpPost httpPost = new HttpPost(uri);
                httpPost.setEntity((HttpEntity)new StringEntity(Optional.ofNullable(check.getRequestBody()).orElse("")));
                httpPost.setConfig(this.requestConfig());
                return httpPost;
            }
            case PUT: {
                HttpPut httpPut = new HttpPut(uri);
                httpPut.setEntity((HttpEntity)new StringEntity(Optional.ofNullable(check.getRequestBody()).orElse("")));
                httpPut.setConfig(this.requestConfig());
                return httpPut;
            }
        }
        throw new MojoFailureException("Unknown request method " + (Object)((Object)check.getMethod()));
    }

    private CloseableHttpClient getHttpClient() {
        HttpClientBuilder clientBuilder = HttpClients.custom();
        clientBuilder.disableAutomaticRetries();
        if (this.insecure) {
            try {
                SSLContextBuilder builder = new SSLContextBuilder();
                builder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
                SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(builder.build());
                clientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf);
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
                this.warn("Can not generate the ssl context for self signed certificates. " + e.getMessage());
            }
        }
        if (!this.redirect) {
            clientBuilder.disableRedirectHandling();
        }
        return clientBuilder.build();
    }

    public void execute() throws MojoFailureException {
        if (this.skip) {
            this.alwaysInfo("Checks are skipped.");
            return;
        }
        if (this.checks == null || this.checks.length == 0) {
            this.alwaysWarn("No checks configured");
            return;
        }
        try (CloseableHttpClient httpClient = this.getHttpClient();){
            boolean[] results = new boolean[this.checks.length];
            long startedAt = System.nanoTime();
            int i = 0;
            while (true) {
                if (Seq.ofGenerator(ix -> results[ix], (int)results.length).forAll(x -> x)) {
                    this.alwaysInfo("All checks returned successfully.");
                    break;
                }
                this.info("Not all checks passed. Trying again...");
                Duration elapsed = Duration.of(System.nanoTime() - startedAt, ChronoUnit.NANOS);
                if (elapsed.toMillis() > (long)this.timeoutInMillis()) {
                    throw new MojoFailureException("Timed out after " + elapsed.toMillis() + "ms");
                }
                if (i > 0) {
                    Control.sleep((Duration)Duration.ofMillis(this.checkEveryMillis));
                }
                for (int index = 0; index < this.checks.length; ++index) {
                    URI uri;
                    Check check = this.checks[index];
                    try {
                        uri = check.getUrl().toURI();
                    }
                    catch (URISyntaxException exc) {
                        throw new MojoFailureException("Invalid url " + check.getUrl() + " for url with index " + index, (Throwable)exc);
                    }
                    if (results[index]) continue;
                    this.info("Checking " + uri + "...");
                    HttpUriRequest httpUriRequest = this.httpUriRequest(check, uri);
                    for (Header header : Optional.ofNullable(check.getHeaders()).orElse(new Header[0])) {
                        httpUriRequest.setHeader(header.getName(), header.getValue());
                    }
                    try (CloseableHttpResponse httpResponse = httpClient.execute(httpUriRequest);){
                        int statusCode = httpResponse.getStatusLine().getStatusCode();
                        String response = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
                        if (this.chatty) {
                            this.getLog().info((CharSequence)(uri + " responded with: " + response));
                        }
                        if (!this.checkResponse(uri, statusCode, response, check)) continue;
                        this.alwaysInfo(uri + " returned successfully (" + statusCode + ")");
                        results[index] = true;
                        continue;
                    }
                    catch (Exception exc) {
                        this.warn(uri + " failed (" + exc.getClass().getName() + ": " + exc.getMessage() + ")");
                    }
                }
                ++i;
            }
        }
        catch (MojoFailureException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new MojoFailureException(exc.getMessage(), (Throwable)exc);
        }
    }

    private boolean checkResponse(URI uri, int statusCode, String response, Check check) {
        int expectedStatusCode;
        int n = expectedStatusCode = check.getStatusCode() == 0 ? 200 : check.getStatusCode();
        if (statusCode != expectedStatusCode) {
            this.info(uri + " returned " + statusCode + " instead of expected " + expectedStatusCode);
            return false;
        }
        String expectedResponse = check.getExpectedResponseBody();
        if (expectedResponse != null && !expectedResponse.equals(response)) {
            this.info(uri + " returned " + response + " instead of expected response " + expectedResponse);
            return false;
        }
        return true;
    }
}

