/*
 * Decompiled with CFR 0.152.
 */
package stream.data;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.AbstractProcessor;
import stream.Data;
import stream.ProcessContext;
import stream.data.DataFactory;
import stream.data.Encrypt;
import stream.io.Serializer;
import stream.util.JavaSerializer;
import stream.util.MD5;

public class Decrypt
extends AbstractProcessor {
    static Logger log = LoggerFactory.getLogger(Decrypt.class);
    Serializer serializer = new JavaSerializer();
    String secret;

    public void init(ProcessContext ctx) throws Exception {
        super.init(ctx);
        if (this.secret == null) {
            throw new Exception("No 'secret' parameter specified!");
        }
        if (this.secret.trim().isEmpty()) {
            throw new Exception("Parameter 'secret' does not contain any information!");
        }
    }

    public Data process(Data input) {
        if (!input.containsKey((Object)"encrypted:id")) {
            log.warn("Item does not contain key '{}'", (Object)"encrypted:id");
            return input;
        }
        if (!input.containsKey((Object)"encrypted:data")) {
            log.warn("Item does not contain encrypted data!");
            return input;
        }
        if (!input.containsKey((Object)"encrypted:cipher")) {
            log.warn("Item does not contain cipher type (attribute '{}' is missing)!", (Object)"encrypted:cipher");
            return input;
        }
        String id = ((Serializable)input.get((Object)"encrypted:id")).toString();
        byte[] ivData = Encrypt.computeIV(id, this.secret);
        String cipher = ((Serializable)input.get((Object)"encrypted:cipher")).toString();
        log.debug("Decryption cipher '{}' = {}", (Object)cipher);
        byte[] data = (byte[])input.get((Object)"encrypted:data");
        try {
            Data item;
            Cipher c = Cipher.getInstance(cipher);
            SecretKeySpec key = new SecretKeySpec(MD5.md5((String)this.secret).getBytes(), "AES");
            IvParameterSpec iv = new IvParameterSpec(ivData);
            c.init(2, (Key)key, iv);
            data = c.doFinal(data);
            if ("json".equalsIgnoreCase("" + input.get((Object)"serializer:class"))) {
                JSONParser parser = new JSONParser(-1);
                JSONObject object = (JSONObject)parser.parse(data);
                item = DataFactory.create();
                for (String k : object.keySet()) {
                    item.put((Object)k, (Object)((Serializable)object.get((Object)k)));
                }
            } else {
                ByteArrayInputStream bais = new ByteArrayInputStream(data);
                item = (Data)this.serializer.read((InputStream)bais);
                bais.close();
            }
            log.debug("Decrypted item: {}", (Object)item);
            return item;
        }
        catch (Exception e) {
            log.error("Decryption failed: {}", (Object)e.getMessage());
            if (log.isDebugEnabled()) {
                e.printStackTrace();
            }
            return input;
        }
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }
}

