/*
 * Decompiled with CFR 0.152.
 */
package stream.data;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.Processor;
import stream.io.Sink;

public class Unfold
implements Processor {
    static Logger log = LoggerFactory.getLogger(Unfold.class);
    String key = null;
    Sink[] output;

    public Data process(Data input) {
        if (this.key == null || this.output == null) {
            return input;
        }
        Serializable value = (Serializable)input.get((Object)this.key);
        if (value == null) {
            return input;
        }
        if (value.getClass().isArray()) {
            for (int i = 0; i < Array.getLength(value); ++i) {
                Object obj = Array.get(value, i);
                if (obj == null) continue;
                if (obj instanceof Serializable) {
                    Data iteration = input.createCopy();
                    iteration.put((Object)this.key, (Object)((Serializable)obj));
                    this.emit(iteration);
                    continue;
                }
                log.warn("Cannot unfold item on key '{}' -- value '{}' for key is not serializable!", (Object)this.key, obj);
            }
            return input;
        }
        if (value instanceof Collection) {
            Collection col = (Collection)((Object)value);
            for (Object obj : col) {
                if (obj == null) continue;
                if (obj instanceof Serializable) {
                    Data iteration = input.createCopy();
                    iteration.put((Object)this.key, (Object)((Serializable)obj));
                    this.emit(iteration);
                    continue;
                }
                log.warn("Cannot unfold item on key '{}' -- value '{}' for key is not serializable!", (Object)this.key, obj);
            }
            return input;
        }
        this.emit(input.createCopy());
        return input;
    }

    public void emit(Data item) {
        if (this.output == null) {
            return;
        }
        for (Sink sink : this.output) {
            if (sink == null) continue;
            try {
                sink.write(item);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Sink[] getOutput() {
        return this.output;
    }

    public void setOutput(Sink[] output) {
        this.output = output;
    }
}

