/*
 * Decompiled with CFR 0.152.
 */
package stream.generator;

import cern.jet.random.engine.MersenneTwister64;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.data.DataFactory;
import stream.generator.ColtGaussian;
import stream.io.AbstractStream;
import stream.io.SourceURL;

public class ColtGaussianStream
extends AbstractStream {
    static Logger log = LoggerFactory.getLogger(ColtGaussianStream.class);
    protected Map<String, ColtGaussian> generators;
    protected Map<String, Class<?>> types;
    protected Long seed = System.currentTimeMillis();
    protected MersenneTwister64 seedGenerator;
    protected Double[] attributes;

    public ColtGaussianStream() {
        super((SourceURL)null);
        this.generators = new LinkedHashMap<String, ColtGaussian>();
        this.types = new LinkedHashMap();
        this.seedGenerator = new MersenneTwister64();
    }

    public void init() throws Exception {
        super.init();
        if (this.attributes == null && this.generators.isEmpty()) {
            throw new Exception("Parameter 'attributes' missing! This should be a list of mean,deviation pairs!");
        }
        if (this.attributes != null) {
            int cnt = 1;
            int i = 0;
            while (i + 1 < this.attributes.length) {
                ColtGaussian cg = new ColtGaussian(this.attributes[i], this.attributes[i + 1], this.seed);
                this.setGenerator("x" + cnt, cg);
                ++cnt;
                i += 2;
            }
        }
    }

    public Long getSeed() {
        return this.seed;
    }

    public void setSeed(Long seed) {
        this.seed = seed;
        this.seedGenerator = new MersenneTwister64(seed.intValue());
    }

    public Data generate() {
        Data item = DataFactory.create();
        for (String attribute : this.generators.keySet()) {
            ColtGaussian g = this.generators.get(attribute);
            item.put((Object)attribute, (Object)g.next());
        }
        return item;
    }

    public void setGenerator(String attribute, ColtGaussian dist) {
        this.generators.put(attribute, dist);
        if (!this.types.containsKey(attribute)) {
            this.types.put(attribute, Double.class);
        }
        if (dist.getSeed() == null) {
            Long seed = this.getNextSeed();
            log.info("Setting seed for new generator to {}", (Object)seed);
            dist.setSeed(seed);
        }
    }

    public void setAttributes(Double[] attributes) {
        this.attributes = attributes;
    }

    public Data readNext() throws Exception {
        return this.generate();
    }

    public String getDescription() {
        StringBuffer s = new StringBuffer();
        s.append("<p>");
        s.append("This is a pseudo-randomized generated data stream, consisting of " + this.types.size() + " attributes. <br/>");
        s.append("The attributes are { " + this.generators.keySet() + " } and are independently generated using the");
        s.append("following generators:");
        s.append("<table>");
        for (String att : this.types.keySet()) {
            s.append("<tr>");
            s.append("<td>");
            s.append(att);
            s.append("</td>");
            s.append("<td>");
            ColtGaussian g = this.generators.get(att);
            s.append("mean: " + g.getMean() + ", variance: " + g.getVariance());
            s.append("</td>");
            s.append("</tr>");
        }
        s.append("</p>");
        return s.toString();
    }

    public Long getNextSeed() {
        return this.seedGenerator.nextLong();
    }

    public void close() {
    }
}

