/*
 * Decompiled with CFR 0.152.
 */
package stream.generator;

import java.util.Random;
import stream.generator.DistributionFunction;

public class Gaussian
implements DistributionFunction {
    Random rnd;
    Long seed;
    Double mean = 0.0;
    Double variance = 1.0;

    public Gaussian() {
    }

    public Gaussian(Long seed) {
        this.seed = seed;
    }

    public Gaussian(Double mean, Double variance, Long seed) {
        this(seed);
        this.mean = mean;
        this.variance = variance;
    }

    public Gaussian(Double mean, Double variance) {
        this(mean, variance, null);
    }

    public Long getSeed() {
        return this.seed;
    }

    public void setSeed(Long seed) {
        this.seed = seed;
        this.rnd = new Random(this.seed);
    }

    public Double getMean() {
        return this.mean;
    }

    public void setMean(Double mean) {
        this.mean = mean;
    }

    public Double getVariance() {
        return this.variance;
    }

    public void setVariance(Double variance) {
        this.variance = variance;
    }

    public Double next() {
        if (this.rnd == null) {
            if (this.seed == null) {
                this.seed = System.currentTimeMillis();
            }
            this.rnd = new Random(this.seed);
        }
        return this.mean + this.variance * this.rnd.nextGaussian();
    }

    public Double nextGaussian() {
        if (this.rnd == null) {
            if (this.seed == null) {
                this.seed = System.currentTimeMillis();
            }
            this.rnd = new Random(this.seed);
        }
        return this.rnd.nextGaussian();
    }

    public String toHtml() {
        return "<p>Gaussian, mean: <i>" + this.mean + "</i>, variance: <i>" + this.variance + "</i>, random seed: <code>" + this.seed + "</code></p>";
    }

    public String toString() {
        return "N(" + this.mean + ", " + this.variance + ")";
    }

    @Override
    public Double p(Double x) {
        return Gaussian.phi(x, this.mean, this.variance);
    }

    public static double phi(double x) {
        return Math.exp(-x * x / 2.0) / Math.sqrt(Math.PI * 2);
    }

    public static double phi(double x, double mu, double sigma) {
        return Gaussian.phi((x - mu) / sigma) / sigma;
    }

    public static double Phi(double z) {
        if (z < -8.0) {
            return 0.0;
        }
        if (z > 8.0) {
            return 1.0;
        }
        double sum = 0.0;
        double term = z;
        int i = 3;
        while (sum + term != sum) {
            sum += term;
            term = term * z * z / (double)i;
            i += 2;
        }
        return 0.5 + sum * Gaussian.phi(z);
    }

    public static double Phi(double z, double mu, double sigma) {
        return Gaussian.Phi((z - mu) / sigma);
    }
}

