/*
 * Decompiled with CFR 0.152.
 */
package stream.generator;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import stream.Data;
import stream.io.AbstractStream;
import stream.io.SourceURL;
import stream.io.Stream;

public class MixedStream
extends AbstractStream {
    Double totalWeight = 0.0;
    List<Double> weights = new ArrayList<Double>();
    List<Stream> streams = new ArrayList<Stream>();
    Random rnd = new Random();

    public MixedStream(SourceURL url) {
        super(url);
    }

    public void add(Double weight, Stream stream) {
        this.streams.add(stream);
        this.weights.add(this.totalWeight + weight);
        this.totalWeight = this.totalWeight + weight;
    }

    protected int choose() {
        double d = this.rnd.nextDouble();
        Double t = d * this.totalWeight;
        for (int i = 0; i < this.weights.size(); ++i) {
            if (i + 1 >= this.weights.size() || !(this.weights.get(i + 1) > t)) continue;
            return i;
        }
        return this.weights.size() - 1;
    }

    public Data readNext() throws Exception {
        int i = this.choose();
        return this.streams.get(i).read();
    }
}

