/*
 * Decompiled with CFR 0.152.
 */
package stream.io;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import stream.ConditionedProcessor;
import stream.Data;
import stream.Keys;
import stream.annotations.Parameter;

public abstract class AbstractWriter
extends ConditionedProcessor {
    String url;
    protected Keys keys;

    public Data processMatchingData(Data data) {
        try {
            this.write(data);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return data;
    }

    public Keys getKeys() {
        return this.keys;
    }

    @Parameter(description="The keys, which shall be written out (supports wildcards *, ? and negation with !", defaultValue="*")
    public void setKeys(Keys keys) {
        this.keys = keys;
    }

    public String getUrl() {
        return this.url;
    }

    @Parameter(description="The URL to write to, currently, only file URLs are supported.", required=true)
    public void setUrl(String url) {
        this.url = url;
    }

    protected Set<String> selectedKeys(Data item) {
        if (this.keys == null) {
            return new LinkedHashSet<String>(item.keySet());
        }
        return this.keys.select((Collection)item.keySet());
    }

    public abstract void write(Data var1) throws Exception;
}

